/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ISearchPattern;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportEdit;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResult;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.structure.ReferenceFinderUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEditCopier;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRange;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

class MoveCuUpdateCreator {
    private ICompilationUnit[] fCus;
    private IPackageFragment fDestination;
    private CodeGenerationSettings fSettings;
    private Map fImportEdits;

    public MoveCuUpdateCreator(ICompilationUnit cu, IPackageFragment pack, CodeGenerationSettings settings) {
        this(new ICompilationUnit[]{cu}, pack, settings);
    }

    public MoveCuUpdateCreator(ICompilationUnit[] cus, IPackageFragment pack, CodeGenerationSettings settings) {
        Assert.isNotNull(cus);
        Assert.isNotNull(pack);
        Assert.isNotNull(settings);
        this.fCus = MoveCuUpdateCreator.convertToOriginals(cus);
        this.fDestination = pack;
        this.fSettings = settings;
        this.fImportEdits = new HashMap();
    }

    private static ICompilationUnit[] convertToOriginals(ICompilationUnit[] cus) {
        ICompilationUnit[] result = new ICompilationUnit[cus.length];
        int i = 0;
        while (i < cus.length) {
            result[i] = MoveCuUpdateCreator.convertToOriginal(cus[i]);
            ++i;
        }
        return result;
    }

    private static ICompilationUnit convertToOriginal(ICompilationUnit cu) {
        if (!cu.isWorkingCopy()) {
            return cu;
        }
        return (ICompilationUnit)cu.getOriginalElement();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TextChangeManager createChangeManager(IProgressMonitor pm) throws JavaModelException {
        TextChangeManager textChangeManager;
        pm.beginTask("", 2);
        try {
            try {
                TextChangeManager changeManager = new TextChangeManager();
                this.addUpdates(changeManager, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                this.addImportsToDestinationPackage((IProgressMonitor)new SubProgressMonitor(pm, 1));
                Iterator iter = this.fImportEdits.keySet().iterator();
                while (true) {
                    if (!iter.hasNext()) {
                        textChangeManager = changeManager;
                        Object var6_9 = null;
                        break;
                    }
                    ICompilationUnit cu = (ICompilationUnit)iter.next();
                    ImportEdit importEdit = (ImportEdit)this.fImportEdits.get(cu);
                    if (importEdit == null || importEdit.isEmpty()) continue;
                    changeManager.get(cu).addTextEdit(RefactoringCoreMessages.getString("MoveCuUpdateCreator.update_imports"), importEdit);
                }
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return textChangeManager;
    }

    private void addUpdates(TextChangeManager changeManager, IProgressMonitor pm) throws CoreException {
        pm.beginTask("", this.fCus.length);
        int i = 0;
        while (i < this.fCus.length) {
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.addUpdates(changeManager, this.fCus[i], (IProgressMonitor)new SubProgressMonitor(pm, 1));
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addUpdates(TextChangeManager changeManager, ICompilationUnit movedUnit, IProgressMonitor pm) throws CoreException {
        block4: {
            block3: {
                try {
                    pm.beginTask("", 3);
                    pm.subTask(RefactoringCoreMessages.getFormattedString("MoveCuUpdateCreator.searching", movedUnit.getElementName()));
                    if (this.isDestinationAnotherFragmentOfSamePackage(movedUnit)) {
                        pm.worked(3);
                        Object var4_4 = null;
                        break block3;
                    }
                    this.addImportToSourcePackageTypes(movedUnit, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    this.removeImportsToDestinationPackageTypes(movedUnit);
                    this.addReferenceUpdates(changeManager, movedUnit, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    pm.done();
                    throw throwable;
                }
            }
            pm.done();
            return;
        }
        Object var4_6 = null;
        pm.done();
    }

    private boolean isDestinationAnotherFragmentOfSamePackage(ICompilationUnit movedUnit) {
        if (!(movedUnit.getParent() instanceof IPackageFragment)) {
            return false;
        }
        IPackageFragment sourcePackage = (IPackageFragment)movedUnit.getParent();
        return !this.fDestination.equals(sourcePackage) && this.fDestination.getJavaProject().equals(sourcePackage.getJavaProject()) && this.fDestination.getElementName().equals(sourcePackage.getElementName());
    }

    private void addReferenceUpdates(TextChangeManager changeManager, ICompilationUnit movedUnit, IProgressMonitor pm) throws JavaModelException, CoreException {
        SearchResultGroup[] references = MoveCuUpdateCreator.getReferences(movedUnit, pm);
        int i = 0;
        while (i < references.length) {
            ICompilationUnit referencingCu = references[i].getCompilationUnit();
            if (referencingCu != null) {
                SearchResult[] results = references[i].getSearchResults();
                int j = 0;
                while (j < results.length) {
                    if (MoveCuUpdateCreator.isQualifiedReference(results[j])) {
                        UpdateTypeReferenceEdit edit = new UpdateTypeReferenceEdit(results[j], MoveCuUpdateCreator.getPackage(movedUnit), this.fDestination);
                        changeManager.get(referencingCu).addTextEdit(RefactoringCoreMessages.getString("MoveCuUpdateCreator.update_references"), edit);
                    }
                    if (results[j].getEnclosingElement().getElementType() == 13) {
                        ImportEdit importEdit = this.getImportEdit(referencingCu);
                        IImportDeclaration importDecl = (IImportDeclaration)results[j].getEnclosingElement();
                        importEdit.removeImport(importDecl.getElementName());
                        importEdit.addImport(this.createStringForNewImport(movedUnit, importDecl));
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private String createStringForNewImport(ICompilationUnit movedUnit, IImportDeclaration importDecl) {
        return new StringBuffer(importDecl.getElementName()).replace(0, movedUnit.getParent().getElementName().length(), this.fDestination.getElementName()).toString();
    }

    private void removeImportsToDestinationPackageTypes(ICompilationUnit movedUnit) throws JavaModelException {
        ImportEdit importEdit = this.getImportEdit(movedUnit);
        IType[] destinationTypes = this.getDestinationPackageTypes();
        int i = 0;
        while (i < destinationTypes.length) {
            importEdit.removeImport(JavaModelUtil.getFullyQualifiedName(destinationTypes[i]));
            ++i;
        }
    }

    private IType[] getDestinationPackageTypes() throws JavaModelException {
        ArrayList<IType> types = new ArrayList<IType>();
        ICompilationUnit[] cus = this.fDestination.getCompilationUnits();
        int i = 0;
        while (i < cus.length) {
            types.addAll(Arrays.asList(cus[i].getAllTypes()));
            ++i;
        }
        return types.toArray(new IType[types.size()]);
    }

    private void addImportToSourcePackageTypes(ICompilationUnit movedUnit, IProgressMonitor pm) throws JavaModelException {
        List<ICompilationUnit> cuList = Arrays.asList(this.fCus);
        IType[] allCuTypes = movedUnit.getAllTypes();
        IType[] referencedTypes = ReferenceFinderUtil.getTypesReferencedIn((IJavaElement[])allCuTypes, pm);
        ImportEdit importEdit = this.getImportEdit(movedUnit);
        importEdit.setFilterImplicitImports(false);
        IPackageFragment srcPack = (IPackageFragment)movedUnit.getParent();
        int i = 0;
        while (i < referencedTypes.length) {
            IType iType = referencedTypes[i];
            if (iType.exists() && iType.getPackageFragment().equals(srcPack) && !cuList.contains(iType.getCompilationUnit())) {
                importEdit.addImport(JavaModelUtil.getFullyQualifiedName(iType));
            }
            ++i;
        }
    }

    private void addImportsToDestinationPackage(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", this.fCus.length);
        ICompilationUnit[] cusThatNeedIt = this.collectCusThatWillImportDestinationPackage(pm);
        int i = 0;
        while (i < cusThatNeedIt.length) {
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            ICompilationUnit iCompilationUnit = cusThatNeedIt[i];
            this.addImport(false, this.fDestination, iCompilationUnit);
            pm.worked(1);
            ++i;
        }
    }

    private boolean addImport(boolean force, IPackageFragment pack, ICompilationUnit cu) throws JavaModelException {
        if (pack.isDefaultPackage()) {
            return false;
        }
        if (cu.getImport(String.valueOf(pack.getElementName()) + ".*").exists()) {
            return false;
        }
        ImportEdit importEdit = this.getImportEdit(cu);
        importEdit.setFilterImplicitImports(!force);
        importEdit.addImport(String.valueOf(pack.getElementName()) + ".*");
        return true;
    }

    private ImportEdit getImportEdit(ICompilationUnit cu) throws JavaModelException {
        if (this.fImportEdits.containsKey(cu)) {
            return (ImportEdit)this.fImportEdits.get(cu);
        }
        ImportEdit importEdit = new ImportEdit(cu, this.fSettings);
        this.fImportEdits.put(cu, importEdit);
        return importEdit;
    }

    private ICompilationUnit[] collectCusThatWillImportDestinationPackage(IProgressMonitor pm) throws JavaModelException {
        HashSet collected = new HashSet();
        pm.beginTask("", this.fCus.length);
        int i = 0;
        while (i < this.fCus.length) {
            collected.addAll(this.collectCusThatWillImportDestinationPackage(this.fCus[i], (IProgressMonitor)new SubProgressMonitor(pm, 1)));
            ++i;
        }
        return collected.toArray(new ICompilationUnit[collected.size()]);
    }

    private Set collectCusThatWillImportDestinationPackage(ICompilationUnit movedUnit, IProgressMonitor pm) throws JavaModelException {
        SearchResultGroup[] references = MoveCuUpdateCreator.getReferences(movedUnit, pm);
        HashSet<ICompilationUnit> result = new HashSet<ICompilationUnit>();
        List<ICompilationUnit> cuList = Arrays.asList(this.fCus);
        int i = 0;
        while (i < references.length) {
            SearchResultGroup searchResultGroup = references[i];
            ICompilationUnit referencingCu = references[i].getCompilationUnit();
            if (referencingCu != null && this.needsImportToDestinationPackage(movedUnit, cuList, searchResultGroup, referencingCu)) {
                result.add(referencingCu);
            }
            ++i;
        }
        return result;
    }

    private boolean needsImportToDestinationPackage(ICompilationUnit movedUnit, List cuList, SearchResultGroup searchResultGroup, ICompilationUnit referencingCu) throws JavaModelException {
        if (!MoveCuUpdateCreator.hasSimpleReference(searchResultGroup)) {
            return false;
        }
        if (referencingCu.equals(movedUnit)) {
            return false;
        }
        if (cuList.contains(referencingCu)) {
            return false;
        }
        if (this.isDestinationAnotherFragmentOfSamePackage(movedUnit)) {
            return false;
        }
        if (referencingCu.getImport(String.valueOf(movedUnit.getParent().getElementName()) + ".*").exists()) {
            return true;
        }
        return referencingCu.getParent().equals(movedUnit.getParent());
    }

    private static boolean hasSimpleReference(SearchResultGroup searchResultGroup) throws JavaModelException {
        SearchResult[] results = searchResultGroup.getSearchResults();
        int i = 0;
        while (i < results.length) {
            if (!MoveCuUpdateCreator.isQualifiedReference(results[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static SearchResultGroup[] getReferences(ICompilationUnit unit, IProgressMonitor pm) throws JavaModelException {
        IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)unit);
        ISearchPattern pattern = MoveCuUpdateCreator.createSearchPattern(unit);
        return RefactoringSearchEngine.search((IProgressMonitor)new SubProgressMonitor(pm, 1), scope, pattern);
    }

    private static boolean isQualifiedReference(SearchResult searchResult) throws JavaModelException {
        if (searchResult.getEnclosingElement() instanceof IImportDeclaration) {
            return false;
        }
        ICompilationUnit cu = searchResult.getCompilationUnit();
        if (cu == null) {
            return false;
        }
        int offset = searchResult.getStart();
        int end = searchResult.getEnd();
        String source = cu.getBuffer().getText(offset, end - offset);
        return source.indexOf(".") != -1;
    }

    private static IPackageFragment getPackage(ICompilationUnit cu) {
        return (IPackageFragment)cu.getParent();
    }

    private static ISearchPattern createSearchPattern(ICompilationUnit cu) throws JavaModelException {
        return RefactoringSearchEngine.createSearchPattern((IJavaElement[])cu.getTypes(), 2);
    }

    private static final class UpdateTypeReferenceEdit
    extends SimpleTextEdit {
        private SearchResult fSearchResult;
        private IPackageFragment fDestination;
        private IPackageFragment fSource;

        UpdateTypeReferenceEdit(SearchResult searchResult, IPackageFragment source, IPackageFragment destination) {
            this.fSearchResult = searchResult;
            this.fDestination = destination;
            this.fSource = source;
        }

        protected TextEdit copy0(TextEditCopier copier) {
            return new UpdateTypeReferenceEdit(this.fSearchResult, this.fSource, this.fDestination);
        }

        public void connect(TextBuffer buffer) throws CoreException {
            int length = this.fSearchResult.getEnd() - this.fSearchResult.getStart();
            int offset = this.fSearchResult.getStart();
            String newText = this.fDestination.getElementName();
            String oldText = buffer.getContent(offset, length);
            String currectPackageName = this.fSource.getElementName();
            if (this.fSource.isDefaultPackage()) {
                length = 0;
            } else if (!oldText.startsWith(currectPackageName)) {
                length = 0;
                newText = "";
            } else {
                length = currectPackageName.length();
            }
            this.setText(newText);
            this.setTextRange(new TextRange(offset, length));
            super.connect(buffer);
        }
    }
}

