/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.reorg.SourceRangeComputer;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEditCopier;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRange;

public final class DeleteSourceReferenceEdit
extends SimpleTextEdit {
    private ISourceReference fSourceReference;
    private ICompilationUnit fCu;
    private String fContent;

    public DeleteSourceReferenceEdit(ISourceReference sr, ICompilationUnit unit) {
        Assert.isNotNull(sr);
        this.fSourceReference = sr;
        Assert.isNotNull(unit);
        this.fCu = unit;
    }

    public final String getContent() {
        return this.fContent;
    }

    public Object getModifiedElement() {
        try {
            IJavaElement element = this.fCu.getElementAt(this.fSourceReference.getSourceRange().getOffset());
            if (element != null) {
                return element.getParent();
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    protected TextEdit copy0(TextEditCopier copier) {
        return new DeleteSourceReferenceEdit(this.fSourceReference, this.fCu);
    }

    public void connect(TextBuffer buffer) throws CoreException {
        this.setText("");
        ISourceRange range = SourceRangeComputer.computeSourceRange(this.fSourceReference, this.fCu.getSource());
        this.setTextRange(new TextRange(range));
        super.connect(buffer);
    }

    public void perform(TextBuffer buffer) throws CoreException {
        TextRange range = this.getTextRange();
        this.fContent = buffer.getContent(range.getOffset(), range.getLength());
        super.perform(buffer);
    }
}

