/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceManipulation;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.NullChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.DeleteFileChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DeleteFolderChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DeleteFromClasspathChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DeletePackageFragmentRootChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DeleteSourceManipulationChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IPackageFragmentRootManipulationQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;

public class DeleteRefactoring
extends Refactoring {
    private List fElements;
    private boolean fCheckIfUsed;
    private final IPackageFragmentRootManipulationQuery fRootManipulationQuery;

    public DeleteRefactoring(List elements, IPackageFragmentRootManipulationQuery rootManipulationQuery) {
        Assert.isNotNull(elements);
        this.fElements = DeleteRefactoring.convertToInputElements(elements);
        this.fRootManipulationQuery = rootManipulationQuery;
    }

    private static List convertToInputElements(List elements) {
        ArrayList<Object> result = new ArrayList<Object>(elements.size());
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (each instanceof IPackageFragment && ((IPackageFragment)each).isDefaultPackage()) {
                IPackageFragment pack = (IPackageFragment)each;
                try {
                    result.addAll(Arrays.asList(pack.getCompilationUnits()));
                }
                catch (JavaModelException javaModelException) {}
                continue;
            }
            result.add(each);
        }
        return result;
    }

    public List getElementsToDelete() {
        return this.fElements;
    }

    public void setCheckIfUsed(boolean check) {
        this.fCheckIfUsed = check;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block8: {
            RefactoringStatus refactoringStatus2;
            block7: {
                RefactoringStatus refactoringStatus3;
                block6: {
                    RefactoringStatus refactoringStatus4;
                    block5: {
                        pm.beginTask("", 1);
                        try {
                            if (this.fElements.isEmpty()) {
                                refactoringStatus4 = RefactoringStatus.createFatalErrorStatus("");
                                Object var2_6 = null;
                                break block5;
                            }
                            if (this.hasProjects() && this.hasNonProjects()) {
                                refactoringStatus3 = RefactoringStatus.createFatalErrorStatus("");
                                break block6;
                            }
                            if (!this.canDeleteAll()) {
                                refactoringStatus2 = RefactoringStatus.createFatalErrorStatus("");
                                break block7;
                            }
                            refactoringStatus = new RefactoringStatus();
                            break block8;
                        }
                        catch (Throwable throwable) {
                            Object var2_10 = null;
                            pm.done();
                            throw throwable;
                        }
                    }
                    pm.done();
                    return refactoringStatus4;
                }
                Object var2_7 = null;
                pm.done();
                return refactoringStatus3;
            }
            Object var2_8 = null;
            pm.done();
            return refactoringStatus2;
        }
        Object var2_9 = null;
        pm.done();
        return refactoringStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block4: {
            RefactoringStatus refactoringStatus2;
            block3: {
                pm.beginTask("", 1);
                try {
                    RefactoringStatus result = new RefactoringStatus();
                    result.merge(this.checkReadOnlyStatus());
                    if (!this.fCheckIfUsed) {
                        refactoringStatus2 = result;
                        Object var3_5 = null;
                        break block3;
                    }
                    refactoringStatus = result;
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var3_7 = null;
                    pm.done();
                    throw throwable;
                }
            }
            pm.done();
            return refactoringStatus2;
        }
        Object var3_6 = null;
        pm.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkReadOnlyStatus() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        Iterator iter = this.fElements.iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (!Checks.isReadOnly(each)) continue;
            result.addError(RefactoringCoreMessages.getFormattedString("DeleteRefactoring.read_only", ReorgUtils.getName(each)));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        CompositeChange compositeChange;
        block5: {
            NullChange nullChange;
            block4: {
                pm.beginTask("", 1);
                try {
                    this.prepareElementList();
                    CompositeChange composite = new CompositeChange();
                    Iterator iter = this.fElements.iterator();
                    while (true) {
                        if (!iter.hasNext()) {
                            if (composite.getChildren() != null) break;
                            nullChange = new NullChange();
                            Object var5_7 = null;
                            break block4;
                        }
                        IChange change = this.createDeleteChange(iter.next());
                        if (change == null) continue;
                        composite.add(change);
                    }
                    compositeChange = composite;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    pm.done();
                    throw throwable;
                }
            }
            pm.done();
            return nullChange;
        }
        Object var5_8 = null;
        pm.done();
        return compositeChange;
    }

    private void prepareElementList() throws JavaModelException {
        Collections.sort(this.fElements, DeleteRefactoring.createPathComparator());
        this.fElements = DeleteRefactoring.removeSubElements(this.fElements);
    }

    private static List removeSubElements(List list) throws JavaModelException {
        ArrayList newList = new ArrayList(list.size());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (DeleteRefactoring.hasParentOnList(each, list)) continue;
            newList.add(each);
        }
        return newList;
    }

    private static boolean hasParentOnList(Object element, List list) throws JavaModelException {
        IPath elementPath = DeleteRefactoring.getPath(element);
        if (elementPath == null) {
            return false;
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object parent = iter.next();
            IPath parentPath = DeleteRefactoring.getPath(parent);
            if (parentPath == null) {
                return false;
            }
            if (element instanceof IPackageFragment && parent instanceof IPackageFragment || parentPath.equals((Object)elementPath) || !parentPath.isPrefixOf(elementPath)) continue;
            return true;
        }
        return false;
    }

    private static IPath getPath(Object o) throws JavaModelException {
        if (o instanceof IJavaElement) {
            IJavaElement je = (IJavaElement)o;
            return je.getPath();
        }
        if (o instanceof IResource) {
            return ((IResource)o).getFullPath();
        }
        return null;
    }

    private static Comparator createPathComparator() {
        return new Comparator(){

            public int compare(Object left, Object right) {
                return this.getPathLength(right) - this.getPathLength(left);
            }

            private int getPathLength(Object o) {
                try {
                    IPath path = DeleteRefactoring.getPath(o);
                    if (path == null) {
                        return 0;
                    }
                    return path.segmentCount();
                }
                catch (JavaModelException javaModelException) {
                    return 0;
                }
            }
        };
    }

    private IChange createDeleteChange(Object o) throws JavaModelException {
        if (o instanceof IPackageFragmentRoot) {
            return this.createDeleteChange((IPackageFragmentRoot)o);
        }
        if (o instanceof ISourceManipulation) {
            IResource resource;
            ISourceManipulation element = (ISourceManipulation)o;
            if ((element instanceof ICompilationUnit || element instanceof IPackageFragment) && element instanceof IJavaElement && (resource = ((IJavaElement)element).getResource()).isLinked()) {
                return this.createDeleteChange(resource);
            }
            return new DeleteSourceManipulationChange(element);
        }
        if (o instanceof IJavaElement) {
            return this.createDeleteChange(DeleteRefactoring.getResourceToDelete((IJavaElement)o));
        }
        if (o instanceof IResource) {
            return this.createDeleteChange((IResource)o);
        }
        return new NullChange();
    }

    private static IResource getResourceToDelete(IJavaElement element) {
        if (!element.exists()) {
            return null;
        }
        Assert.isTrue(!(element instanceof ISourceManipulation));
        return element.getResource();
    }

    private IChange createDeleteChange(IResource res) throws JavaModelException {
        if (res == null) {
            return null;
        }
        if (!res.exists()) {
            return null;
        }
        if (res instanceof IFile) {
            return new DeleteFileChange((IFile)res);
        }
        if (res instanceof IFolder) {
            return this.createDeleteChange((IFolder)res, false);
        }
        Assert.isTrue(!(res instanceof IProject));
        return new NullChange();
    }

    private IChange createDeleteChange(IFolder folder, boolean removeContentOnly) throws JavaModelException {
        if (!removeContentOnly) {
            return new DeleteFolderChange(folder);
        }
        IResource[] members = DeleteRefactoring.getMembers(folder);
        if (members.length == 0) {
            return new NullChange();
        }
        CompositeChange composite = new CompositeChange(RefactoringCoreMessages.getString("DeleteRefactoring.delete_resources"), members.length);
        int i = 0;
        while (i < members.length) {
            composite.add(this.createDeleteChange(members[i]));
            ++i;
        }
        return composite;
    }

    private IChange createDeleteChange(IPackageFragmentRoot root) throws JavaModelException {
        IResource resource = ResourceUtil.getResource(root);
        if (resource != null && resource.isLinked()) {
            CompositeChange composite = new CompositeChange(RefactoringCoreMessages.getString("DeleteRefactoring.delete_package_fragment_root"), 2);
            composite.add(new DeleteFromClasspathChange(root));
            if (!ReorgUtils.isClasspathDelete(root)) {
                composite.add(this.createDeleteChange(DeleteRefactoring.getResourceToDelete((IJavaElement)root)));
            }
            return composite;
        }
        Assert.isTrue(!root.isExternal());
        return new DeletePackageFragmentRootChange(root, this.fRootManipulationQuery);
    }

    private static IResource[] getMembers(IFolder folder) throws JavaModelException {
        try {
            return folder.members();
        }
        catch (JavaModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    public String getName() {
        return RefactoringCoreMessages.getString("DeleteRefactoring.delete");
    }

    private boolean hasNonProjects() {
        Iterator iter = this.fElements.iterator();
        while (iter.hasNext()) {
            if (DeleteRefactoring.isProject(iter.next())) continue;
            return true;
        }
        return false;
    }

    private boolean hasProjects() {
        Iterator iter = this.fElements.iterator();
        while (iter.hasNext()) {
            if (!DeleteRefactoring.isProject(iter.next())) continue;
            return true;
        }
        return false;
    }

    private static boolean isProject(Object element) {
        return element instanceof IJavaProject || element instanceof IProject;
    }

    private boolean canDeleteAll() {
        Iterator iter = this.fElements.iterator();
        while (iter.hasNext()) {
            if (DeleteRefactoring.canDelete(iter.next())) continue;
            return false;
        }
        return true;
    }

    private static boolean canDelete(Object o) {
        try {
            if (o instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)o;
                if (root.isExternal()) {
                    return false;
                }
                if (Checks.isClasspathDelete(root)) {
                    return false;
                }
            }
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        if (JavaElementUtil.isDefaultPackage(o)) {
            return false;
        }
        if (o instanceof IJavaElement) {
            return DeleteRefactoring.canDelete((IJavaElement)o);
        }
        if (o instanceof IFile) {
            return DeleteRefactoring.canDelete((IFile)o);
        }
        return o instanceof IResource;
    }

    private static boolean canDelete(IJavaElement element) {
        try {
            if (!element.exists()) {
                return false;
            }
            if (element instanceof IImportDeclaration || element instanceof IImportContainer || element instanceof IMember) {
                return false;
            }
            if (element instanceof IPackageFragment && DeleteRefactoring.isEmptySuperPackage((IPackageFragment)element)) {
                return false;
            }
            IResource res = element.getResource();
            if (res == null) {
                return false;
            }
            if (!res.getProject().equals((Object)element.getJavaProject().getProject())) {
                return false;
            }
            IJavaElement parent = element.getParent();
            return parent == null || !parent.isReadOnly();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private static boolean isEmptySuperPackage(IPackageFragment iPackageFragment) throws JavaModelException {
        return iPackageFragment.hasSubpackages() && iPackageFragment.getNonJavaResources().length == 0 && iPackageFragment.getChildren().length == 0;
    }

    private static boolean canDelete(IFile file) {
        Object parent = ReorgUtils.getJavaParent(file);
        if (parent instanceof IJavaElement) {
            return !((IJavaElement)parent).isReadOnly();
        }
        return parent != null;
    }
}

