/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ISearchPattern;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResult;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.CreateTextFileChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.UpdateTypeReferenceEdit;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;

class CreateCopyOfCompilationUnitChange
extends CreateTextFileChange {
    private ICompilationUnit fOldCu;
    private INewNameQuery fNameQuery;

    public CreateCopyOfCompilationUnitChange(IPath path, String source, ICompilationUnit oldCu, INewNameQuery nameQuery) {
        super(path, source, true);
        this.fOldCu = oldCu;
        this.fNameQuery = nameQuery;
    }

    protected IFile getOldFile(IProgressMonitor pm) {
        pm.beginTask("", 10);
        String oldSource = super.getSource();
        IPath oldPath = super.getPath();
        String newTypeName = this.fNameQuery.getNewName();
        try {
            String newSource = CreateCopyOfCompilationUnitChange.getCopiedFileSource((IProgressMonitor)new SubProgressMonitor(pm, 9), this.fOldCu, newTypeName);
            this.setSource(newSource);
            this.setPath(this.constructNewPath(newTypeName));
            return super.getOldFile((IProgressMonitor)new SubProgressMonitor(pm, 1));
        }
        catch (CoreException coreException) {
            this.setSource(oldSource);
            this.setPath(oldPath);
            return super.getOldFile(pm);
        }
    }

    private IPath constructNewPath(String newTypeName) throws JavaModelException {
        return ResourceUtil.getResource(this.fOldCu).getParent().getFullPath().append(String.valueOf(newTypeName) + ".java");
    }

    private static String getCopiedFileSource(IProgressMonitor pm, ICompilationUnit cu, String newTypeName) throws CoreException {
        ICompilationUnit wc = WorkingCopyUtil.getNewWorkingCopy(cu);
        TextChangeManager manager = CreateCopyOfCompilationUnitChange.createChangeManager(pm, wc, newTypeName);
        String result = manager.get(wc).getPreviewContent();
        wc.destroy();
        return result;
    }

    private static TextChangeManager createChangeManager(IProgressMonitor pm, ICompilationUnit wc, String newName) throws CoreException {
        TextChangeManager manager = new TextChangeManager();
        SearchResultGroup refs = CreateCopyOfCompilationUnitChange.getReferences(wc, pm);
        if (refs == null) {
            return manager;
        }
        if (refs.getCompilationUnit() == null) {
            return manager;
        }
        String name = RefactoringCoreMessages.getString("CopyRefactoring.update_ref");
        SearchResult[] results = refs.getSearchResults();
        int j = 0;
        while (j < results.length) {
            SearchResult searchResult = results[j];
            int offset = searchResult.getStart();
            int length = searchResult.getEnd() - searchResult.getStart();
            manager.get(wc).addTextEdit(name, new UpdateTypeReferenceEdit(offset, length, newName, wc.findPrimaryType().getElementName()));
            ++j;
        }
        return manager;
    }

    private static SearchResultGroup getReferences(ICompilationUnit wc, IProgressMonitor pm) throws JavaModelException {
        pm.subTask(RefactoringCoreMessages.getString("CopyRefactoring.searching"));
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{wc});
        if (wc.findPrimaryType() == null) {
            return null;
        }
        ISearchPattern pattern = CreateCopyOfCompilationUnitChange.createSearchPattern(wc.findPrimaryType());
        SearchResultGroup[] groups = RefactoringSearchEngine.search(pm, scope, pattern, new ICompilationUnit[]{wc});
        Assert.isTrue(groups.length <= 1);
        if (groups.length == 0) {
            return null;
        }
        return groups[0];
    }

    private static ISearchPattern createSearchPattern(IType type) throws JavaModelException {
        ISearchPattern pattern = SearchEngine.createSearchPattern((IJavaElement)type, (int)3);
        IMethod[] constructors = JavaElementUtil.getAllConstructors(type);
        ISearchPattern constructorDeclarationPattern = RefactoringSearchEngine.createSearchPattern((IJavaElement[])constructors, 0);
        if (constructorDeclarationPattern == null) {
            return pattern;
        }
        return SearchEngine.createOrSearchPattern((ISearchPattern)pattern, (ISearchPattern)constructorDeclarationPattern);
    }
}

