/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.NullChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.CopyCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CopyPackageChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CopyPackageFragmentRootChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CopyResourceChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.CreateCopyOfCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ICopyQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IPackageFragmentRootManipulationQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;

public class CopyRefactoring
extends ReorgRefactoring {
    private Set fAutoGeneratedNewNames;
    private final ICopyQueries fCopyQueries;
    private final IPackageFragmentRootManipulationQuery fRootManipulationQuery;

    public CopyRefactoring(List elements, ICopyQueries copyQueries, IPackageFragmentRootManipulationQuery updateClasspathQuery) {
        super(elements);
        Assert.isNotNull(copyQueries);
        this.fCopyQueries = copyQueries;
        this.fAutoGeneratedNewNames = new HashSet(2);
        this.fRootManipulationQuery = updateClasspathQuery;
    }

    public String getName() {
        return RefactoringCoreMessages.getString("CopyRefactoring.copy_elements");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        pm.beginTask("", 1);
        try {
            try {
                RefactoringStatus result = new RefactoringStatus();
                result.merge(this.validateModifiesFiles());
                refactoringStatus = result;
                Object var3_6 = null;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    private IFile[] getAllFilesToModify() throws CoreException {
        ArrayList<IFile> result = new ArrayList<IFile>();
        if (this.getDestination() instanceof IPackageFragment) {
            result.addAll(Arrays.asList(ResourceUtil.getFiles(this.collectCus())));
        }
        return result.toArray(new IFile[result.size()]);
    }

    private RefactoringStatus validateModifiesFiles() throws CoreException {
        return Checks.validateModifiesFiles(this.getAllFilesToModify());
    }

    boolean isValidDestinationForCusAndFiles(Object dest) throws JavaModelException {
        return ReorgRefactoring.getDestinationForCusAndFiles(dest) != null;
    }

    private static boolean isNewNameOk(IPackageFragment dest, String newName) {
        return !dest.getCompilationUnit(newName).exists();
    }

    private static boolean isNewNameOk(IContainer container, String newName) {
        return container.findMember(newName) == null;
    }

    private static boolean isNewNameOk(IPackageFragmentRoot root, String newName) {
        return !root.getPackageFragment(newName).exists();
    }

    private String createNewName(ICompilationUnit cu, IPackageFragment dest) {
        if (CopyRefactoring.isNewNameOk(dest, cu.getElementName())) {
            return null;
        }
        if (!ReorgUtils.isParent(cu, dest)) {
            return null;
        }
        int i = 1;
        while (true) {
            String newName;
            if (CopyRefactoring.isNewNameOk(dest, newName = i == 1 ? RefactoringCoreMessages.getFormattedString("CopyRefactoring.cu.copyOf1", cu.getElementName()) : RefactoringCoreMessages.getFormattedString("CopyRefactoring.cu.copyOfMore", new String[]{String.valueOf(i), cu.getElementName()})) && !this.fAutoGeneratedNewNames.contains(newName)) {
                this.fAutoGeneratedNewNames.add(newName);
                return newName;
            }
            ++i;
        }
    }

    private String createNewName(IResource res, IContainer container) {
        if (CopyRefactoring.isNewNameOk(container, res.getName())) {
            return null;
        }
        if (!ReorgUtils.isParent(res, (IResource)container)) {
            return null;
        }
        int i = 1;
        while (true) {
            String newName;
            if (CopyRefactoring.isNewNameOk(container, newName = i == 1 ? RefactoringCoreMessages.getFormattedString("CopyRefactoring.resource.copyOf1", res.getName()) : RefactoringCoreMessages.getFormattedString("CopyRefactoring.resource.copyOfMore", new String[]{String.valueOf(i), res.getName()})) && !this.fAutoGeneratedNewNames.contains(newName)) {
                this.fAutoGeneratedNewNames.add(newName);
                return newName;
            }
            ++i;
        }
    }

    private String createNewName(IPackageFragment pack, IPackageFragmentRoot root) {
        if (CopyRefactoring.isNewNameOk(root, pack.getElementName())) {
            return null;
        }
        if (!ReorgUtils.isParent(pack, root)) {
            return null;
        }
        int i = 1;
        while (true) {
            String newName;
            if (CopyRefactoring.isNewNameOk(root, newName = i == 0 ? RefactoringCoreMessages.getFormattedString("CopyRefactoring.package.copyOf1", pack.getElementName()) : RefactoringCoreMessages.getFormattedString("CopyRefactoring.package.copyOfMore", new String[]{String.valueOf(i), pack.getElementName()})) && !this.fAutoGeneratedNewNames.contains(newName)) {
                this.fAutoGeneratedNewNames.add(newName);
                return newName;
            }
            ++i;
        }
    }

    IChange createChange(IProgressMonitor pm, IPackageFragmentRoot root) throws JavaModelException {
        IProject destinationProject;
        IResource res = root.getResource();
        String newName = this.createNewName(res, (IContainer)(destinationProject = ReorgRefactoring.getDestinationForSourceFolders(this.getDestination())));
        if (newName == null) {
            newName = res.getName();
        }
        INewNameQuery nameQuery = this.fCopyQueries.createStaticQuery(newName);
        return new CopyPackageFragmentRootChange(root, destinationProject, nameQuery, this.fRootManipulationQuery);
    }

    IChange createChange(IProgressMonitor pm, IPackageFragment pack) throws JavaModelException {
        IPackageFragmentRoot root = ReorgRefactoring.getDestinationForPackages(this.getDestination());
        String newName = this.createNewName(pack, root);
        if (newName == null || JavaConventions.validatePackageName((String)newName).getSeverity() < 4) {
            INewNameQuery nameQuery = newName == null ? this.fCopyQueries.createNullQuery() : this.fCopyQueries.createNewPackageNameQuery(pack);
            return new CopyPackageChange(pack, root, nameQuery);
        }
        if (root.getResource() instanceof IContainer) {
            IContainer dest = (IContainer)root.getResource();
            IResource res = pack.getResource();
            INewNameQuery nameQuery = this.fCopyQueries.createNewResourceNameQuery(res);
            return new CopyResourceChange(res, dest, nameQuery);
        }
        return new NullChange();
    }

    IChange createChange(IProgressMonitor pm, IResource res) throws JavaModelException {
        IContainer dest = ReorgRefactoring.getDestinationForResources(this.getDestination());
        INewNameQuery nameQuery = this.createNewName(res, dest) == null ? this.fCopyQueries.createNullQuery() : this.fCopyQueries.createNewResourceNameQuery(res);
        return new CopyResourceChange(res, dest, nameQuery);
    }

    IChange createChange(IProgressMonitor pm, ICompilationUnit cu) throws JavaModelException {
        Object dest = ReorgRefactoring.getDestinationForCusAndFiles(this.getDestination());
        if (dest instanceof IPackageFragment) {
            return this.copyCuToPackage(cu, (IPackageFragment)dest);
        }
        return this.copyFileToContainer(cu, (IContainer)dest);
    }

    private IChange copyFileToContainer(ICompilationUnit cu, IContainer dest) {
        IResource res = ResourceUtil.getResource(cu);
        INewNameQuery nameQuery = this.createNewName(res, dest) == null ? this.fCopyQueries.createNullQuery() : this.fCopyQueries.createNewResourceNameQuery(res);
        return new CopyResourceChange(res, dest, nameQuery);
    }

    private IChange copyCuToPackage(ICompilationUnit cu, IPackageFragment dest) {
        IResource res = ResourceUtil.getResource(cu);
        if (res != null && res.isLinked() && ResourceUtil.getResource(dest) instanceof IContainer) {
            return this.copyFileToContainer(cu, (IContainer)ResourceUtil.getResource(dest));
        }
        String newName = this.createNewName(cu, dest);
        CopyCompilationUnitChange simpleCopy = new CopyCompilationUnitChange(cu, dest, this.fCopyQueries.createStaticQuery(newName));
        if (newName == null || newName.equals(cu.getElementName())) {
            return simpleCopy;
        }
        try {
            IPath newPath = ResourceUtil.getResource(cu).getParent().getFullPath().append(newName);
            INewNameQuery nameQuery = this.fCopyQueries.createNewCompilationUnitNameQuery(cu);
            return new CreateCopyOfCompilationUnitChange(newPath, cu.getSource(), cu, nameQuery);
        }
        catch (CoreException coreException) {
            return simpleCopy;
        }
    }
}

