/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEditCopier;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRange;

final class UpdateMethodReferenceEdit
extends SimpleTextEdit {
    private String fOldName;

    public UpdateMethodReferenceEdit(int offset, int length, String newName, String oldName) {
        super(offset, length, newName);
        Assert.isNotNull(oldName);
        this.fOldName = oldName;
    }

    private UpdateMethodReferenceEdit(TextRange range, String newName, String oldName) {
        super(range, newName);
        Assert.isNotNull(oldName);
        this.fOldName = oldName;
    }

    protected TextEdit copy0(TextEditCopier copier) {
        return new UpdateMethodReferenceEdit(this.getTextRange().copy(), this.getText(), this.fOldName);
    }

    public void connect(TextBuffer buffer) throws CoreException {
        TextRange range = this.getTextRange();
        String oldText = buffer.getContent(range.getOffset(), range.getLength());
        String oldMethodName = this.fOldName;
        int leftBracketIndex = oldText.indexOf("(");
        if (leftBracketIndex == -1) {
            return;
        }
        int offset = range.getOffset();
        int length = leftBracketIndex;
        int theDotIndex = (oldText = oldText.substring(0, leftBracketIndex)).lastIndexOf(".");
        if (theDotIndex == -1) {
            this.setText(String.valueOf(this.getText()) + oldText.substring(oldMethodName.length()));
        } else {
            String subText = oldText.substring(theDotIndex);
            int oldNameIndex = subText.indexOf(oldMethodName) + theDotIndex;
            String ending = String.valueOf(oldText.substring(theDotIndex, oldNameIndex)) + this.getText();
            oldText = oldText.substring(0, oldNameIndex + oldMethodName.length());
            length = oldNameIndex + oldMethodName.length();
            this.setText(String.valueOf(oldText.substring(0, theDotIndex)) + ending);
        }
        this.setTextRange(new TextRange(offset, length));
    }
}

