/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;

public class TempOccurrenceFinder {
    static /* synthetic */ Class class$0;

    private TempOccurrenceFinder() {
    }

    public static Integer[] findTempOccurrenceOffsets(VariableDeclaration temp, boolean includeReferences, boolean includeDeclaration) {
        TempOccurrenceAnalyzer analyzer = new TempOccurrenceAnalyzer(temp, includeReferences, includeDeclaration);
        TempOccurrenceFinder.getCompilationUnitNode((ASTNode)temp).accept((ASTVisitor)analyzer);
        return analyzer.getOffsets();
    }

    public static ASTNode[] findTempOccurrenceNodes(VariableDeclaration temp, boolean includeReferences, boolean includeDeclaration) {
        TempOccurrenceAnalyzer analyzer = new TempOccurrenceAnalyzer(temp, includeReferences, includeDeclaration);
        TempOccurrenceFinder.getCompilationUnitNode((ASTNode)temp).accept((ASTVisitor)analyzer);
        return analyzer.getNodes();
    }

    private static CompilationUnit getCompilationUnitNode(ASTNode node) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (CompilationUnit)ASTNodes.getParent(node, clazz);
    }

    private static class TempOccurrenceAnalyzer
    extends ASTVisitor {
        private Set fNodes;
        private boolean fIncludeReferences;
        private boolean fIncludeDeclaration;
        private VariableDeclaration fTempDeclaration;
        private IBinding fTempBinding;

        TempOccurrenceAnalyzer(VariableDeclaration tempDeclaration, boolean includeReferences, boolean includeDeclaration) {
            Assert.isNotNull(tempDeclaration);
            this.fNodes = new HashSet();
            this.fIncludeDeclaration = includeDeclaration;
            this.fIncludeReferences = includeReferences;
            this.fTempDeclaration = tempDeclaration;
            this.fTempBinding = tempDeclaration.resolveBinding();
        }

        Integer[] getOffsets() {
            ArrayList<Integer> offsets = new ArrayList<Integer>(this.fNodes.size());
            Iterator iter = this.fNodes.iterator();
            while (iter.hasNext()) {
                ASTNode node = (ASTNode)iter.next();
                offsets.add(new Integer(node.getStartPosition()));
            }
            return offsets.toArray(new Integer[offsets.size()]);
        }

        ASTNode[] getNodes() {
            return this.fNodes.toArray(new ASTNode[this.fNodes.size()]);
        }

        private boolean visitNameReference(Name nameReference) {
            if (nameReference.getParent() instanceof VariableDeclaration && ((VariableDeclaration)nameReference.getParent()).getName() == nameReference) {
                return true;
            }
            if (this.fIncludeReferences && this.fTempBinding != null && this.fTempBinding == nameReference.resolveBinding()) {
                this.fNodes.add(nameReference);
            }
            return true;
        }

        private boolean visitVariableDeclaration(VariableDeclaration localDeclaration) {
            if (this.fIncludeDeclaration && this.fTempDeclaration.equals((Object)localDeclaration)) {
                this.fNodes.add(localDeclaration.getName());
            }
            return true;
        }

        public boolean visit(SingleVariableDeclaration localDeclaration) {
            return this.visitVariableDeclaration((VariableDeclaration)localDeclaration);
        }

        public boolean visit(VariableDeclarationFragment localDeclaration) {
            return this.visitVariableDeclaration((VariableDeclaration)localDeclaration);
        }

        public boolean visit(SimpleName singleNameReference) {
            return this.visitNameReference((Name)singleNameReference);
        }
    }
}

