/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.util.JdtFlags;

public class RippleMethodFinder {
    private RippleMethodFinder() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IMethod[] getRelatedMethods(IMethod method, IProgressMonitor pm, IWorkingCopy[] workingCopies) throws JavaModelException {
        IMethod[] iMethodArray;
        block6: {
            IMethod[] iMethodArray2;
            block5: {
                IMethod[] iMethodArray3;
                block4: {
                    try {
                        if (!MethodChecks.isVirtual(method) && !method.getDeclaringType().isInterface()) {
                            iMethodArray3 = new IMethod[]{method};
                            Object var3_6 = null;
                            break block4;
                        }
                        if (method.getDeclaringType().isInterface()) {
                            iMethodArray2 = RippleMethodFinder.getAllRippleMethods(method, pm, workingCopies);
                            break block5;
                        }
                        iMethodArray = RippleMethodFinder.getVirtualMethodsInHierarchy(method, pm, workingCopies);
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var3_9 = null;
                        pm.done();
                        throw throwable;
                    }
                }
                pm.done();
                return iMethodArray3;
            }
            Object var3_7 = null;
            pm.done();
            return iMethodArray2;
        }
        Object var3_8 = null;
        pm.done();
        return iMethodArray;
    }

    private static IMethod[] getAllRippleMethods(IMethod method, IProgressMonitor pm, IWorkingCopy[] workingCopies) throws JavaModelException {
        pm.beginTask("", 4);
        HashSet<IMethod> result = new HashSet<IMethod>();
        HashSet<IType> visitedTypes = new HashSet<IType>();
        ArrayList<IMethod> methodQueue = new ArrayList<IMethod>();
        methodQueue.add(method);
        while (!methodQueue.isEmpty()) {
            IMethod m = (IMethod)methodQueue.remove(0);
            if (m.isBinary()) continue;
            IType type = m.getDeclaringType();
            Assert.isTrue(!visitedTypes.contains(type), "! visitedTypes.contains(type)");
            Assert.isTrue(type.isInterface() || RippleMethodFinder.declaresAsVirtual(type, method), "second condition");
            visitedTypes.add(type);
            result.add(m);
            IType[] subTypes = type.newTypeHierarchy(workingCopies, (IProgressMonitor)new SubProgressMonitor(pm, 1)).getAllSubtypes(type);
            int i = 0;
            while (i < subTypes.length) {
                if (!visitedTypes.contains(subTypes[i]) && RippleMethodFinder.declares(subTypes[i], method)) {
                    result.add(Checks.findMethod(m, subTypes[i]));
                }
                ++i;
            }
            i = 0;
            while (i < subTypes.length) {
                IMethod toAdd = RippleMethodFinder.findAppropriateMethod(workingCopies, visitedTypes, methodQueue, subTypes[i], method, (IProgressMonitor)new NullProgressMonitor());
                if (toAdd != null) {
                    methodQueue.add(toAdd);
                }
                ++i;
            }
        }
        return result.toArray(new IMethod[result.size()]);
    }

    private static IMethod findAppropriateMethod(IWorkingCopy[] workingCopies, Set visitedTypes, List methodQueue, IType type, IMethod method, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask(RefactoringCoreMessages.getString("RippleMethodFinder.analizing_hierarchy"), 1);
        IType[] superTypes = type.newSupertypeHierarchy(workingCopies, (IProgressMonitor)new SubProgressMonitor(pm, 1)).getAllSupertypes(type);
        int i = 0;
        while (i < superTypes.length) {
            IMethod found;
            IType x = superTypes[i];
            if (!visitedTypes.contains(x) && (found = Checks.findMethod(method, x)) != null && RippleMethodFinder.declaresAsVirtual(x, method) && !methodQueue.contains(found)) {
                return RippleMethodFinder.getTopMostMethod(workingCopies, visitedTypes, methodQueue, method, x, (IProgressMonitor)new NullProgressMonitor());
            }
            ++i;
        }
        return null;
    }

    private static IMethod getTopMostMethod(IWorkingCopy[] workingCopies, Set visitedTypes, List methodQueue, IMethod method, IType type, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 1);
        Assert.isTrue(Checks.findMethod(method, type) != null);
        IType[] superTypes = type.newSupertypeHierarchy(workingCopies, (IProgressMonitor)new SubProgressMonitor(pm, 1)).getAllSupertypes(type);
        int i = 0;
        while (i < superTypes.length) {
            IMethod found;
            IType t = superTypes[i];
            if (!visitedTypes.contains(t) && (found = Checks.findMethod(method, t)) != null && RippleMethodFinder.declaresAsVirtual(t, method) && !methodQueue.contains(found)) {
                return RippleMethodFinder.getTopMostMethod(workingCopies, visitedTypes, methodQueue, method, t, (IProgressMonitor)new NullProgressMonitor());
            }
            ++i;
        }
        return Checks.findMethod(method, type);
    }

    private static boolean declares(IType type, IMethod m) throws JavaModelException {
        return Checks.findMethod(m, type) != null;
    }

    private static boolean declaresAsVirtual(IType type, IMethod m) throws JavaModelException {
        IMethod found = Checks.findMethod(m, type);
        if (found == null) {
            return false;
        }
        if (JdtFlags.isStatic((IMember)found)) {
            return false;
        }
        return !JdtFlags.isPrivate((IMember)found);
    }

    private static IMethod[] getVirtualMethodsInHierarchy(IMethod method, IProgressMonitor pm, IWorkingCopy[] workingCopies) throws JavaModelException {
        ArrayList<IMethod> methods = new ArrayList<IMethod>();
        methods.add(method);
        IType type = method.getDeclaringType();
        ITypeHierarchy hier = type.newTypeHierarchy(workingCopies, pm);
        IType[] subtypes = hier.getAllSubtypes(type);
        int i = 0;
        while (i < subtypes.length) {
            IMethod subMethod = Checks.findMethod(method, subtypes[i]);
            if (subMethod != null) {
                methods.add(subMethod);
            }
            ++i;
        }
        return methods.toArray(new IMethod[methods.size()]);
    }
}

