/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.Context;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaSourceContext;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameMethodRefactoring;
import org.eclipse.jdt.internal.corext.util.JdtFlags;

class RenameVirtualMethodRefactoring
extends RenameMethodRefactoring {
    RenameVirtualMethodRefactoring(IMethod method) {
        super(method);
    }

    public RefactoringStatus checkPreactivation() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(super.checkPreactivation());
        result.merge(Checks.checkAvailability((IJavaElement)this.getMethod()));
        if (JdtFlags.isPrivate((IMember)this.getMethod())) {
            result.addFatalError(RefactoringCoreMessages.getString("RenameVirtualMethodRefactoring.no_private"));
        }
        if (JdtFlags.isStatic((IMember)this.getMethod())) {
            result.addFatalError(RefactoringCoreMessages.getString("RenameVirtualMethodRefactoring.no_static"));
        }
        if (!this.getMethod().getDeclaringType().isClass()) {
            result.addFatalError(RefactoringCoreMessages.getString("RenameVirtualMethodRefactoring.only_class_methods"));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block8: {
            RefactoringStatus refactoringStatus2;
            block7: {
                RefactoringStatus refactoringStatus3;
                block6: {
                    RefactoringStatus refactoringStatus4;
                    block5: {
                        try {
                            pm.beginTask("", 1);
                            RefactoringStatus result = new RefactoringStatus();
                            result.merge(super.checkActivation((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                            if (result.hasFatalError()) {
                                refactoringStatus4 = result;
                                Object var3_7 = null;
                                break block5;
                            }
                            result.merge(MethodChecks.checkIfComesFromInterface(this.getMethod(), (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                            if (result.hasFatalError()) {
                                refactoringStatus3 = result;
                                break block6;
                            }
                            result.merge(MethodChecks.checkIfOverridesAnother(this.getMethod(), (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                            if (result.hasFatalError()) {
                                refactoringStatus2 = result;
                                break block7;
                            }
                            refactoringStatus = result;
                            break block8;
                        }
                        catch (Throwable throwable) {
                            Object var3_11 = null;
                            pm.done();
                            throw throwable;
                        }
                    }
                    pm.done();
                    return refactoringStatus4;
                }
                Object var3_8 = null;
                pm.done();
                return refactoringStatus3;
            }
            Object var3_9 = null;
            pm.done();
            return refactoringStatus2;
        }
        Object var3_10 = null;
        pm.done();
        return refactoringStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block6: {
            RefactoringStatus refactoringStatus2;
            block5: {
                try {
                    IMethod hierarchyMethod;
                    pm.beginTask("", 12);
                    RefactoringStatus result = new RefactoringStatus();
                    result.merge(super.checkInput((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                    if (result.hasFatalError()) {
                        refactoringStatus2 = result;
                        Object var5_5 = null;
                        break block5;
                    }
                    if (this.hierarchyDeclaresSimilarNativeMethod((IProgressMonitor)new SubProgressMonitor(pm, 2))) {
                        result.addError(RefactoringCoreMessages.getFormattedString("RenameVirtualMethodRefactoring.requieres_renaming_native", new String[]{this.getMethod().getElementName(), "UnsatisfiedLinkError"}));
                    }
                    if ((hierarchyMethod = this.hierarchyDeclaresMethodName((IProgressMonitor)new SubProgressMonitor(pm, 2), this.getMethod(), this.getNewName())) != null) {
                        Context context = JavaSourceContext.create((IMember)hierarchyMethod);
                        result.addError(RefactoringCoreMessages.getFormattedString("RenameVirtualMethodRefactoring.hierarchy_declares1", this.getNewName()), context);
                    }
                    refactoringStatus = result;
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    pm.done();
                    throw throwable;
                }
            }
            pm.done();
            return refactoringStatus2;
        }
        Object var5_6 = null;
        pm.done();
        return refactoringStatus;
    }

    private boolean hierarchyDeclaresSimilarNativeMethod(IProgressMonitor pm) throws JavaModelException {
        IType[] classes = this.getMethod().getDeclaringType().newTypeHierarchy(pm).getAllSubtypes(this.getMethod().getDeclaringType());
        return this.classesDeclareOverridingNativeMethod(classes);
    }

    private boolean classesDeclareOverridingNativeMethod(IType[] classes) throws JavaModelException {
        int i = 0;
        while (i < classes.length) {
            IMethod[] methods = classes[i].getMethods();
            int j = 0;
            while (j < methods.length) {
                if (!methods[j].equals(this.getMethod()) && JdtFlags.isNative((IMember)methods[j]) && Checks.findMethod(this.getMethod(), new IMethod[]{methods[j]}) != null) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

