/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ISearchPattern;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResult;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.Context;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaSourceContext;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameResourceChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.rename.TextMatchFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.UpdateTypeReferenceEdit;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IQualifiedNameUpdatingRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdatingRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IRenameRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdatingRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameFinder;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameSearchResult;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;

public class RenameTypeRefactoring
extends Refactoring
implements IRenameRefactoring,
ITextUpdatingRefactoring,
IReferenceUpdatingRefactoring,
IQualifiedNameUpdatingRefactoring {
    private IType fType;
    private String fNewName;
    private SearchResultGroup[] fReferences;
    private TextChangeManager fChangeManager;
    private QualifiedNameSearchResult fQualifiedNameSearchResult;
    private boolean fUpdateReferences;
    private boolean fUpdateJavaDoc;
    private boolean fUpdateComments;
    private boolean fUpdateStrings;
    private boolean fUpdateQualifiedNames;
    private String fFilePatterns;

    public RenameTypeRefactoring(IType type) {
        Assert.isNotNull(type);
        this.fType = type;
        this.fNewName = type.getElementName();
        this.fUpdateReferences = true;
        this.fUpdateJavaDoc = false;
        this.fUpdateComments = false;
        this.fUpdateStrings = false;
    }

    public Object getNewElement() {
        IPackageFragment parent = this.fType.getPackageFragment();
        ICompilationUnit cu = this.isPrimaryType() ? parent.getCompilationUnit(String.valueOf(this.fNewName) + ".java") : this.fType.getCompilationUnit();
        return cu.getType(this.fNewName);
    }

    public IType getType() {
        return this.fType;
    }

    public boolean canEnableTextUpdating() {
        return true;
    }

    public boolean getUpdateJavaDoc() {
        return this.fUpdateJavaDoc;
    }

    public boolean getUpdateComments() {
        return this.fUpdateComments;
    }

    public boolean getUpdateStrings() {
        return this.fUpdateStrings;
    }

    public void setUpdateJavaDoc(boolean update) {
        this.fUpdateJavaDoc = update;
    }

    public void setUpdateComments(boolean update) {
        this.fUpdateComments = update;
    }

    public void setUpdateStrings(boolean update) {
        this.fUpdateStrings = update;
    }

    public RefactoringStatus checkPreconditions(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = this.checkPreactivation();
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(super.checkPreconditions(pm));
        return result;
    }

    public String getNewName() {
        return this.fNewName;
    }

    public void setNewName(String newName) {
        Assert.isNotNull(newName);
        this.fNewName = newName;
    }

    public String getCurrentName() {
        return this.fType.getElementName();
    }

    public String getName() {
        return RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.name", new String[]{JavaModelUtil.getFullyQualifiedName(this.fType), this.fNewName});
    }

    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public boolean canEnableQualifiedNameUpdating() {
        return !this.fType.getPackageFragment().isDefaultPackage() && !(this.fType.getParent() instanceof IType);
    }

    public boolean getUpdateQualifiedNames() {
        return this.fUpdateQualifiedNames;
    }

    public void setUpdateQualifiedNames(boolean update) {
        this.fUpdateQualifiedNames = update;
    }

    public String getFilePatterns() {
        return this.fFilePatterns;
    }

    public void setFilePatterns(String patterns) {
        Assert.isNotNull(patterns);
        this.fFilePatterns = patterns;
    }

    public RefactoringStatus checkPreactivation() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(Checks.checkAvailability((IJavaElement)this.fType));
        if (RenameTypeRefactoring.isSpecialCase(this.fType)) {
            result.addFatalError(RefactoringCoreMessages.getString("RenameTypeRefactoring.special_case"));
        }
        return result;
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        IType orig = (IType)WorkingCopyUtil.getOriginal((IMember)this.fType);
        if (orig == null || !orig.exists()) {
            String message = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.does_not_exist", new String[]{JavaModelUtil.getFullyQualifiedName(this.fType), this.fType.getCompilationUnit().getElementName()});
            return RefactoringStatus.createFatalErrorStatus(message);
        }
        this.fType = orig;
        return Checks.checkIfCuBroken((IMember)this.fType);
    }

    public RefactoringStatus checkNewName(String newName) {
        Assert.isNotNull(newName, "new name");
        RefactoringStatus result = Checks.checkTypeName(newName);
        if (Checks.isAlreadyNamed((IJavaElement)this.fType, newName)) {
            result.addFatalError(RefactoringCoreMessages.getString("RenameTypeRefactoring.choose_another_name"));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block24: {
            RefactoringStatus refactoringStatus2;
            block23: {
                RefactoringStatus refactoringStatus3;
                block22: {
                    RefactoringStatus refactoringStatus4;
                    block21: {
                        RefactoringStatus refactoringStatus5;
                        block20: {
                            RefactoringStatus refactoringStatus6;
                            block19: {
                                Assert.isNotNull(this.fType, "type");
                                Assert.isNotNull(this.fNewName, "newName");
                                RefactoringStatus result = new RefactoringStatus();
                                try {
                                    try {
                                        pm.beginTask("", 120);
                                        pm.setTaskName(RefactoringCoreMessages.getString("RenameTypeRefactoring.checking"));
                                        result.merge(this.checkNewName(this.fNewName));
                                        if (result.hasFatalError()) {
                                            refactoringStatus6 = result;
                                            Object var4_9 = null;
                                            break block19;
                                        }
                                        result.merge(Checks.checkIfCuBroken((IMember)this.fType));
                                        if (result.hasFatalError()) {
                                            refactoringStatus5 = result;
                                            break block20;
                                        }
                                        pm.worked(2);
                                        result.merge(this.checkTypesInCompilationUnit());
                                        pm.worked(1);
                                        result.merge(this.checkForMethodsWithConstructorNames());
                                        pm.worked(1);
                                        result.merge(this.checkImportedTypes());
                                        pm.worked(1);
                                        if (this.mustRenameCU()) {
                                            result.merge(Checks.checkCompilationUnitNewName(this.fType.getCompilationUnit(), this.fNewName));
                                        }
                                        pm.worked(1);
                                        if (this.isPrimaryType()) {
                                            result.merge(this.checkNewPathValidity());
                                        }
                                        pm.worked(1);
                                        result.merge(this.checkEnclosingTypes());
                                        pm.worked(1);
                                        result.merge(this.checkEnclosedTypes());
                                        pm.worked(1);
                                        result.merge(this.checkTypesInPackage());
                                        pm.worked(1);
                                        result.merge(this.checkTypesImportedInCu());
                                        pm.worked(1);
                                        result.merge(Checks.checkForNativeMethods(this.fType));
                                        pm.worked(1);
                                        result.merge(Checks.checkForMainMethod(this.fType));
                                        pm.worked(1);
                                        if (result.hasFatalError()) {
                                            refactoringStatus4 = result;
                                            break block21;
                                        }
                                        result.merge(this.analyseEnclosedTypes());
                                        pm.worked(1);
                                        if (result.hasFatalError()) {
                                            refactoringStatus3 = result;
                                            break block22;
                                        }
                                        this.fReferences = null;
                                        if (this.fUpdateReferences) {
                                            pm.setTaskName(RefactoringCoreMessages.getString("RenameTypeRefactoring.searching"));
                                            this.fReferences = this.getReferences((IProgressMonitor)new SubProgressMonitor(pm, 35));
                                        } else {
                                            pm.worked(35);
                                        }
                                        pm.setTaskName(RefactoringCoreMessages.getString("RenameTypeRefactoring.checking"));
                                        if (pm.isCanceled()) {
                                            throw new OperationCanceledException();
                                        }
                                        if (this.fUpdateReferences) {
                                            result.merge(this.analyzeAffectedCompilationUnits((IProgressMonitor)new SubProgressMonitor(pm, 25)));
                                        } else {
                                            pm.worked(25);
                                        }
                                        if (result.hasFatalError()) {
                                            refactoringStatus2 = result;
                                            break block23;
                                        }
                                        this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 35));
                                        if (this.fUpdateQualifiedNames) {
                                            this.computeQualifiedNameMatches((IProgressMonitor)new SubProgressMonitor(pm, 10));
                                        } else {
                                            pm.worked(10);
                                        }
                                        result.merge(this.validateModifiesFiles());
                                        refactoringStatus = result;
                                        break block24;
                                    }
                                    catch (JavaModelException e) {
                                        throw e;
                                    }
                                    catch (CoreException e) {
                                        throw new JavaModelException(e);
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var4_15 = null;
                                    pm.done();
                                    throw throwable;
                                }
                            }
                            pm.done();
                            return refactoringStatus6;
                        }
                        Object var4_10 = null;
                        pm.done();
                        return refactoringStatus5;
                    }
                    Object var4_11 = null;
                    pm.done();
                    return refactoringStatus4;
                }
                Object var4_12 = null;
                pm.done();
                return refactoringStatus3;
            }
            Object var4_13 = null;
            pm.done();
            return refactoringStatus2;
        }
        Object var4_14 = null;
        pm.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkNewPathValidity() throws JavaModelException {
        IContainer c = ResourceUtil.getResource((IMember)this.fType).getParent();
        String notRename = RefactoringCoreMessages.getString("RenameTypeRefactoring.will_not_rename");
        IStatus status = c.getWorkspace().validateName(this.fNewName, 1);
        if (status.getSeverity() == 4) {
            return RefactoringStatus.createWarningStatus(String.valueOf(status.getMessage()) + ". " + notRename);
        }
        status = c.getWorkspace().validatePath(this.createNewPath(this.fNewName), 1);
        if (status.getSeverity() == 4) {
            return RefactoringStatus.createWarningStatus(String.valueOf(status.getMessage()) + ". " + notRename);
        }
        return new RefactoringStatus();
    }

    private String createNewPath(String newName) throws JavaModelException {
        return ResourceUtil.getResource((IMember)this.fType).getFullPath().removeLastSegments(1).append(newName).toString();
    }

    private RefactoringStatus checkTypesImportedInCu() throws JavaModelException {
        IImportDeclaration imp = RenameTypeRefactoring.getImportedType(this.fType.getCompilationUnit(), this.fNewName);
        if (imp == null) {
            return null;
        }
        String msg = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.imported", new Object[]{this.fNewName, ResourceUtil.getResource((IMember)this.fType).getFullPath()});
        IJavaElement grandParent = imp.getParent().getParent();
        if (grandParent instanceof ICompilationUnit) {
            return RefactoringStatus.createErrorStatus(msg, JavaSourceContext.create(imp));
        }
        return null;
    }

    private RefactoringStatus checkTypesInPackage() throws JavaModelException {
        IType type = Checks.findTypeInPackage(this.fType.getPackageFragment(), this.fNewName);
        if (type == null || !type.exists()) {
            return null;
        }
        String msg = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.exists", new String[]{this.fNewName, this.fType.getPackageFragment().getElementName()});
        return RefactoringStatus.createErrorStatus(msg, JavaSourceContext.create((IMember)type));
    }

    private RefactoringStatus checkEnclosedTypes() throws JavaModelException {
        IType enclosedType = RenameTypeRefactoring.findEnclosedType(this.fType, this.fNewName);
        if (enclosedType == null) {
            return null;
        }
        String msg = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.encloses", new String[]{JavaModelUtil.getFullyQualifiedName(this.fType), this.fNewName});
        return RefactoringStatus.createErrorStatus(msg, JavaSourceContext.create((IMember)enclosedType));
    }

    private RefactoringStatus checkEnclosingTypes() throws JavaModelException {
        IType enclosingType = RenameTypeRefactoring.findEnclosingType(this.fType, this.fNewName);
        if (enclosingType == null) {
            return null;
        }
        String msg = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.enclosed", new String[]{JavaModelUtil.getFullyQualifiedName(this.fType), this.fNewName});
        return RefactoringStatus.createErrorStatus(msg, JavaSourceContext.create((IMember)enclosingType));
    }

    private static IType findEnclosedType(IType type, String newName) throws JavaModelException {
        IType[] enclosedTypes = type.getTypes();
        int i = 0;
        while (i < enclosedTypes.length) {
            if (newName.equals(enclosedTypes[i].getElementName()) || RenameTypeRefactoring.findEnclosedType(enclosedTypes[i], newName) != null) {
                return enclosedTypes[i];
            }
            ++i;
        }
        return null;
    }

    private static IType findEnclosingType(IType type, String newName) {
        IType enclosing = type.getDeclaringType();
        while (enclosing != null) {
            if (newName.equals(enclosing.getElementName())) {
                return enclosing;
            }
            enclosing = enclosing.getDeclaringType();
        }
        return null;
    }

    private static IImportDeclaration getImportedType(ICompilationUnit cu, String typeName) throws JavaModelException {
        IImportDeclaration[] imports = cu.getImports();
        String dotTypeName = "." + typeName;
        int i = 0;
        while (i < imports.length) {
            if (imports[i].getElementName().endsWith(dotTypeName)) {
                return imports[i];
            }
            ++i;
        }
        return null;
    }

    private static boolean isSpecialCase(IType type) throws JavaModelException {
        return type.getPackageFragment().getElementName().equals("java.lang");
    }

    private IJavaSearchScope createRefactoringScope() throws JavaModelException {
        return RefactoringScopeFactory.create((IJavaElement)this.fType);
    }

    private ISearchPattern createSearchPattern() throws JavaModelException {
        return SearchEngine.createSearchPattern((IJavaElement)this.fType, (int)2);
    }

    private SearchResultGroup[] getReferences(IProgressMonitor pm) throws JavaModelException {
        return RefactoringSearchEngine.search(pm, this.createRefactoringScope(), this.createSearchPattern());
    }

    private RefactoringStatus checkForMethodsWithConstructorNames() throws JavaModelException {
        IMethod[] methods = this.fType.getMethods();
        int i = 0;
        while (i < methods.length) {
            RefactoringStatus check;
            if (!methods[i].isConstructor() && (check = Checks.checkIfConstructorName(methods[i], methods[i].getElementName(), this.fNewName)) != null) {
                return check;
            }
            ++i;
        }
        return null;
    }

    private RefactoringStatus checkImportedTypes() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IImportDeclaration[] imports = this.fType.getCompilationUnit().getImports();
        int i = 0;
        while (i < imports.length) {
            this.analyzeImportDeclaration(imports[i], result);
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkTypesInCompilationUnit() throws JavaModelException {
        IType siblingType;
        RefactoringStatus result = new RefactoringStatus();
        if (!Checks.isTopLevel(this.fType) && (siblingType = this.fType.getDeclaringType().getType(this.fNewName)).exists()) {
            String msg = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.member_type_exists", new String[]{this.fNewName, JavaModelUtil.getFullyQualifiedName(this.fType.getDeclaringType())});
            result.addError(msg, JavaSourceContext.create((IMember)siblingType));
        }
        return result;
    }

    private RefactoringStatus analyseEnclosedTypes() throws JavaModelException {
        final ISourceRange typeRange = this.fType.getSourceRange();
        final RefactoringStatus result = new RefactoringStatus();
        CompilationUnit cuNode = AST.parseCompilationUnit((ICompilationUnit)this.fType.getCompilationUnit(), (boolean)false);
        cuNode.accept(new ASTVisitor(){

            public boolean visit(TypeDeclaration node) {
                if (node.getStartPosition() <= typeRange.getOffset()) {
                    return true;
                }
                if (node.getStartPosition() > typeRange.getOffset() + typeRange.getLength()) {
                    return true;
                }
                if (RenameTypeRefactoring.this.fNewName.equals(node.getName().getIdentifier())) {
                    Context context = JavaSourceContext.create(RenameTypeRefactoring.this.fType.getCompilationUnit(), (ASTNode)node);
                    String msg = null;
                    if (node.isLocalTypeDeclaration()) {
                        msg = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.local_type", new String[]{JavaElementUtil.createSignature((IMember)RenameTypeRefactoring.this.fType), RenameTypeRefactoring.this.fNewName});
                    } else if (node.isMemberTypeDeclaration()) {
                        msg = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.member_type", new String[]{JavaElementUtil.createSignature((IMember)RenameTypeRefactoring.this.fType), RenameTypeRefactoring.this.fNewName});
                    }
                    if (msg != null) {
                        result.addError(msg, context);
                    }
                }
                MethodDeclaration[] methods = node.getMethods();
                int i = 0;
                while (i < methods.length) {
                    if (Modifier.isNative((int)methods[i].getModifiers())) {
                        Context context = JavaSourceContext.create(RenameTypeRefactoring.this.fType.getCompilationUnit(), (ASTNode)methods[i]);
                        String msg = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.enclosed_type_native", node.getName().getIdentifier());
                        result.addWarning(msg, context);
                    }
                    ++i;
                }
                return true;
            }
        });
        return result;
    }

    private boolean mustRenameCU() throws JavaModelException {
        return Checks.isTopLevel(this.fType) && JdtFlags.isPublic((IMember)this.fType);
    }

    private static ICompilationUnit getCompilationUnit(IImportDeclaration imp) {
        return (ICompilationUnit)imp.getParent().getParent();
    }

    private void analyzeImportedTypes(IType[] types, RefactoringStatus result, IImportDeclaration imp) throws JavaModelException {
        int i = 0;
        while (i < types.length) {
            if (JdtFlags.isPublic((IMember)types[i]) && types[i].getElementName().equals(this.fNewName)) {
                String msg = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.name_conflict1", new Object[]{JavaModelUtil.getFullyQualifiedName(types[i]), RenameTypeRefactoring.getFullPath(RenameTypeRefactoring.getCompilationUnit(imp))});
                result.addError(msg, JavaSourceContext.create(imp));
            }
            ++i;
        }
    }

    private static IJavaElement convertFromImportDeclaration(IImportDeclaration declaration) throws JavaModelException {
        if (declaration.isOnDemand()) {
            String packageName = declaration.getElementName().substring(0, declaration.getElementName().length() - 2);
            return JavaModelUtil.findTypeContainer(declaration.getJavaProject(), packageName);
        }
        return JavaModelUtil.findTypeContainer(declaration.getJavaProject(), declaration.getElementName());
    }

    private void analyzeImportDeclaration(IImportDeclaration imp, RefactoringStatus result) throws JavaModelException {
        if (!imp.isOnDemand()) {
            return;
        }
        IJavaElement imported = RenameTypeRefactoring.convertFromImportDeclaration(imp);
        if (imported == null) {
            return;
        }
        if (imported instanceof IPackageFragment) {
            ICompilationUnit[] cus = ((IPackageFragment)imported).getCompilationUnits();
            int i = 0;
            while (i < cus.length) {
                this.analyzeImportedTypes(cus[i].getTypes(), result, imp);
                ++i;
            }
        } else {
            this.analyzeImportedTypes(((IType)imported).getTypes(), result, imp);
        }
    }

    private IFile[] getAllFilesToModify() throws CoreException {
        ArrayList<IFile> result = new ArrayList<IFile>();
        result.addAll(Arrays.asList(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits())));
        if (this.fQualifiedNameSearchResult != null) {
            result.addAll(Arrays.asList(this.fQualifiedNameSearchResult.getAllFiles()));
        }
        return result.toArray(new IFile[result.size()]);
    }

    private RefactoringStatus validateModifiesFiles() throws CoreException {
        return Checks.validateModifiesFiles(this.getAllFilesToModify());
    }

    private RefactoringStatus analyzeAffectedCompilationUnits(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        this.fReferences = Checks.excludeCompilationUnits(this.fReferences, result);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(Checks.checkCompileErrorsInAffectedFiles(this.fReferences));
        pm.beginTask("", this.fReferences.length);
        result.merge(this.checkConflictingTypes(pm));
        return result;
    }

    private RefactoringStatus checkConflictingTypes(IProgressMonitor pm) throws JavaModelException {
        ISearchPattern pattern;
        IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)this.fType);
        ICompilationUnit[] cusWithReferencesToConflictingTypes = RefactoringSearchEngine.findAffectedCompilationUnits(pm, scope, pattern = SearchEngine.createSearchPattern((String)this.fNewName, (int)0, (int)3, (boolean)true));
        if (cusWithReferencesToConflictingTypes.length == 0) {
            return new RefactoringStatus();
        }
        ICompilationUnit[] cusWithReferencesToRenamedType = RenameTypeRefactoring.getCus(this.fReferences);
        ICompilationUnit[] intersection = RenameTypeRefactoring.isIntersectionEmpty(cusWithReferencesToRenamedType, cusWithReferencesToConflictingTypes);
        if (intersection.length == 0) {
            return new RefactoringStatus();
        }
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < intersection.length) {
            Context context = JavaSourceContext.create(intersection[i]);
            String message = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.another_type", new String[]{this.fNewName, intersection[i].getElementName()});
            result.addWarning(message, context);
            ++i;
        }
        return result;
    }

    private static ICompilationUnit[] isIntersectionEmpty(ICompilationUnit[] a1, ICompilationUnit[] a2) {
        HashSet<ICompilationUnit> set1 = new HashSet<ICompilationUnit>(Arrays.asList(a1));
        HashSet<ICompilationUnit> set2 = new HashSet<ICompilationUnit>(Arrays.asList(a2));
        set1.retainAll(set2);
        return set1.toArray(new ICompilationUnit[set1.size()]);
    }

    private static ICompilationUnit[] getCus(SearchResultGroup[] searchResultGroups) {
        ArrayList<ICompilationUnit> cus = new ArrayList<ICompilationUnit>(searchResultGroups.length);
        int i = 0;
        while (i < searchResultGroups.length) {
            ICompilationUnit cu = searchResultGroups[i].getCompilationUnit();
            if (cu != null) {
                cus.add(cu);
            }
            ++i;
        }
        return cus.toArray(new ICompilationUnit[cus.size()]);
    }

    private static String getFullPath(ICompilationUnit cu) throws JavaModelException {
        Assert.isTrue(cu.exists());
        return ResourceUtil.getResource(cu).getFullPath().toString();
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask(RefactoringCoreMessages.getString("RenameTypeRefactoring.creating_change"), 4);
        CompositeChange builder = new CompositeChange();
        builder.addAll(this.fChangeManager.getAllChanges());
        if (this.fQualifiedNameSearchResult != null) {
            builder.addAll(this.fQualifiedNameSearchResult.getAllChanges());
        }
        if (this.willRenameCU()) {
            builder.add(new RenameResourceChange(ResourceUtil.getResource((IMember)this.fType), String.valueOf(this.fNewName) + ".java"));
        }
        pm.worked(1);
        return builder;
    }

    private boolean willRenameCU() throws JavaModelException {
        if (!this.isPrimaryType()) {
            return false;
        }
        if (!this.checkNewPathValidity().isOK()) {
            return false;
        }
        return Checks.checkCompilationUnitNewName(this.fType.getCompilationUnit(), this.fNewName).isOK();
    }

    private boolean isPrimaryType() {
        return Checks.isTopLevel(this.fType) && this.hasSameNameAsCU();
    }

    private boolean hasSameNameAsCU() {
        return this.fType.getCompilationUnit().getElementName().equals(String.valueOf(this.fType.getElementName()) + ".java");
    }

    private void addTextMatches(TextChangeManager manager, IProgressMonitor pm) throws JavaModelException {
        TextMatchFinder.findTextMatches(pm, this.createRefactoringScope(), this, manager);
    }

    private TextChangeManager createChangeManager(IProgressMonitor pm) throws CoreException {
        TextChangeManager textChangeManager;
        try {
            pm.beginTask("", 7);
            TextChangeManager manager = new TextChangeManager();
            if (this.fUpdateReferences) {
                this.addReferenceUpdates(manager, (IProgressMonitor)new SubProgressMonitor(pm, 3));
            }
            pm.worked(1);
            this.addTypeDeclarationUpdate(manager);
            pm.worked(1);
            this.addConstructorRenames(manager);
            pm.worked(1);
            pm.subTask(RefactoringCoreMessages.getString("RenameTypeRefactoring.searching_text"));
            this.addTextMatches(manager, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            textChangeManager = manager;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return textChangeManager;
    }

    private void addTypeDeclarationUpdate(TextChangeManager manager) throws CoreException {
        String name = RefactoringCoreMessages.getString("RenameTypeRefactoring.update");
        int typeNameLength = this.fType.getElementName().length();
        ICompilationUnit cu = WorkingCopyUtil.getWorkingCopyIfExists(this.fType.getCompilationUnit());
        manager.get(cu).addTextEdit(name, SimpleTextEdit.createReplace(this.fType.getNameRange().getOffset(), typeNameLength, this.fNewName));
    }

    private void addConstructorRenames(TextChangeManager manager) throws CoreException {
        ICompilationUnit cu = WorkingCopyUtil.getWorkingCopyIfExists(this.fType.getCompilationUnit());
        IMethod[] methods = this.fType.getMethods();
        int typeNameLength = this.fType.getElementName().length();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].isConstructor()) {
                String name = RefactoringCoreMessages.getString("RenameTypeRefactoring.rename_constructor");
                manager.get(cu).addTextEdit(name, SimpleTextEdit.createReplace(methods[i].getNameRange().getOffset(), typeNameLength, this.fNewName));
            }
            ++i;
        }
    }

    private void addReferenceUpdates(TextChangeManager manager, IProgressMonitor pm) throws CoreException {
        pm.beginTask("", this.fReferences.length);
        int i = 0;
        while (i < this.fReferences.length) {
            ICompilationUnit cu = this.fReferences[i].getCompilationUnit();
            if (cu != null) {
                ICompilationUnit wc = WorkingCopyUtil.getWorkingCopyIfExists(cu);
                String name = RefactoringCoreMessages.getString("RenameTypeRefactoring.update_reference");
                SearchResult[] results = this.fReferences[i].getSearchResults();
                int j = 0;
                while (j < results.length) {
                    SearchResult searchResult = results[j];
                    int offset = searchResult.getStart();
                    int length = searchResult.getEnd() - searchResult.getStart();
                    manager.get(wc).addTextEdit(name, new UpdateTypeReferenceEdit(offset, length, this.fNewName, this.fType.getElementName()));
                    ++j;
                }
                pm.worked(1);
            }
            ++i;
        }
    }

    private void computeQualifiedNameMatches(IProgressMonitor pm) throws JavaModelException {
        IPackageFragment fragment = this.fType.getPackageFragment();
        this.fQualifiedNameSearchResult = QualifiedNameFinder.process(this.fType.getFullyQualifiedName(), String.valueOf(fragment.getElementName()) + "." + this.fNewName, this.fFilePatterns, this.fType.getJavaProject().getProject(), pm);
    }
}

