/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatusEntry;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextBufferChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempDeclarationFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempOccurrenceFinder;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdatingRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IRenameRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRange;

public class RenameTempRefactoring
extends Refactoring
implements IRenameRefactoring,
IReferenceUpdatingRefactoring {
    private final int fSelectionStart;
    private final int fSelectionLength;
    private final ICompilationUnit fCu;
    private boolean fUpdateReferences;
    private String fCurrentName;
    private String fNewName;
    private CompilationUnit fCompilationUnitNode;
    private VariableDeclaration fTempDeclarationNode;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public RenameTempRefactoring(ICompilationUnit cu, int selectionStart, int selectionLength) {
        Assert.isTrue(selectionStart >= 0);
        Assert.isTrue(selectionLength >= 0);
        Assert.isTrue(cu.exists());
        this.fUpdateReferences = true;
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = cu;
        this.fNewName = "";
    }

    public Object getNewElement() {
        return null;
    }

    public String getName() {
        return RefactoringCoreMessages.getString("RenameTempRefactoring.rename");
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public void setUpdateReferences(boolean updateReferences) {
        this.fUpdateReferences = updateReferences;
    }

    public void setNewName(String newName) {
        Assert.isNotNull(newName);
        this.fNewName = newName;
    }

    public String getNewName() {
        return this.fNewName;
    }

    public String getCurrentName() {
        return this.fCurrentName;
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        this.initAST();
        if (this.fTempDeclarationNode == null) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("RenameTempRefactoring.must_select_local"));
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!Checks.isDeclaredIn(this.fTempDeclarationNode, clazz)) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.jdt.core.dom.Initializer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!Checks.isDeclaredIn(this.fTempDeclarationNode, clazz2)) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("RenameTempRefactoring.only_in_methods_and_initializers"));
            }
        }
        this.initNames();
        return new RefactoringStatus();
    }

    private void initAST() {
        this.fCompilationUnitNode = AST.parseCompilationUnit((ICompilationUnit)this.fCu, (boolean)true);
        this.fTempDeclarationNode = TempDeclarationFinder.findTempDeclaration(this.fCompilationUnitNode, this.fSelectionStart, this.fSelectionLength);
    }

    private void initNames() {
        this.fCurrentName = this.fTempDeclarationNode.getName().getIdentifier();
    }

    public RefactoringStatus checkNewName(String newName) throws JavaModelException {
        RefactoringStatus result = Checks.checkFieldName(newName);
        if (!Checks.startsWithLowerCase(newName)) {
            result.addWarning(RefactoringCoreMessages.getString("RenameTempRefactoring.lowercase"));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block6: {
            RefactoringStatus refactoringStatus2;
            block5: {
                RefactoringStatus refactoringStatus3;
                block4: {
                    try {
                        pm.beginTask("", 1);
                        RefactoringStatus result = new RefactoringStatus();
                        result.merge(Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCu})));
                        if (result.hasFatalError()) {
                            refactoringStatus3 = result;
                            Object var3_6 = null;
                            break block4;
                        }
                        result.merge(this.checkNewName(this.fNewName));
                        if (result.hasFatalError()) {
                            refactoringStatus2 = result;
                            break block5;
                        }
                        result.merge(this.analyzeAST());
                        refactoringStatus = result;
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var3_9 = null;
                        pm.done();
                        throw throwable;
                    }
                }
                pm.done();
                return refactoringStatus3;
            }
            Object var3_7 = null;
            pm.done();
            return refactoringStatus2;
        }
        Object var3_8 = null;
        pm.done();
        return refactoringStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefactoringStatus analyzeAST() throws JavaModelException {
        RefactoringStatus refactoringStatus;
        ICompilationUnit wc;
        block4: {
            RefactoringStatus refactoringStatus2;
            block3: {
                wc = null;
                try {
                    RefactoringStatus result = new RefactoringStatus();
                    TextEdit[] edits = this.getAllRenameEdits();
                    TextBufferChange change = new TextBufferChange(RefactoringCoreMessages.getString("RenameTempRefactoring.rename"), TextBuffer.create(this.fCu.getSource()));
                    change.setKeepExecutedTextEdits(true);
                    wc = RefactoringAnalyzeUtil.getWorkingCopyWithNewContent(edits, change, this.fCu);
                    String newCuSource = change.getPreviewContent();
                    CompilationUnit newCUNode = AST.parseCompilationUnit((char[])newCuSource.toCharArray(), (String)this.fCu.getElementName(), (IJavaProject)this.fCu.getJavaProject());
                    result.merge(this.analyzeCompileErrors(newCuSource, newCUNode));
                    if (result.hasError()) {
                        refactoringStatus2 = result;
                        Object var10_9 = null;
                        if (wc == null) return refactoringStatus2;
                        break block3;
                    }
                    String fullKey = RefactoringAnalyzeUtil.getFullDeclarationBindingKey(edits, this.fCompilationUnitNode);
                    ASTNode enclosing = this.getEnclosingBlockOrMethod(edits, change, newCUNode);
                    SimpleName[] problemNodes = ProblemNodeFinder.getProblemNodes(enclosing, edits, change, fullKey);
                    result.merge(RefactoringAnalyzeUtil.reportProblemNodes(newCuSource, problemNodes));
                    refactoringStatus = result;
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (wc == null) throw throwable;
                    wc.destroy();
                    throw throwable;
                }
            }
            wc.destroy();
            return refactoringStatus2;
        }
        Object var10_10 = null;
        if (wc == null) return refactoringStatus;
        wc.destroy();
        return refactoringStatus;
    }

    private ASTNode getEnclosingBlockOrMethod(TextEdit[] edits, TextChange change, CompilationUnit newCUNode) {
        Block enclosing = RefactoringAnalyzeUtil.getBlock(RefactoringAnalyzeUtil.getFirstEdit(edits), change, newCUNode);
        if (enclosing == null) {
            enclosing = RefactoringAnalyzeUtil.getMethodDeclaration(RefactoringAnalyzeUtil.getFirstEdit(edits), change, newCUNode);
        }
        return enclosing;
    }

    private RefactoringStatus analyzeCompileErrors(String newCuSource, CompilationUnit newCUNode) {
        RefactoringStatus result = new RefactoringStatus();
        IProblem[] newProblems = RefactoringAnalyzeUtil.getIntroducedCompileProblems(newCuSource, newCUNode, this.fCompilationUnitNode);
        int i = 0;
        while (i < newProblems.length) {
            IProblem problem = newProblems[i];
            if (problem.isError()) {
                result.addEntry(RefactoringStatusEntry.create(problem, newCuSource));
            }
            ++i;
        }
        return result;
    }

    private TextEdit[] getAllRenameEdits() throws JavaModelException {
        Integer[] renamingOffsets = TempOccurrenceFinder.findTempOccurrenceOffsets(this.fTempDeclarationNode, this.fUpdateReferences, true);
        Assert.isTrue(renamingOffsets.length > 0);
        TextEdit[] result = new TextEdit[renamingOffsets.length];
        int length = this.fCurrentName.length();
        int i = 0;
        while (i < renamingOffsets.length) {
            int offset = renamingOffsets[i];
            result[i] = SimpleTextEdit.createReplace(offset, length, this.fNewName);
            ++i;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        CompilationUnitChange compilationUnitChange;
        try {
            try {
                pm.beginTask("", 2);
                pm.worked(1);
                CompilationUnitChange change = new CompilationUnitChange(RefactoringCoreMessages.getString("RenameTempRefactoring.rename"), this.fCu);
                String changeName = RefactoringCoreMessages.getFormattedString("RenameTempRefactoring.changeName", new String[]{this.fCurrentName, this.fNewName});
                TextEdit[] edits = this.getAllRenameEdits();
                int i = 0;
                while (true) {
                    if (i >= edits.length) {
                        compilationUnitChange = change;
                        Object var6_9 = null;
                        break;
                    }
                    change.addTextEdit(changeName, edits[i]);
                    ++i;
                }
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return compilationUnitChange;
    }

    private static class ProblemNodeFinder {
        ProblemNodeFinder() {
        }

        public static SimpleName[] getProblemNodes(ASTNode methodNode, TextEdit[] edits, TextChange change, String key) {
            NameNodeVisitor visitor = new NameNodeVisitor(edits, change, key);
            methodNode.accept((ASTVisitor)visitor);
            return visitor.getProblemNodes();
        }

        private static class NameNodeVisitor
        extends ASTVisitor {
            private Collection fRanges;
            private Collection fProblemNodes;
            private String fKey;
            static /* synthetic */ Class class$0;

            public NameNodeVisitor(TextEdit[] edits, TextChange change, String key) {
                Assert.isNotNull(edits);
                Assert.isNotNull(key);
                this.fRanges = new HashSet<TextRange>(Arrays.asList(RefactoringAnalyzeUtil.getRanges(edits, change)));
                this.fProblemNodes = new ArrayList(0);
                this.fKey = key;
            }

            public SimpleName[] getProblemNodes() {
                return this.fProblemNodes.toArray(new SimpleName[this.fProblemNodes.size()]);
            }

            private static VariableDeclaration getVariableDeclaration(Name node) {
                IBinding binding = node.resolveBinding();
                if (binding == null && node.getParent() instanceof VariableDeclaration) {
                    return (VariableDeclaration)node.getParent();
                }
                if (binding != null && binding.getKind() == 3) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    CompilationUnit cu = (CompilationUnit)ASTNodes.getParent((ASTNode)node, clazz);
                    return ASTNodes.findVariableDeclaration((IVariableBinding)binding, (ASTNode)cu);
                }
                return null;
            }

            public boolean visit(SimpleName node) {
                VariableDeclaration decl = NameNodeVisitor.getVariableDeclaration((Name)node);
                if (decl == null) {
                    return super.visit(node);
                }
                boolean keysEqual = this.fKey.equals(RefactoringAnalyzeUtil.getFullBindingKey(decl));
                boolean rangeInSet = this.fRanges.contains(TextRange.createFromStartAndLength(node.getStartPosition(), node.getLength()));
                if (keysEqual && !rangeInSet) {
                    this.fProblemNodes.add(node);
                }
                if (!keysEqual && rangeInSet) {
                    this.fProblemNodes.add(node);
                }
                return super.visit(node);
            }
        }
    }
}

