/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.Context;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaSourceContext;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameMethodRefactoring;
import org.eclipse.jdt.internal.corext.util.JdtFlags;

class RenameStaticMethodRefactoring
extends RenameMethodRefactoring {
    RenameStaticMethodRefactoring(IMethod method) {
        super(method);
    }

    public RefactoringStatus checkPreactivation() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(super.checkPreactivation());
        result.merge(Checks.checkAvailability((IJavaElement)this.getMethod()));
        if (JdtFlags.isPrivate((IMember)this.getMethod())) {
            result.addFatalError(RefactoringCoreMessages.getString("RenameStaticMethodRefactoring.no_private"));
        }
        if (!JdtFlags.isStatic((IMember)this.getMethod())) {
            result.addFatalError(RefactoringCoreMessages.getString("RenameStaticMethodRefactoring.only_static"));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block5: {
            RefactoringStatus refactoringStatus2;
            block4: {
                try {
                    pm.beginTask("", 2);
                    RefactoringStatus result = new RefactoringStatus();
                    result.merge(super.checkInput((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                    if (result.hasFatalError()) {
                        refactoringStatus2 = result;
                        Object var5_5 = null;
                        break block4;
                    }
                    IMethod hierarchyMethod = this.hierarchyDeclaresMethodName(pm, this.getMethod(), this.getNewName());
                    if (hierarchyMethod != null) {
                        Context context = JavaSourceContext.create((IMember)hierarchyMethod);
                        result.addError(RefactoringCoreMessages.getFormattedString("RenameStaticMethodRefactoring.hierachy_declares", this.getNewName()), context);
                    }
                    refactoringStatus = result;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    pm.done();
                    throw throwable;
                }
            }
            pm.done();
            return refactoringStatus2;
        }
        Object var5_6 = null;
        pm.done();
        return refactoringStatus;
    }
}

