/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameSourceFolderChange;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IRenameRefactoring;

public class RenameSourceFolderRefactoring
extends Refactoring
implements IRenameRefactoring {
    private IPackageFragmentRoot fSourceFolder;
    private String fNewName;

    public RenameSourceFolderRefactoring(IPackageFragmentRoot sourceFolder) {
        Assert.isNotNull(sourceFolder);
        this.fSourceFolder = sourceFolder;
        this.fNewName = this.fSourceFolder.getElementName();
    }

    public String getName() {
        String message = RefactoringCoreMessages.getFormattedString("RenameSourceFolderRefactoring.rename", new String[]{this.fSourceFolder.getElementName(), this.fNewName});
        return message;
    }

    public Object getNewElement() throws JavaModelException {
        IPackageFragmentRoot[] roots = this.fSourceFolder.getJavaProject().getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getElementName().equals(this.fNewName)) {
                return roots[i];
            }
            ++i;
        }
        return null;
    }

    public void setNewName(String newName) {
        Assert.isNotNull(newName);
        this.fNewName = newName;
    }

    public String getNewName() {
        return this.fNewName;
    }

    public String getCurrentName() {
        return this.fSourceFolder.getElementName();
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        if (!this.fSourceFolder.exists()) {
            return RefactoringStatus.createFatalErrorStatus("");
        }
        if (this.fSourceFolder.isArchive()) {
            return RefactoringStatus.createFatalErrorStatus("");
        }
        if (this.fSourceFolder.isExternal()) {
            return RefactoringStatus.createFatalErrorStatus("");
        }
        if (this.fSourceFolder.isReadOnly()) {
            return RefactoringStatus.createFatalErrorStatus("");
        }
        if (!this.fSourceFolder.isStructureKnown()) {
            return RefactoringStatus.createFatalErrorStatus("");
        }
        if (!this.fSourceFolder.isConsistent()) {
            return RefactoringStatus.createFatalErrorStatus("");
        }
        if (this.fSourceFolder.getResource() instanceof IProject) {
            return RefactoringStatus.createFatalErrorStatus("");
        }
        return new RefactoringStatus();
    }

    public RefactoringStatus checkNewName(String newName) throws JavaModelException {
        IPath p;
        Assert.isNotNull(newName, "new name");
        if (!newName.trim().equals(newName)) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("RenameSourceFolderRefactoring.blank"));
        }
        IContainer c = this.fSourceFolder.getResource().getParent();
        if (!c.getFullPath().isValidSegment(newName)) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("RenameSourceFolderRefactoring.invalid_name"));
        }
        RefactoringStatus result = RefactoringStatus.create(c.getWorkspace().validateName(newName, 2));
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(RefactoringStatus.create(c.getWorkspace().validatePath(this.createNewPath(newName), 2)));
        if (result.hasFatalError()) {
            return result;
        }
        IJavaProject project = this.fSourceFolder.getJavaProject();
        if (project.findPackageFragmentRoot(p = project.getProject().getFullPath().append(newName)) != null) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("RenameSourceFolderRefactoring.already_exists"));
        }
        if (project.getProject().findMember((IPath)new Path(newName)) != null) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("RenameSourceFolderRefactoring.alread_exists"));
        }
        return result;
    }

    private String createNewPath(String newName) {
        return this.fSourceFolder.getPath().removeLastSegments(1).append(newName).toString();
    }

    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        pm.beginTask("", 1);
        try {
            refactoringStatus = new RefactoringStatus();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        RenameSourceFolderChange renameSourceFolderChange;
        pm.beginTask("", 1);
        try {
            renameSourceFolderChange = new RenameSourceFolderChange(this.fSourceFolder, this.fNewName);
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return renameSourceFolderChange;
    }
}

