/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameResourceChange;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IRenameRefactoring;

public class RenameResourceRefactoring
extends Refactoring
implements IRenameRefactoring {
    private IResource fResource;
    private String fNewName;

    public RenameResourceRefactoring(IResource resource) {
        Assert.isNotNull(resource);
        this.fResource = resource;
        this.fNewName = resource.getName();
    }

    public String getName() {
        String message = RefactoringCoreMessages.getFormattedString("RenameResourceRefactoring.rename", new String[]{this.getCurrentName(), this.fNewName});
        return message;
    }

    public Object getNewElement() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.createNewPath(this.fNewName));
    }

    public void setNewName(String newName) {
        Assert.isNotNull(newName);
        this.fNewName = newName;
    }

    public String getNewName() {
        return this.fNewName;
    }

    public String getCurrentName() {
        return this.fResource.getName();
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        if (!this.fResource.exists()) {
            return RefactoringStatus.createFatalErrorStatus("");
        }
        if (!this.fResource.isAccessible()) {
            return RefactoringStatus.createFatalErrorStatus("");
        }
        return new RefactoringStatus();
    }

    public RefactoringStatus checkNewName(String newName) throws JavaModelException {
        Assert.isNotNull(newName, "new name");
        IContainer c = this.fResource.getParent();
        if (c == null) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("RenameResourceRefactoring.Internal_Error"));
        }
        if (c.findMember(newName) != null) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("RenameResourceRefactoring.alread_exists"));
        }
        if (!c.getFullPath().isValidSegment(newName)) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("RenameResourceRefactoring.invalidName"));
        }
        RefactoringStatus result = RefactoringStatus.create(c.getWorkspace().validateName(newName, this.fResource.getType()));
        if (!result.hasFatalError()) {
            result.merge(RefactoringStatus.create(c.getWorkspace().validatePath(this.createNewPath(newName), this.fResource.getType())));
        }
        return result;
    }

    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        pm.beginTask("", 1);
        try {
            refactoringStatus = new RefactoringStatus();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    private String createNewPath(String newName) {
        return this.fResource.getFullPath().removeLastSegments(1).append(newName).toString();
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        RenameResourceChange renameResourceChange;
        pm.beginTask("", 1);
        try {
            renameResourceChange = new RenameResourceChange(this.fResource, this.fNewName);
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return renameResourceChange;
    }
}

