/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.ISearchPattern;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.SearchResult;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.Context;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaSourceContext;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameMethodRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;

class RenamePrivateMethodRefactoring
extends RenameMethodRefactoring {
    RenamePrivateMethodRefactoring(IMethod method) {
        super(method);
    }

    public RefactoringStatus checkPreactivation() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(super.checkPreactivation());
        result.merge(Checks.checkAvailability((IJavaElement)this.getMethod()));
        if (!JdtFlags.isPrivate((IMember)this.getMethod())) {
            result.addFatalError(RefactoringCoreMessages.getString("RenamePrivateMethodRefactoring.only_private"));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block5: {
            RefactoringStatus refactoringStatus2;
            block4: {
                try {
                    pm.beginTask("", 2);
                    RefactoringStatus result = new RefactoringStatus();
                    result.merge(super.checkInput((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                    if (result.hasFatalError()) {
                        refactoringStatus2 = result;
                        Object var6_5 = null;
                        break block4;
                    }
                    IMethod hierarchyMethod = this.hierarchyDeclaresMethodName((IProgressMonitor)new SubProgressMonitor(pm, 1), this.getMethod(), this.getNewName());
                    if (hierarchyMethod != null) {
                        Context context = JavaSourceContext.create((IMember)hierarchyMethod);
                        String message = RefactoringCoreMessages.getFormattedString("RenamePrivateMethodRefactoring.hierarchy_defines", new String[]{JavaModelUtil.getFullyQualifiedName(this.getMethod().getDeclaringType()), this.getNewName()});
                        result.addError(message, context);
                    }
                    refactoringStatus = result;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    pm.done();
                    throw throwable;
                }
            }
            pm.done();
            return refactoringStatus2;
        }
        Object var6_6 = null;
        pm.done();
        return refactoringStatus;
    }

    void addOccurrences(TextChangeManager manager, IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        ICompilationUnit cu = WorkingCopyUtil.getWorkingCopyIfExists(this.getMethod().getCompilationUnit());
        this.addReferenceUpdates(manager.get(cu));
        this.addDeclarationUpdate(manager.get(cu));
        pm.worked(1);
    }

    ISearchPattern createSearchPattern(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 1);
        ISearchPattern pattern = SearchEngine.createSearchPattern((IJavaElement)this.getMethod(), (int)2);
        pm.done();
        return pattern;
    }

    private void addReferenceUpdates(TextChange change) throws JavaModelException {
        SearchResultGroup[] grouped = this.getOccurrences();
        if (grouped.length == 0) {
            return;
        }
        SearchResult[] results = grouped[0].getSearchResults();
        int i = 0;
        while (i < results.length) {
            String editName = RefactoringCoreMessages.getString("RenamePrivateMethodRefactoring.update");
            change.addTextEdit(editName, this.createTextChange(results[i]));
            ++i;
        }
    }
}

