/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ISearchPattern;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResult;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.Context;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaSourceContext;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenamePackageChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.rename.TextMatchFinder;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IQualifiedNameUpdatingRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdatingRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IRenameRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdatingRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameFinder;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameSearchResult;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;

public class RenamePackageRefactoring
extends Refactoring
implements IRenameRefactoring,
IReferenceUpdatingRefactoring,
ITextUpdatingRefactoring,
IQualifiedNameUpdatingRefactoring {
    private IPackageFragment fPackage;
    private String fNewName;
    private SearchResultGroup[] fOccurrences;
    private TextChangeManager fChangeManager;
    private QualifiedNameSearchResult fQualifiedNameSearchResult;
    private boolean fUpdateReferences;
    private boolean fUpdateJavaDoc;
    private boolean fUpdateComments;
    private boolean fUpdateStrings;
    private boolean fUpdateQualifiedNames;
    private String fFilePatterns;

    public RenamePackageRefactoring(IPackageFragment pack) {
        Assert.isNotNull(pack);
        this.fPackage = pack;
        this.fNewName = pack.getElementName();
        this.fUpdateReferences = true;
        this.fUpdateJavaDoc = false;
        this.fUpdateComments = false;
        this.fUpdateStrings = false;
    }

    public String getName() {
        return RefactoringCoreMessages.getFormattedString("RenamePackageRefactoring.name", new String[]{this.fPackage.getElementName(), this.fNewName});
    }

    public Object getNewElement() {
        IJavaElement parent = this.fPackage.getParent();
        if (!(parent instanceof IPackageFragmentRoot)) {
            return this.fPackage;
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)parent;
        return root.getPackageFragment(this.fNewName);
    }

    public boolean canEnableTextUpdating() {
        return true;
    }

    public boolean getUpdateJavaDoc() {
        return this.fUpdateJavaDoc;
    }

    public boolean getUpdateComments() {
        return this.fUpdateComments;
    }

    public boolean getUpdateStrings() {
        return this.fUpdateStrings;
    }

    public void setUpdateJavaDoc(boolean update) {
        this.fUpdateJavaDoc = update;
    }

    public void setUpdateComments(boolean update) {
        this.fUpdateComments = update;
    }

    public void setUpdateStrings(boolean update) {
        this.fUpdateStrings = update;
    }

    public final void setNewName(String newName) {
        Assert.isNotNull(newName);
        this.fNewName = newName;
    }

    public final String getCurrentName() {
        return this.fPackage.getElementName();
    }

    public final String getNewName() {
        return this.fNewName;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public boolean canEnableQualifiedNameUpdating() {
        return !this.fPackage.isDefaultPackage();
    }

    public boolean getUpdateQualifiedNames() {
        return this.fUpdateQualifiedNames;
    }

    public void setUpdateQualifiedNames(boolean update) {
        this.fUpdateQualifiedNames = update;
    }

    public String getFilePatterns() {
        return this.fFilePatterns;
    }

    public void setFilePatterns(String patterns) {
        Assert.isNotNull(patterns);
        this.fFilePatterns = patterns;
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 1);
        RefactoringStatus result = new RefactoringStatus();
        result.merge(Checks.checkAvailability((IJavaElement)this.fPackage));
        if (this.fPackage.isDefaultPackage()) {
            result.addFatalError("");
        }
        pm.done();
        return result;
    }

    public RefactoringStatus checkNewName(String newName) throws JavaModelException {
        Assert.isNotNull(newName, "new name");
        RefactoringStatus result = Checks.checkPackageName(newName);
        if (Checks.isAlreadyNamed((IJavaElement)this.fPackage, newName)) {
            result.addFatalError(RefactoringCoreMessages.getString("RenamePackageRefactoring.another_name"));
        } else if (this.fPackage.getElementName().equalsIgnoreCase(newName)) {
            result.addFatalError(RefactoringCoreMessages.getString("RenamePackageRefactoring.different_case"));
        }
        result.merge(this.checkPackageInCurrentRoot(newName));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block14: {
            RefactoringStatus refactoringStatus2;
            block13: {
                try {
                    try {
                        pm.beginTask("", 15);
                        pm.setTaskName(RefactoringCoreMessages.getString("RenamePackageRefactoring.checking"));
                        RefactoringStatus result = new RefactoringStatus();
                        result.merge(this.checkNewName(this.fNewName));
                        pm.worked(1);
                        result.merge(this.checkForNativeMethods());
                        pm.worked(1);
                        result.merge(this.checkForMainMethods());
                        pm.worked(1);
                        if (this.fPackage.isReadOnly()) {
                            String message = RefactoringCoreMessages.getFormattedString("RenamePackageRefactoring.Packagered_only", this.fPackage.getElementName());
                            result.addFatalError(message);
                        } else if (this.fPackage.getResource().isReadOnly()) {
                            String message = RefactoringCoreMessages.getFormattedString("RenamePackageRefactoring.resource_read_only", this.fPackage.getElementName());
                            result.addError(message);
                        }
                        if (this.fUpdateReferences) {
                            pm.setTaskName(RefactoringCoreMessages.getString("RenamePackageRefactoring.searching"));
                            this.fOccurrences = this.getReferences((IProgressMonitor)new SubProgressMonitor(pm, 6));
                            pm.setTaskName(RefactoringCoreMessages.getString("RenamePackageRefactoring.checking"));
                            result.merge(this.analyzeAffectedCompilationUnits());
                            pm.worked(1);
                        } else {
                            pm.worked(9);
                        }
                        result.merge(this.checkPackageName(this.fNewName));
                        if (result.hasFatalError()) {
                            refactoringStatus2 = result;
                            Object var4_9 = null;
                            break block13;
                        }
                        this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 3));
                        if (this.fUpdateQualifiedNames) {
                            this.computeQualifiedNameMatches((IProgressMonitor)new SubProgressMonitor(pm, 1));
                        } else {
                            pm.worked(1);
                        }
                        result.merge(this.validateModifiesFiles());
                        refactoringStatus = result;
                        break block14;
                    }
                    catch (JavaModelException e) {
                        throw e;
                    }
                    catch (CoreException e) {
                        throw new JavaModelException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_11 = null;
                    pm.done();
                    throw throwable;
                }
            }
            pm.done();
            return refactoringStatus2;
        }
        Object var4_10 = null;
        pm.done();
        return refactoringStatus;
    }

    private IJavaSearchScope createRefactoringScope() throws JavaModelException {
        return RefactoringScopeFactory.create((IJavaElement)this.fPackage);
    }

    private ISearchPattern createSearchPattern() {
        return SearchEngine.createSearchPattern((IJavaElement)this.fPackage, (int)2);
    }

    private SearchResultGroup[] getReferences(IProgressMonitor pm) throws JavaModelException {
        return RefactoringSearchEngine.search(pm, this.createRefactoringScope(), this.createSearchPattern());
    }

    private RefactoringStatus checkForMainMethods() throws JavaModelException {
        ICompilationUnit[] cus = this.fPackage.getCompilationUnits();
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < cus.length) {
            result.merge(Checks.checkForMainMethods(cus[i]));
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkForNativeMethods() throws JavaModelException {
        ICompilationUnit[] cus = this.fPackage.getCompilationUnits();
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < cus.length) {
            result.merge(Checks.checkForNativeMethods(cus[i]));
            ++i;
        }
        return result;
    }

    public static boolean isPackageNameOkInRoot(String newName, IPackageFragmentRoot root) throws JavaModelException {
        IPackageFragment pack = root.getPackageFragment(newName);
        if (!pack.exists()) {
            return true;
        }
        if (!pack.hasSubpackages()) {
            return false;
        }
        if (pack.containsJavaResources()) {
            return false;
        }
        return pack.getNonJavaResources().length == 0;
    }

    private RefactoringStatus checkPackageInCurrentRoot(String newName) throws JavaModelException {
        if (RenamePackageRefactoring.isPackageNameOkInRoot(newName, this.getPackageFragmentRoot())) {
            return null;
        }
        return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("RenamePackageRefactoring.package_exists"));
    }

    private IPackageFragmentRoot getPackageFragmentRoot() {
        return (IPackageFragmentRoot)this.fPackage.getParent();
    }

    private RefactoringStatus checkPackageName(String newName) throws JavaModelException {
        RefactoringStatus status = new RefactoringStatus();
        IPackageFragmentRoot[] roots = this.fPackage.getJavaProject().getPackageFragmentRoots();
        Set topLevelTypeNames = this.getTopLevelTypeNames();
        int i = 0;
        while (i < roots.length) {
            if (!RenamePackageRefactoring.isPackageNameOkInRoot(newName, roots[i])) {
                String message = RefactoringCoreMessages.getFormattedString("RenamePackageRefactoring.aleady_exists", new Object[]{this.fNewName, roots[i].getElementName()});
                status.merge(RefactoringStatus.createWarningStatus(message));
                status.merge(this.checkTypeNameConflicts(roots[i], newName, topLevelTypeNames));
            }
            ++i;
        }
        return status;
    }

    private Set getTopLevelTypeNames() throws JavaModelException {
        ICompilationUnit[] cus = this.fPackage.getCompilationUnits();
        HashSet result = new HashSet(2 * cus.length);
        int i = 0;
        while (i < cus.length) {
            result.addAll(RenamePackageRefactoring.getTopLevelTypeNames(cus[i]));
            ++i;
        }
        return result;
    }

    private static Collection getTopLevelTypeNames(ICompilationUnit iCompilationUnit) throws JavaModelException {
        IType[] types = iCompilationUnit.getTypes();
        ArrayList<String> result = new ArrayList<String>(types.length);
        int i = 0;
        while (i < types.length) {
            result.add(types[i].getElementName());
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkTypeNameConflicts(IPackageFragmentRoot root, String newName, Set topLevelTypeNames) throws JavaModelException {
        IPackageFragment otherPack = root.getPackageFragment(newName);
        if (this.fPackage.equals(otherPack)) {
            return null;
        }
        ICompilationUnit[] cus = otherPack.getCompilationUnits();
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < cus.length) {
            result.merge(this.checkTypeNameConflicts(cus[i], topLevelTypeNames));
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkTypeNameConflicts(ICompilationUnit iCompilationUnit, Set topLevelTypeNames) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IType[] types = iCompilationUnit.getTypes();
        String packageName = iCompilationUnit.getParent().getElementName();
        int i = 0;
        while (i < types.length) {
            String name = types[i].getElementName();
            if (topLevelTypeNames.contains(name)) {
                String[] keys = new String[]{packageName, name};
                String msg = RefactoringCoreMessages.getFormattedString("RenamePackageRefactoring.contains_type", keys);
                Context context = JavaSourceContext.create((IMember)types[i]);
                result.addError(msg, context);
            }
            ++i;
        }
        return result;
    }

    private RefactoringStatus analyzeAffectedCompilationUnits() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        this.fOccurrences = Checks.excludeCompilationUnits(this.fOccurrences, result);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(Checks.checkCompileErrorsInAffectedFiles(this.fOccurrences));
        return result;
    }

    private IFile[] getAllCusInPackageAsFiles() throws JavaModelException {
        ICompilationUnit[] cus = this.fPackage.getCompilationUnits();
        ArrayList<IResource> files = new ArrayList<IResource>(cus.length);
        int i = 0;
        while (i < cus.length) {
            IResource res = ResourceUtil.getResource(cus[i]);
            if (res != null && res.getType() == 1) {
                files.add(res);
            }
            ++i;
        }
        return files.toArray(new IFile[files.size()]);
    }

    private IFile[] getAllFilesToModify() throws CoreException {
        ArrayList<IFile> combined = new ArrayList<IFile>();
        combined.addAll(Arrays.asList(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits())));
        combined.addAll(Arrays.asList(this.getAllCusInPackageAsFiles()));
        if (this.fQualifiedNameSearchResult != null) {
            combined.addAll(Arrays.asList(this.fQualifiedNameSearchResult.getAllFiles()));
        }
        return combined.toArray(new IFile[combined.size()]);
    }

    private RefactoringStatus validateModifiesFiles() throws CoreException {
        return Checks.validateModifiesFiles(this.getAllFilesToModify());
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        CompositeChange compositeChange;
        try {
            pm.beginTask(RefactoringCoreMessages.getString("RenamePackageRefactoring.creating_change"), 1);
            CompositeChange builder = new CompositeChange();
            builder.addAll(this.fChangeManager.getAllChanges());
            if (this.fQualifiedNameSearchResult != null) {
                builder.addAll(this.fQualifiedNameSearchResult.getAllChanges());
            }
            builder.add(new RenamePackageChange(this.fPackage, this.fNewName));
            pm.worked(1);
            compositeChange = builder;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return compositeChange;
    }

    private void addTextMatches(TextChangeManager manager, IProgressMonitor pm) throws JavaModelException {
        TextMatchFinder.findTextMatches(pm, this.createRefactoringScope(), this, manager);
    }

    private TextEdit createTextChange(SearchResult searchResult) {
        return SimpleTextEdit.createReplace(searchResult.getStart(), searchResult.getEnd() - searchResult.getStart(), this.fNewName);
    }

    private TextChangeManager createChangeManager(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 2);
        TextChangeManager manager = new TextChangeManager();
        pm.subTask(RefactoringCoreMessages.getString("RenamePackageRefactoring.searching_text"));
        this.addTextMatches(manager, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        if (this.fUpdateReferences) {
            this.addReferenceUpdates(manager, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        }
        return manager;
    }

    private void addReferenceUpdates(TextChangeManager manager, IProgressMonitor pm) throws CoreException {
        pm.beginTask("", this.fOccurrences.length);
        int i = 0;
        while (i < this.fOccurrences.length) {
            ICompilationUnit cu = this.fOccurrences[i].getCompilationUnit();
            if (cu != null) {
                String name = RefactoringCoreMessages.getString("RenamePackageRefactoring.update_reference");
                ICompilationUnit wc = WorkingCopyUtil.getWorkingCopyIfExists(cu);
                SearchResult[] results = this.fOccurrences[i].getSearchResults();
                int j = 0;
                while (j < results.length) {
                    manager.get(wc).addTextEdit(name, this.createTextChange(results[j]));
                    ++j;
                }
                pm.worked(1);
            }
            ++i;
        }
    }

    private void computeQualifiedNameMatches(IProgressMonitor pm) throws JavaModelException {
        this.fQualifiedNameSearchResult = QualifiedNameFinder.process(this.fPackage.getElementName(), this.fNewName, this.fFilePatterns, this.fPackage.getJavaProject().getProject(), pm);
    }
}

