/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ISearchPattern;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResult;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameMethodInInterfaceRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenamePrivateMethodRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameStaticMethodRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameVirtualMethodRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.RippleMethodFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.UpdateMethodReferenceEdit;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdatingRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IRenameRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;

public abstract class RenameMethodRefactoring
extends Refactoring
implements IRenameRefactoring,
IReferenceUpdatingRefactoring {
    private String fNewName;
    private SearchResultGroup[] fOccurrences;
    private boolean fUpdateReferences;
    private IMethod fMethod;
    private TextChangeManager fChangeManager;
    private ICompilationUnit[] fNewWorkingCopies;

    RenameMethodRefactoring(IMethod method) {
        Assert.isNotNull(method);
        this.fMethod = method;
        this.fNewName = method.getElementName();
        this.fUpdateReferences = true;
    }

    public static RenameMethodRefactoring createInstance(IMethod method) throws JavaModelException {
        if (JdtFlags.isPrivate((IMember)method)) {
            return new RenamePrivateMethodRefactoring(method);
        }
        if (JdtFlags.isStatic((IMember)method)) {
            return new RenameStaticMethodRefactoring(method);
        }
        if (method.getDeclaringType().isClass()) {
            return new RenameVirtualMethodRefactoring(method);
        }
        return new RenameMethodInInterfaceRefactoring(method);
    }

    public static RenameMethodRefactoring createInstance(IMethod method, RenameMethodRefactoring other) throws JavaModelException {
        RenameMethodRefactoring result = RenameMethodRefactoring.createInstance(method);
        result.setData(other);
        return result;
    }

    protected void setData(RenameMethodRefactoring other) {
        this.fUpdateReferences = other.fUpdateReferences;
        this.fNewName = other.fNewName;
    }

    public Object getNewElement() {
        return this.fMethod.getDeclaringType().getMethod(this.fNewName, this.fMethod.getParameterTypes());
    }

    public RefactoringStatus checkPreconditions(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = this.checkPreactivation();
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(super.checkPreconditions(pm));
        return result;
    }

    public final void setNewName(String newName) {
        Assert.isNotNull(newName);
        this.fNewName = newName;
    }

    public final String getCurrentName() {
        return this.fMethod.getElementName();
    }

    public final String getNewName() {
        return this.fNewName;
    }

    public String getName() {
        return RefactoringCoreMessages.getFormattedString("RenameMethodRefactoring.name", new String[]{this.fMethod.getElementName(), this.getNewName()});
    }

    public final IMethod getMethod() {
        return this.fMethod;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public final void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public RefactoringStatus checkPreactivation() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(Checks.checkAvailability((IJavaElement)this.fMethod));
        if (RenameMethodRefactoring.isSpecialCase(this.fMethod)) {
            result.addError(RefactoringCoreMessages.getString("RenameMethodRefactoring.special_case"));
        }
        if (this.fMethod.isConstructor()) {
            result.addFatalError(RefactoringCoreMessages.getString("RenameMethodRefactoring.no_constructors"));
        }
        return result;
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        IMethod orig = RenameMethodRefactoring.getOriginalMethod(this.fMethod);
        if (orig == null || !orig.exists()) {
            String message = RefactoringCoreMessages.getFormattedString("RenameMethodRefactoring.deleted", this.fMethod.getCompilationUnit().getElementName());
            return RefactoringStatus.createFatalErrorStatus(message);
        }
        this.fMethod = orig;
        RefactoringStatus result = Checks.checkIfCuBroken((IMember)this.fMethod);
        if (JdtFlags.isNative((IMember)this.fMethod)) {
            result.addError(RefactoringCoreMessages.getString("RenameMethodRefactoring.no_native"));
        }
        return result;
    }

    private static IMethod getOriginalMethod(IMethod method) throws JavaModelException {
        return (IMethod)WorkingCopyUtil.getOriginal((IMember)method);
    }

    public final RefactoringStatus checkNewName(String newName) {
        Assert.isNotNull(newName, "new name");
        RefactoringStatus result = Checks.checkMethodName(newName);
        if (Checks.isAlreadyNamed((IJavaElement)this.fMethod, newName)) {
            result.addFatalError(RefactoringCoreMessages.getString("RenameMethodRefactoring.same_name"));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block13: {
            RefactoringStatus refactoringStatus2;
            block12: {
                RefactoringStatus refactoringStatus3;
                block11: {
                    try {
                        try {
                            RefactoringStatus result = new RefactoringStatus();
                            pm.beginTask("", 4);
                            result.merge(Checks.checkIfCuBroken((IMember)this.fMethod));
                            if (result.hasFatalError()) {
                                refactoringStatus3 = result;
                                Object var3_8 = null;
                                break block11;
                            }
                            pm.setTaskName(RefactoringCoreMessages.getString("RenameMethodRefactoring.taskName.checkingPreconditions"));
                            result.merge(this.checkNewName(this.fNewName));
                            pm.worked(1);
                            pm.setTaskName(RefactoringCoreMessages.getString("RenameMethodRefactoring.taskName.searchingForReferences"));
                            this.fOccurrences = this.getOccurrences((IProgressMonitor)new SubProgressMonitor(pm, 4));
                            pm.setTaskName(RefactoringCoreMessages.getString("RenameMethodRefactoring.taskName.checkingPreconditions"));
                            if (this.fUpdateReferences) {
                                result.merge(this.checkRelatedMethods((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                            } else {
                                pm.worked(1);
                            }
                            if (this.fUpdateReferences) {
                                result.merge(this.analyzeCompilationUnits());
                            }
                            pm.worked(1);
                            if (result.hasFatalError()) {
                                refactoringStatus2 = result;
                                break block12;
                            }
                            if (this.fUpdateReferences) {
                                result.merge(this.analyzeRenameChanges((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                            }
                            this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 3));
                            result.merge(this.validateModifiesFiles());
                            refactoringStatus = result;
                            break block13;
                        }
                        catch (JavaModelException e) {
                            throw e;
                        }
                        catch (CoreException e) {
                            throw new JavaModelException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_11 = null;
                        pm.done();
                        throw throwable;
                    }
                }
                pm.done();
                return refactoringStatus3;
            }
            Object var3_9 = null;
            pm.done();
            return refactoringStatus2;
        }
        Object var3_10 = null;
        pm.done();
        return refactoringStatus;
    }

    private IJavaSearchScope createRefactoringScope() throws JavaModelException {
        return RefactoringScopeFactory.create((IJavaElement)this.fMethod);
    }

    ISearchPattern createSearchPattern(IProgressMonitor pm) throws JavaModelException {
        return RenameMethodRefactoring.createSearchPattern(pm, this.fMethod, null);
    }

    private static ISearchPattern createSearchPattern(IProgressMonitor pm, IMethod method, IWorkingCopy[] workingCopies) throws JavaModelException {
        pm.beginTask("", 4);
        Set methods = RenameMethodRefactoring.methodsToRename(method, (IProgressMonitor)new SubProgressMonitor(pm, 3), workingCopies);
        IMethod[] ms = methods.toArray(new IMethod[methods.size()]);
        pm.done();
        return RefactoringSearchEngine.createSearchPattern((IJavaElement[])ms, 3);
    }

    static Set getMethodsToRename(IMethod method, IProgressMonitor pm, IWorkingCopy[] workingCopies) throws JavaModelException {
        return new HashSet<IMethod>(Arrays.asList(RippleMethodFinder.getRelatedMethods(method, pm, workingCopies)));
    }

    private static Set methodsToRename(IMethod method, IProgressMonitor pm, IWorkingCopy[] workingCopies) throws JavaModelException {
        HashSet<IMethod> methods = new HashSet<IMethod>();
        pm.beginTask("", 1);
        methods.add(method);
        methods.addAll(RenameMethodRefactoring.getMethodsToRename(method, (IProgressMonitor)new SubProgressMonitor(pm, 1), workingCopies));
        pm.done();
        return methods;
    }

    SearchResultGroup[] getOccurrences() {
        return this.fOccurrences;
    }

    private SearchResultGroup[] getOccurrences(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 2);
        ISearchPattern pattern = this.createSearchPattern((IProgressMonitor)new SubProgressMonitor(pm, 1));
        return RefactoringSearchEngine.search((IProgressMonitor)new SubProgressMonitor(pm, 1), this.createRefactoringScope(), pattern);
    }

    private static boolean isSpecialCase(IMethod method) throws JavaModelException {
        if (method.getElementName().equals("toString") && method.getNumberOfParameters() == 0 && (method.getReturnType().equals("Ljava.lang.String;") || method.getReturnType().equals("QString;") || method.getReturnType().equals("Qjava.lang.String;"))) {
            return true;
        }
        return method.isMainMethod();
    }

    private static RefactoringStatus checkIfConstructorName(IMethod method, String newName) {
        return Checks.checkIfConstructorName(method, newName, method.getDeclaringType().getElementName());
    }

    private RefactoringStatus checkRelatedMethods(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        Iterator iter = RenameMethodRefactoring.getMethodsToRename(this.fMethod, pm, null).iterator();
        while (iter.hasNext()) {
            IMethod method = (IMethod)iter.next();
            result.merge(RenameMethodRefactoring.checkIfConstructorName(method, this.fNewName));
            String[] msgData = new String[]{method.getElementName(), JavaModelUtil.getFullyQualifiedName(method.getDeclaringType())};
            if (!method.exists()) {
                result.addFatalError(RefactoringCoreMessages.getFormattedString("RenameMethodRefactoring.not_in_model", msgData));
                continue;
            }
            if (method.isBinary()) {
                result.addFatalError(RefactoringCoreMessages.getFormattedString("RenameMethodRefactoring.no_binary", msgData));
            }
            if (method.isReadOnly()) {
                result.addFatalError(RefactoringCoreMessages.getFormattedString("RenameMethodRefactoring.no_read_only", msgData));
            }
            if (!JdtFlags.isNative((IMember)method)) continue;
            result.addError(RefactoringCoreMessages.getFormattedString("RenameMethodRefactoring.no_native_1", msgData));
        }
        return result;
    }

    private IFile[] getAllFilesToModify() throws JavaModelException {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    private RefactoringStatus validateModifiesFiles() throws CoreException {
        return Checks.validateModifiesFiles(this.getAllFilesToModify());
    }

    private RefactoringStatus analyzeCompilationUnits() throws JavaModelException {
        if (this.fOccurrences.length == 0) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        this.fOccurrences = Checks.excludeCompilationUnits(this.fOccurrences, result);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(Checks.checkCompileErrorsInAffectedFiles(this.fOccurrences));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefactoringStatus analyzeRenameChanges(IProgressMonitor pm) throws JavaModelException {
        int i2;
        Throwable throwable2;
        block9: {
            RefactoringStatus refactoringStatus;
            try {
                try {
                    RefactoringStatus result;
                    pm.beginTask("", 3);
                    TextChangeManager manager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1));
                    SearchResultGroup[] oldOccurrences = this.getOldOccurrences((IProgressMonitor)new SubProgressMonitor(pm, 1));
                    SearchResultGroup[] newOccurrences = this.getNewOccurrences((IProgressMonitor)new SubProgressMonitor(pm, 1), manager);
                    refactoringStatus = result = RenameAnalyzeUtil.analyzeRenameChanges(manager, oldOccurrences, newOccurrences);
                    Object var6_9 = null;
                }
                catch (JavaModelException e) {
                    throw e;
                }
                catch (CoreException e) {
                    throw new JavaModelException(e);
                }
            }
            catch (Throwable throwable2) {
                Object var6_10 = null;
                pm.done();
                if (this.fNewWorkingCopies == null) throw throwable2;
                i2 = 0;
                break block9;
            }
            pm.done();
            if (this.fNewWorkingCopies == null) return refactoringStatus;
            int i2 = 0;
            while (i2 < this.fNewWorkingCopies.length) {
                this.fNewWorkingCopies[i2].destroy();
                ++i2;
            }
            return refactoringStatus;
        }
        while (true) {
            if (i2 >= this.fNewWorkingCopies.length) {
                throw throwable2;
            }
            this.fNewWorkingCopies[i2].destroy();
            ++i2;
        }
    }

    private SearchResultGroup[] getOldOccurrences(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 2);
        ISearchPattern oldPattern = this.createSearchPattern((IProgressMonitor)new SubProgressMonitor(pm, 1));
        return RefactoringSearchEngine.search((IProgressMonitor)new SubProgressMonitor(pm, 1), this.createRefactoringScope(), oldPattern);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SearchResultGroup[] getNewOccurrences(IProgressMonitor pm, TextChangeManager manager) throws CoreException {
        SearchResultGroup[] searchResultGroupArray;
        block6: {
            SearchResultGroup[] searchResultGroupArray2;
            block5: {
                SearchResultGroup[] searchResultGroupArray3;
                block4: {
                    pm.beginTask("", 3);
                    try {
                        ICompilationUnit[] compilationUnitsToModify = manager.getAllCompilationUnits();
                        this.fNewWorkingCopies = RenameAnalyzeUtil.getNewWorkingCopies(compilationUnitsToModify, manager, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                        ICompilationUnit declaringCuWorkingCopy = RenameAnalyzeUtil.findWorkingCopyForCu(this.fNewWorkingCopies, this.fMethod.getCompilationUnit());
                        if (declaringCuWorkingCopy == null) {
                            searchResultGroupArray3 = new SearchResultGroup[]{};
                            Object var7_8 = null;
                            break block4;
                        }
                        IMethod method = this.getNewMethod(declaringCuWorkingCopy);
                        if (method == null || !method.exists()) {
                            searchResultGroupArray2 = new SearchResultGroup[]{};
                            break block5;
                        }
                        ISearchPattern newPattern = RenameMethodRefactoring.createSearchPattern((IProgressMonitor)new SubProgressMonitor(pm, 1), method, (IWorkingCopy[])this.fNewWorkingCopies);
                        searchResultGroupArray = RefactoringSearchEngine.search((IProgressMonitor)new SubProgressMonitor(pm, 1), this.createRefactoringScope(), newPattern, this.fNewWorkingCopies);
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        pm.done();
                        throw throwable;
                    }
                }
                pm.done();
                return searchResultGroupArray3;
            }
            Object var7_9 = null;
            pm.done();
            return searchResultGroupArray2;
        }
        Object var7_10 = null;
        pm.done();
        return searchResultGroupArray;
    }

    private IMethod getNewMethod(ICompilationUnit newWorkingCopyOfDeclaringCu) throws JavaModelException {
        IType[] allNewTypes = newWorkingCopyOfDeclaringCu.getAllTypes();
        String fullyTypeName = this.fMethod.getDeclaringType().getFullyQualifiedName();
        String[] paramTypeSignatures = this.fMethod.getParameterTypes();
        int i = 0;
        while (i < allNewTypes.length) {
            if (allNewTypes[i].getFullyQualifiedName().equals(fullyTypeName)) {
                return allNewTypes[i].getMethod(this.fNewName, paramTypeSignatures);
            }
            ++i;
        }
        return null;
    }

    private IMethod classesDeclareMethodName(ITypeHierarchy hier, List classes, IMethod method, String newName) throws JavaModelException {
        IType type = method.getDeclaringType();
        List<IType> subtypes = Arrays.asList(hier.getAllSubtypes(type));
        int parameterCount = method.getParameterTypes().length;
        boolean isMethodPrivate = JdtFlags.isPrivate((IMember)method);
        Iterator iter = classes.iterator();
        while (iter.hasNext()) {
            IType clazz = (IType)iter.next();
            IMethod[] methods = clazz.getMethods();
            boolean isSubclass = subtypes.contains(clazz);
            int j = 0;
            while (j < methods.length) {
                IMethod foundMethod = Checks.findMethod(newName, parameterCount, false, new IMethod[]{methods[j]});
                if (foundMethod != null) {
                    if (isSubclass || type.equals(clazz)) {
                        return foundMethod;
                    }
                    if (!isMethodPrivate && !JdtFlags.isPrivate((IMember)methods[j])) {
                        return foundMethod;
                    }
                }
                ++j;
            }
        }
        return null;
    }

    final IMethod hierarchyDeclaresMethodName(IProgressMonitor pm, IMethod method, String newName) throws JavaModelException {
        IType type = method.getDeclaringType();
        ITypeHierarchy hier = type.newTypeHierarchy(pm);
        IMethod foundMethod = Checks.findMethod(newName, method.getParameterTypes().length, false, type);
        if (foundMethod != null) {
            return foundMethod;
        }
        IMethod foundInHierarchyClasses = this.classesDeclareMethodName(hier, Arrays.asList(hier.getAllClasses()), method, newName);
        if (foundInHierarchyClasses != null) {
            return foundInHierarchyClasses;
        }
        IType[] implementingClasses = hier.getImplementingClasses(type);
        IMethod foundInImplementingClasses = this.classesDeclareMethodName(hier, Arrays.asList(implementingClasses), method, newName);
        if (foundInImplementingClasses != null) {
            return foundInImplementingClasses;
        }
        return null;
    }

    public final IChange createChange(IProgressMonitor pm) throws JavaModelException {
        CompositeChange compositeChange;
        try {
            compositeChange = new CompositeChange(RefactoringCoreMessages.getString("RenameMethodRefactoring.rename"), this.fChangeManager.getAllChanges());
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return compositeChange;
    }

    private TextChangeManager createChangeManager(IProgressMonitor pm) throws CoreException {
        TextChangeManager manager = new TextChangeManager();
        if (!this.fUpdateReferences) {
            this.addDeclarationUpdate(manager);
        } else {
            this.addOccurrences(manager, pm);
        }
        return manager;
    }

    void addOccurrences(TextChangeManager manager, IProgressMonitor pm) throws CoreException {
        pm.beginTask("", this.fOccurrences.length);
        int i = 0;
        while (i < this.fOccurrences.length) {
            ICompilationUnit cu = this.fOccurrences[i].getCompilationUnit();
            if (cu != null) {
                ICompilationUnit wc = WorkingCopyUtil.getWorkingCopyIfExists(cu);
                SearchResult[] results = this.fOccurrences[i].getSearchResults();
                int j = 0;
                while (j < results.length) {
                    String editName = RefactoringCoreMessages.getString("RenameMethodRefactoring.update_occurrence");
                    manager.get(wc).addTextEdit(editName, this.createTextChange(results[j]));
                    ++j;
                }
                pm.worked(1);
            }
            ++i;
        }
    }

    private void addDeclarationUpdate(TextChangeManager manager) throws CoreException {
        ICompilationUnit cu = WorkingCopyUtil.getWorkingCopyIfExists(this.fMethod.getCompilationUnit());
        TextChange change = manager.get(cu);
        this.addDeclarationUpdate(change);
    }

    final void addDeclarationUpdate(TextChange change) throws JavaModelException {
        change.addTextEdit(RefactoringCoreMessages.getString("RenameMethodRefactoring.update_declaration"), SimpleTextEdit.createReplace(this.fMethod.getNameRange().getOffset(), this.fMethod.getNameRange().getLength(), this.fNewName));
    }

    final TextEdit createTextChange(SearchResult searchResult) {
        return new UpdateMethodReferenceEdit(searchResult.getStart(), searchResult.getEnd() - searchResult.getStart(), this.fNewName, this.fMethod.getElementName());
    }
}

