/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.Context;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaSourceContext;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameMethodRefactoring;

class RenameMethodInInterfaceRefactoring
extends RenameMethodRefactoring {
    RenameMethodInInterfaceRefactoring(IMethod method) {
        super(method);
    }

    public RefactoringStatus checkPreactivation() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(super.checkPreactivation());
        if (!this.getMethod().getDeclaringType().isInterface()) {
            result.addFatalError(RefactoringCoreMessages.getString("RenameMethodInInterfaceRefactoring.no_class_method"));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block6: {
            RefactoringStatus refactoringStatus2;
            block5: {
                RefactoringStatus refactoringStatus3;
                block4: {
                    try {
                        pm.beginTask("", 1);
                        RefactoringStatus result = new RefactoringStatus();
                        result.merge(super.checkActivation((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                        if (result.hasFatalError()) {
                            refactoringStatus3 = result;
                            Object var3_6 = null;
                            break block4;
                        }
                        result.merge(MethodChecks.checkIfOverridesAnother(this.getMethod(), (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                        if (result.hasFatalError()) {
                            refactoringStatus2 = result;
                            break block5;
                        }
                        refactoringStatus = result;
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var3_9 = null;
                        pm.done();
                        throw throwable;
                    }
                }
                pm.done();
                return refactoringStatus3;
            }
            Object var3_7 = null;
            pm.done();
            return refactoringStatus2;
        }
        Object var3_8 = null;
        pm.done();
        return refactoringStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block6: {
            RefactoringStatus refactoringStatus2;
            block5: {
                pm.beginTask("", 11);
                try {
                    RefactoringStatus result = new RefactoringStatus();
                    result.merge(super.checkInput((IProgressMonitor)new SubProgressMonitor(pm, 6)));
                    if (result.hasFatalError()) {
                        refactoringStatus2 = result;
                        Object var5_5 = null;
                        break block5;
                    }
                    if (this.isSpecialCase()) {
                        result.addError(RefactoringCoreMessages.getString("RenameMethodInInterfaceRefactoring.special_case"));
                    }
                    pm.worked(1);
                    IMethod relatedMethod = this.relatedTypeDeclaresMethodName((IProgressMonitor)new SubProgressMonitor(pm, 3), this.getMethod(), this.getNewName());
                    if (relatedMethod != null) {
                        Context context = JavaSourceContext.create((IMember)relatedMethod);
                        result.addError(RefactoringCoreMessages.getString("RenameMethodInInterfaceRefactoring.already_defined"), context);
                    }
                    refactoringStatus = result;
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    pm.done();
                    throw throwable;
                }
            }
            pm.done();
            return refactoringStatus2;
        }
        Object var5_6 = null;
        pm.done();
        return refactoringStatus;
    }

    private IMethod relatedTypeDeclaresMethodName(IProgressMonitor pm, IMethod method, String newName) throws JavaModelException {
        IMethod iMethod;
        try {
            pm.beginTask("", 2);
            Set types = this.getRelatedTypes((IProgressMonitor)new SubProgressMonitor(pm, 1));
            Iterator iter = types.iterator();
            while (iter.hasNext()) {
                IMethod m = Checks.findMethod(method, (IType)iter.next());
                IMethod hierarchyMethod = this.hierarchyDeclaresMethodName((IProgressMonitor)new SubProgressMonitor(pm, 1), m, newName);
                if (hierarchyMethod == null) continue;
                iMethod = hierarchyMethod;
                Object var8_9 = null;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            pm.done();
            throw throwable;
        }
        {
            pm.done();
            return iMethod;
        }
        Object var8_10 = null;
        pm.done();
        return null;
    }

    private boolean isSpecialCase() throws JavaModelException {
        String[] noParams = new String[]{};
        String[] specialNames = new String[]{"toString", "toString", "toString", "toString", "equals", "equals", "getClass", "getClass", "hashCode", "notify", "notifyAll", "wait", "wait", "wait"};
        String[][] specialParamTypes = new String[][]{noParams, noParams, noParams, noParams, {"QObject;"}, {"Qjava.lang.Object;"}, noParams, noParams, noParams, noParams, noParams, {"J", "I"}, {"J"}, noParams};
        String[] specialReturnTypes = new String[]{"QString;", "QString;", "Qjava.lang.String;", "Qjava.lang.String;", "Z", "Z", "QClass;", "Qjava.lang.Class;", "I", "V", "V", "V", "V", "V"};
        Assert.isTrue(specialNames.length == specialParamTypes.length && specialParamTypes.length == specialReturnTypes.length);
        int i = 0;
        while (i < specialNames.length) {
            if (specialNames[i].equals(this.getNewName()) && Checks.compareParamTypes(this.getMethod().getParameterTypes(), specialParamTypes[i]) && !specialReturnTypes[i].equals(this.getMethod().getReturnType())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Set getRelatedTypes(IProgressMonitor pm) throws JavaModelException {
        Set methods = RenameMethodRefactoring.getMethodsToRename(this.getMethod(), pm, null);
        HashSet<IType> result = new HashSet<IType>(methods.size());
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            result.add(((IMethod)iter.next()).getDeclaringType());
        }
        return result;
    }
}

