/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameJavaProjectChange;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdatingRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IRenameRefactoring;

public class RenameJavaProjectRefactoring
extends Refactoring
implements IRenameRefactoring,
IReferenceUpdatingRefactoring {
    private final IJavaProject fProject;
    private String fNewName;
    private boolean fUpdateReferences;

    public RenameJavaProjectRefactoring(IJavaProject project) {
        Assert.isNotNull(project);
        this.fProject = project;
        this.fNewName = project.getElementName();
        this.fUpdateReferences = false;
    }

    public Object getNewElement() throws JavaModelException {
        IPath newPath = this.fProject.getPath().removeLastSegments(1).append(this.getNewName());
        return ResourcesPlugin.getWorkspace().getRoot().findMember(newPath);
    }

    public void setNewName(String newName) {
        Assert.isNotNull(newName);
        this.fNewName = newName;
    }

    public String getNewName() {
        return this.fNewName;
    }

    public String getCurrentName() {
        return this.fProject.getElementName();
    }

    public String getName() {
        String messages = RefactoringCoreMessages.getFormattedString("RenameJavaProjectRefactoring.rename", new String[]{this.getCurrentName(), this.fNewName});
        return messages;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        if (!this.fProject.exists()) {
            return RefactoringStatus.createFatalErrorStatus("");
        }
        if (this.fProject.isReadOnly()) {
            return RefactoringStatus.createFatalErrorStatus("");
        }
        if (!this.fProject.isConsistent()) {
            return RefactoringStatus.createFatalErrorStatus("");
        }
        if (!this.fProject.isStructureKnown()) {
            return RefactoringStatus.createFatalErrorStatus("");
        }
        return new RefactoringStatus();
    }

    public RefactoringStatus checkNewName(String newName) throws JavaModelException {
        Assert.isNotNull(newName, "new name");
        RefactoringStatus result = RefactoringStatus.create(ResourcesPlugin.getWorkspace().validateName(newName, 4));
        if (result.hasFatalError()) {
            return result;
        }
        if (this.projectNameAlreadyExists(newName)) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("RenameJavaProjectRefactoring.already_exists"));
        }
        return new RefactoringStatus();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block4: {
            RefactoringStatus refactoringStatus2;
            block3: {
                pm.beginTask("", 1);
                try {
                    if (this.isReadOnly()) {
                        String message = RefactoringCoreMessages.getFormattedString("RenameJavaProjectRefactoring.read_only", this.fProject.getElementName());
                        refactoringStatus2 = RefactoringStatus.createErrorStatus(message);
                        Object var3_5 = null;
                        break block3;
                    }
                    refactoringStatus = new RefactoringStatus();
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var3_7 = null;
                    pm.done();
                    throw throwable;
                }
            }
            pm.done();
            return refactoringStatus2;
        }
        Object var3_6 = null;
        pm.done();
        return refactoringStatus;
    }

    private boolean isReadOnly() throws JavaModelException {
        return this.fProject.getResource().isReadOnly();
    }

    private boolean projectNameAlreadyExists(String newName) {
        return this.fProject.getJavaModel().getJavaProject(newName).exists();
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        RenameJavaProjectChange renameJavaProjectChange;
        pm.beginTask("", 1);
        try {
            renameJavaProjectChange = new RenameJavaProjectChange(this.fProject, this.fNewName, this.fUpdateReferences);
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return renameJavaProjectChange;
    }
}

