/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ISearchPattern;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResult;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaSourceContext;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.rename.TextMatchFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.UpdateMethodReferenceEdit;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdatingRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IRenameRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdatingRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEditCopier;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRange;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;

public class RenameFieldRefactoring
extends Refactoring
implements IRenameRefactoring,
IReferenceUpdatingRefactoring,
ITextUpdatingRefactoring {
    private static final String DECLARED_SUPERTYPE = RefactoringCoreMessages.getString("RenameFieldRefactoring.declared_in_supertype");
    private IField fField;
    private String fNewName;
    private SearchResultGroup[] fReferences;
    private TextChangeManager fChangeManager;
    private ICompilationUnit[] fNewWorkingCopies;
    private boolean fUpdateReferences;
    private boolean fUpdateJavaDoc;
    private boolean fUpdateComments;
    private boolean fUpdateStrings;
    private boolean fRenameGetter;
    private boolean fRenameSetter;

    public RenameFieldRefactoring(IField field) {
        Assert.isNotNull(field);
        this.fField = field;
        this.fNewName = this.fField.getElementName();
        this.fUpdateReferences = true;
        this.fUpdateJavaDoc = false;
        this.fUpdateComments = false;
        this.fUpdateStrings = false;
        this.fRenameGetter = false;
        this.fRenameSetter = false;
    }

    public Object getNewElement() {
        return this.fField.getDeclaringType().getField(this.fNewName);
    }

    public boolean canEnableTextUpdating() {
        return true;
    }

    public boolean getUpdateJavaDoc() {
        return this.fUpdateJavaDoc;
    }

    public boolean getUpdateComments() {
        return this.fUpdateComments;
    }

    public boolean getUpdateStrings() {
        return this.fUpdateStrings;
    }

    public void setUpdateJavaDoc(boolean update) {
        this.fUpdateJavaDoc = update;
    }

    public void setUpdateComments(boolean update) {
        this.fUpdateComments = update;
    }

    public void setUpdateStrings(boolean update) {
        this.fUpdateStrings = update;
    }

    public RefactoringStatus checkPreconditions(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = this.checkPreactivation();
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(super.checkPreconditions(pm));
        return result;
    }

    public final void setNewName(String newName) {
        Assert.isNotNull(newName);
        this.fNewName = newName;
    }

    public final String getCurrentName() {
        return this.fField.getElementName();
    }

    public String canEnableGetterRenaming() throws JavaModelException {
        if (this.fField.getDeclaringType().isInterface()) {
            return this.getGetter() == null ? "" : null;
        }
        IMethod getter = this.getGetter();
        if (getter == null) {
            return "";
        }
        if (MethodChecks.isVirtual(getter) && MethodChecks.isDeclaredInInterface(getter, (IProgressMonitor)new NullProgressMonitor()) != null) {
            return DECLARED_SUPERTYPE;
        }
        if (MethodChecks.isVirtual(getter) && MethodChecks.overridesAnotherMethod(getter, (IProgressMonitor)new NullProgressMonitor()) != null) {
            return DECLARED_SUPERTYPE;
        }
        return null;
    }

    public String canEnableSetterRenaming() throws JavaModelException {
        if (this.fField.getDeclaringType().isInterface()) {
            return this.getSetter() == null ? "" : null;
        }
        IMethod setter = this.getSetter();
        if (setter == null) {
            return "";
        }
        if (MethodChecks.isVirtual(setter) && MethodChecks.isDeclaredInInterface(setter, (IProgressMonitor)new NullProgressMonitor()) != null) {
            return DECLARED_SUPERTYPE;
        }
        if (MethodChecks.isVirtual(setter) && MethodChecks.overridesAnotherMethod(setter, (IProgressMonitor)new NullProgressMonitor()) != null) {
            return DECLARED_SUPERTYPE;
        }
        return null;
    }

    public boolean getRenameGetter() {
        return this.fRenameGetter;
    }

    public void setRenameGetter(boolean renameGetter) {
        this.fRenameGetter = renameGetter;
    }

    public boolean getRenameSetter() {
        return this.fRenameSetter;
    }

    public void setRenameSetter(boolean renameSetter) {
        this.fRenameSetter = renameSetter;
    }

    public IMethod getGetter() throws JavaModelException {
        return GetterSetterUtil.getGetter(this.fField);
    }

    public IMethod getSetter() throws JavaModelException {
        return GetterSetterUtil.getSetter(this.fField);
    }

    public String getNewGetterName() throws JavaModelException {
        IMethod primaryGetterCandidate = JavaModelUtil.findMethod(GetterSetterUtil.getGetterName(this.fField, new String[0]), new String[0], false, this.fField.getDeclaringType());
        if (!JavaModelUtil.isBoolean(this.fField) || primaryGetterCandidate != null && primaryGetterCandidate.exists()) {
            return NamingConventions.suggestGetterName((IJavaProject)this.fField.getJavaProject(), (String)this.fNewName, (int)this.fField.getFlags(), (boolean)JavaModelUtil.isBoolean(this.fField), null);
        }
        return NamingConventions.suggestGetterName((IJavaProject)this.fField.getJavaProject(), (String)this.fNewName, (int)this.fField.getFlags(), (boolean)false, null);
    }

    public String getNewSetterName() throws JavaModelException {
        return NamingConventions.suggestSetterName((IJavaProject)this.fField.getJavaProject(), (String)this.fNewName, (int)this.fField.getFlags(), (boolean)JavaModelUtil.isBoolean(this.fField), null);
    }

    public final String getNewName() {
        return this.fNewName;
    }

    public String getName() {
        return RefactoringCoreMessages.getFormattedString("RenameFieldRefactoring.name", new String[]{this.fField.getElementName(), this.getNewName()});
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public RefactoringStatus checkPreactivation() throws JavaModelException {
        return Checks.checkAvailability((IJavaElement)this.fField);
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        IField orig = (IField)WorkingCopyUtil.getOriginal((IMember)this.fField);
        if (orig == null || !orig.exists()) {
            String message = RefactoringCoreMessages.getFormattedString("RenameFieldRefactoring.deleted", this.fField.getCompilationUnit().getElementName());
            return RefactoringStatus.createFatalErrorStatus(message);
        }
        this.fField = orig;
        return Checks.checkIfCuBroken((IMember)this.fField);
    }

    public RefactoringStatus checkNewName(String newName) throws JavaModelException {
        Assert.isNotNull(newName, "new name");
        RefactoringStatus result = Checks.checkFieldName(newName);
        if (RenameFieldRefactoring.isInstaceField(this.fField) && !Checks.startsWithLowerCase(newName)) {
            result.addWarning(RefactoringCoreMessages.getString("RenameFieldRefactoring.should_start_lowercase"));
        }
        if (Checks.isAlreadyNamed((IJavaElement)this.fField, newName)) {
            result.addFatalError(RefactoringCoreMessages.getString("RenameFieldRefactoring.another_name"));
        }
        if (this.fField.getDeclaringType().getField(newName).exists()) {
            result.addFatalError(RefactoringCoreMessages.getString("RenameFieldRefactoring.field_already_defined"));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block16: {
            RefactoringStatus refactoringStatus2;
            block15: {
                RefactoringStatus refactoringStatus3;
                block14: {
                    try {
                        try {
                            pm.beginTask("", 13);
                            pm.setTaskName(RefactoringCoreMessages.getString("RenameFieldRefactoring.checking"));
                            RefactoringStatus result = new RefactoringStatus();
                            result.merge(Checks.checkIfCuBroken((IMember)this.fField));
                            if (result.hasFatalError()) {
                                refactoringStatus3 = result;
                                Object var3_8 = null;
                                break block14;
                            }
                            result.merge(this.checkNewName(this.fNewName));
                            pm.worked(1);
                            result.merge(this.checkEnclosingHierarchy());
                            pm.worked(1);
                            result.merge(this.checkNestedHierarchy(this.fField.getDeclaringType()));
                            pm.worked(1);
                            this.fReferences = null;
                            if (this.fUpdateReferences) {
                                pm.setTaskName(RefactoringCoreMessages.getString("RenameFieldRefactoring.searching"));
                                this.fReferences = this.getReferences((IProgressMonitor)new SubProgressMonitor(pm, 3));
                                pm.setTaskName(RefactoringCoreMessages.getString("RenameFieldRefactoring.checking"));
                            } else {
                                pm.worked(3);
                            }
                            if (this.fUpdateReferences) {
                                result.merge(this.analyzeAffectedCompilationUnits());
                            }
                            if (this.getGetter() != null && this.fRenameGetter) {
                                result.merge(this.checkAccessor((IProgressMonitor)new SubProgressMonitor(pm, 1), this.getGetter(), this.getNewGetterName()));
                                result.merge(Checks.checkIfConstructorName(this.getGetter(), this.getNewGetterName(), this.fField.getDeclaringType().getElementName()));
                            }
                            if (this.getSetter() != null && this.fRenameSetter) {
                                result.merge(this.checkAccessor((IProgressMonitor)new SubProgressMonitor(pm, 1), this.getSetter(), this.getNewSetterName()));
                                result.merge(Checks.checkIfConstructorName(this.getSetter(), this.getNewSetterName(), this.fField.getDeclaringType().getElementName()));
                            }
                            if (this.fUpdateReferences) {
                                result.merge(this.analyzeRenameChanges((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                            } else {
                                pm.worked(1);
                            }
                            if (result.hasFatalError()) {
                                refactoringStatus2 = result;
                                break block15;
                            }
                            this.fChangeManager = this.createTextChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 5));
                            result.merge(this.validateModifiesFiles());
                            refactoringStatus = result;
                            break block16;
                        }
                        catch (JavaModelException e) {
                            throw e;
                        }
                        catch (CoreException e) {
                            throw new JavaModelException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_11 = null;
                        pm.done();
                        throw throwable;
                    }
                }
                pm.done();
                return refactoringStatus3;
            }
            Object var3_9 = null;
            pm.done();
            return refactoringStatus2;
        }
        Object var3_10 = null;
        pm.done();
        return refactoringStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefactoringStatus analyzeRenameChanges(IProgressMonitor pm) throws JavaModelException {
        int i2;
        Throwable throwable2;
        block9: {
            RefactoringStatus refactoringStatus;
            try {
                try {
                    RefactoringStatus result;
                    pm.beginTask("", 3);
                    TextChangeManager manager = this.createTextChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1));
                    SearchResultGroup[] oldOccurrences = this.getOldOccurrences((IProgressMonitor)new SubProgressMonitor(pm, 1));
                    SearchResultGroup[] newOccurrences = this.getNewOccurrences((IProgressMonitor)new SubProgressMonitor(pm, 1), manager);
                    refactoringStatus = result = RenameAnalyzeUtil.analyzeRenameChanges(manager, oldOccurrences, newOccurrences);
                    Object var6_9 = null;
                }
                catch (JavaModelException e) {
                    throw e;
                }
                catch (CoreException e) {
                    throw new JavaModelException(e);
                }
            }
            catch (Throwable throwable2) {
                Object var6_10 = null;
                pm.done();
                if (this.fNewWorkingCopies == null) throw throwable2;
                i2 = 0;
                break block9;
            }
            pm.done();
            if (this.fNewWorkingCopies == null) return refactoringStatus;
            int i2 = 0;
            while (i2 < this.fNewWorkingCopies.length) {
                this.fNewWorkingCopies[i2].destroy();
                ++i2;
            }
            return refactoringStatus;
        }
        while (true) {
            if (i2 >= this.fNewWorkingCopies.length) {
                throw throwable2;
            }
            this.fNewWorkingCopies[i2].destroy();
            ++i2;
        }
    }

    private SearchResultGroup[] getNewOccurrences(IProgressMonitor pm, TextChangeManager manager) throws CoreException {
        pm.beginTask("", 2);
        ICompilationUnit[] compilationUnitsToModify = manager.getAllCompilationUnits();
        this.fNewWorkingCopies = RenameAnalyzeUtil.getNewWorkingCopies(compilationUnitsToModify, manager, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        ICompilationUnit declaringCuWorkingCopy = RenameAnalyzeUtil.findWorkingCopyForCu(this.fNewWorkingCopies, this.fField.getCompilationUnit());
        if (declaringCuWorkingCopy == null) {
            return new SearchResultGroup[0];
        }
        IField field = this.getNewField(declaringCuWorkingCopy);
        if (field == null || !field.exists()) {
            return new SearchResultGroup[0];
        }
        ISearchPattern newPattern = SearchEngine.createSearchPattern((IJavaElement)field, (int)3);
        return RefactoringSearchEngine.search((IProgressMonitor)new SubProgressMonitor(pm, 1), this.createRefactoringScope(), newPattern, this.fNewWorkingCopies);
    }

    private SearchResultGroup[] getOldOccurrences(IProgressMonitor pm) throws JavaModelException {
        ISearchPattern oldPattern = SearchEngine.createSearchPattern((IJavaElement)this.fField, (int)3);
        return RefactoringSearchEngine.search(pm, this.createRefactoringScope(), oldPattern);
    }

    private IField getNewField(ICompilationUnit newWorkingCopyOfDeclaringCu) throws JavaModelException {
        IType[] allNewTypes = newWorkingCopyOfDeclaringCu.getAllTypes();
        String fullyTypeName = this.fField.getDeclaringType().getFullyQualifiedName();
        int i = 0;
        while (i < allNewTypes.length) {
            if (allNewTypes[i].getFullyQualifiedName().equals(fullyTypeName)) {
                return allNewTypes[i].getField(this.fNewName);
            }
            ++i;
        }
        return null;
    }

    private RefactoringStatus checkAccessor(IProgressMonitor pm, IMethod existingAccessor, String newAccessorName) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(this.checkAccessorDeclarations(pm, existingAccessor));
        result.merge(this.checkNewAccessor(existingAccessor, newAccessorName));
        return result;
    }

    private RefactoringStatus checkNewAccessor(IMethod existingAccessor, String newAccessorName) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IMethod accessor = JavaModelUtil.findMethod(newAccessorName, existingAccessor.getParameterTypes(), false, this.fField.getDeclaringType());
        if (accessor == null || !accessor.exists()) {
            return null;
        }
        String message = RefactoringCoreMessages.getFormattedString("RenameFieldRefactoring.already_exists", new String[]{JavaElementUtil.createMethodSignature(accessor), JavaModelUtil.getFullyQualifiedName(this.fField.getDeclaringType())});
        result.addError(message, JavaSourceContext.create((IMember)accessor));
        return result;
    }

    private RefactoringStatus checkAccessorDeclarations(IProgressMonitor pm, IMethod existingAccessor) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        ISearchPattern pattern = SearchEngine.createSearchPattern((IJavaElement)existingAccessor, (int)0);
        IJavaSearchScope scope = SearchEngine.createHierarchyScope((IType)this.fField.getDeclaringType());
        SearchResultGroup[] groupDeclarations = RefactoringSearchEngine.search(pm, scope, pattern);
        Assert.isTrue(groupDeclarations.length > 0);
        if (groupDeclarations.length != 1) {
            String message = RefactoringCoreMessages.getFormattedString("RenameFieldRefactoring.overridden", JavaElementUtil.createMethodSignature(existingAccessor));
            result.addError(message);
        } else {
            SearchResultGroup group = groupDeclarations[0];
            Assert.isTrue(group.getSearchResults().length > 0);
            if (group.getSearchResults().length != 1) {
                String message = RefactoringCoreMessages.getFormattedString("RenameFieldRefactoring.overridden_or_overrides", JavaElementUtil.createMethodSignature(existingAccessor));
                result.addError(message);
            }
        }
        return result;
    }

    private static boolean isInstaceField(IField field) throws JavaModelException {
        if (field.getDeclaringType().isInterface()) {
            return false;
        }
        return !JdtFlags.isStatic((IMember)field);
    }

    private RefactoringStatus checkNestedHierarchy(IType type) throws JavaModelException {
        IType[] nestedTypes = type.getTypes();
        if (nestedTypes == null) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < nestedTypes.length) {
            IField otherField = nestedTypes[i].getField(this.getNewName());
            if (otherField.exists()) {
                String msg = RefactoringCoreMessages.getFormattedString("RenameFieldRefactoring.hiding", new String[]{this.fField.getElementName(), this.getNewName(), JavaModelUtil.getFullyQualifiedName(nestedTypes[i])});
                result.addWarning(msg, JavaSourceContext.create((IMember)otherField));
            }
            result.merge(this.checkNestedHierarchy(nestedTypes[i]));
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkEnclosingHierarchy() throws JavaModelException {
        IType current = this.fField.getDeclaringType();
        if (Checks.isTopLevel(current)) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        while (current != null) {
            IField otherField = current.getField(this.getNewName());
            if (otherField.exists()) {
                String msg = RefactoringCoreMessages.getFormattedString("RenameFieldRefactoring.hiding2", new String[]{this.getNewName(), JavaModelUtil.getFullyQualifiedName(current)});
                result.addWarning(msg, JavaSourceContext.create((IMember)otherField));
            }
            current = current.getDeclaringType();
        }
        return result;
    }

    private RefactoringStatus analyzeAffectedCompilationUnits() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        this.fReferences = Checks.excludeCompilationUnits(this.fReferences, result);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(Checks.checkCompileErrorsInAffectedFiles(this.fReferences));
        return result;
    }

    private IFile[] getAllFilesToModify() throws JavaModelException {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    private RefactoringStatus validateModifiesFiles() throws CoreException {
        return Checks.validateModifiesFiles(this.getAllFilesToModify());
    }

    private ISearchPattern createSearchPattern() {
        return SearchEngine.createSearchPattern((IJavaElement)this.fField, (int)2);
    }

    private IJavaSearchScope createRefactoringScope() throws JavaModelException {
        return RefactoringScopeFactory.create((IJavaElement)this.fField);
    }

    private SearchResultGroup[] getReferences(IProgressMonitor pm) throws JavaModelException {
        return RefactoringSearchEngine.search((IProgressMonitor)new SubProgressMonitor(pm, 6), this.createRefactoringScope(), this.createSearchPattern());
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        CompositeChange compositeChange;
        try {
            compositeChange = new CompositeChange(RefactoringCoreMessages.getString("RenameFieldRefactoring.Rename_Field"), this.fChangeManager.getAllChanges());
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return compositeChange;
    }

    private TextChangeManager createTextChangeManager(IProgressMonitor pm) throws CoreException {
        TextChangeManager textChangeManager;
        try {
            pm.beginTask("", 3);
            TextChangeManager manager = new TextChangeManager();
            this.addOccurrences((IProgressMonitor)new SubProgressMonitor(pm, 1), manager);
            if (this.getGetter() != null && this.fRenameGetter) {
                this.addGetterOccurrences((IProgressMonitor)new SubProgressMonitor(pm, 1), manager);
            } else {
                pm.worked(1);
            }
            if (this.getSetter() != null && this.fRenameSetter) {
                this.addSetterOccurrences((IProgressMonitor)new SubProgressMonitor(pm, 1), manager);
            } else {
                pm.worked(1);
            }
            textChangeManager = manager;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return textChangeManager;
    }

    private void addGetterOccurrences(IProgressMonitor pm, TextChangeManager manager) throws CoreException {
        RenameFieldRefactoring.addAccessorOccurrences(pm, manager, this.getGetter(), RefactoringCoreMessages.getString("RenameFieldRefactoring.Update_getter_occurrence"), this.getNewGetterName());
    }

    private void addSetterOccurrences(IProgressMonitor pm, TextChangeManager manager) throws CoreException {
        RenameFieldRefactoring.addAccessorOccurrences(pm, manager, this.getSetter(), RefactoringCoreMessages.getString("RenameFieldRefactoring.Update_setter_occurrence"), this.getNewSetterName());
    }

    private static void addAccessorOccurrences(IProgressMonitor pm, TextChangeManager manager, IMethod accessor, String editName, String newAccessorName) throws CoreException {
        Assert.isTrue(accessor.exists());
        IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)accessor);
        ISearchPattern pattern = SearchEngine.createSearchPattern((IJavaElement)accessor, (int)3);
        SearchResultGroup[] groupedResults = RefactoringSearchEngine.search(pm, scope, pattern);
        int i = 0;
        while (i < groupedResults.length) {
            ICompilationUnit cu = groupedResults[i].getCompilationUnit();
            if (cu != null) {
                SearchResult[] results = groupedResults[i].getSearchResults();
                int j = 0;
                while (j < results.length) {
                    SearchResult searchResult = results[j];
                    ICompilationUnit wc = WorkingCopyUtil.getWorkingCopyIfExists(cu);
                    UpdateMethodReferenceEdit edit = new UpdateMethodReferenceEdit(searchResult.getStart(), searchResult.getEnd() - searchResult.getStart(), newAccessorName, accessor.getElementName());
                    manager.get(wc).addTextEdit(editName, edit);
                    ++j;
                }
            }
            ++i;
        }
    }

    private void addTextMatches(TextChangeManager manager, IProgressMonitor pm) throws JavaModelException {
        TextMatchFinder.findTextMatches(pm, this.createRefactoringScope(), this, manager);
    }

    private void addOccurrences(IProgressMonitor pm, TextChangeManager manager) throws CoreException {
        pm.beginTask("", 5);
        this.addDeclarationUpdate(manager);
        pm.worked(1);
        if (this.fUpdateReferences) {
            this.addReferenceUpdates(manager, (IProgressMonitor)new SubProgressMonitor(pm, 3));
        }
        pm.subTask(RefactoringCoreMessages.getString("RenameFieldRefactoring.searching_for_text_matches"));
        this.addTextMatches(manager, (IProgressMonitor)new SubProgressMonitor(pm, 1));
    }

    private void addDeclarationUpdate(TextChangeManager manager) throws CoreException {
        SimpleTextEdit textEdit = SimpleTextEdit.createReplace(this.fField.getNameRange().getOffset(), this.fField.getElementName().length(), this.fNewName);
        ICompilationUnit cu = WorkingCopyUtil.getWorkingCopyIfExists(this.fField.getCompilationUnit());
        manager.get(cu).addTextEdit(RefactoringCoreMessages.getString("RenameFieldRefactoring.Update_field_declaration"), textEdit);
    }

    private void addReferenceUpdates(TextChangeManager manager, IProgressMonitor pm) throws CoreException {
        pm.beginTask("", this.fReferences.length);
        String editName = RefactoringCoreMessages.getString("RenameFieldRefactoring.Update_field_reference");
        int i = 0;
        while (i < this.fReferences.length) {
            ICompilationUnit cu = this.fReferences[i].getCompilationUnit();
            if (cu != null) {
                SearchResult[] results = this.fReferences[i].getSearchResults();
                int j = 0;
                while (j < results.length) {
                    ICompilationUnit wc = WorkingCopyUtil.getWorkingCopyIfExists(cu);
                    manager.get(wc).addTextEdit(editName, this.createTextChange(results[j]));
                    ++j;
                }
                pm.worked(1);
            }
            ++i;
        }
    }

    private TextEdit createTextChange(SearchResult searchResult) {
        int offset = searchResult.getStart();
        int length = searchResult.getEnd() - searchResult.getStart();
        return new UpdateFieldReference(offset, length, this.fNewName, this.fField.getElementName());
    }

    private static final class UpdateFieldReference
    extends SimpleTextEdit {
        private String fOldName;

        UpdateFieldReference(int offset, int length, String newName, String oldName) {
            super(offset, length, newName);
            Assert.isNotNull(oldName);
            this.fOldName = oldName;
        }

        UpdateFieldReference(TextRange range, String newName, String oldName) {
            super(range, newName);
            Assert.isNotNull(oldName);
            this.fOldName = oldName;
        }

        protected TextEdit copy0(TextEditCopier copier) {
            return new UpdateFieldReference(this.getTextRange().copy(), this.getText(), this.fOldName);
        }

        public void connect(TextBuffer buffer) throws CoreException {
            TextRange oldRange = this.getTextRange();
            int offset = oldRange.getOffset() + oldRange.getLength() - this.fOldName.length();
            this.setTextRange(new TextRange(offset, this.fOldName.length()));
        }
    }
}

