/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameResourceChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameTypeRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IQualifiedNameUpdatingRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdatingRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IRenameRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdatingRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;

public class RenameCompilationUnitRefactoring
extends Refactoring
implements IRenameRefactoring,
IReferenceUpdatingRefactoring,
ITextUpdatingRefactoring,
IQualifiedNameUpdatingRefactoring {
    private static final String JAVA_CU_SUFFIX = ".java";
    private String fNewName;
    private RenameTypeRefactoring fRenameTypeRefactoring;
    private boolean fWillRenameType;
    private ICompilationUnit fCu;

    public RenameCompilationUnitRefactoring(ICompilationUnit cu) {
        Assert.isNotNull(cu);
        Assert.isTrue(!cu.isWorkingCopy());
        this.fCu = cu;
        this.computeRenameTypeRefactoring();
        this.fNewName = this.fCu.getElementName();
    }

    public Object getNewElement() {
        IJavaElement parent = this.fCu.getParent();
        if (parent.getElementType() != 4) {
            return this.fCu;
        }
        IPackageFragment pack = (IPackageFragment)parent;
        if (JavaConventions.validateCompilationUnitName((String)this.getNewCuName()).getSeverity() == 4) {
            return this.fCu;
        }
        return pack.getCompilationUnit(this.getNewCuName());
    }

    public RefactoringStatus checkPreconditions(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = this.checkPreactivation();
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(super.checkPreconditions(pm));
        return result;
    }

    public void setNewName(String newName) {
        Assert.isNotNull(newName);
        this.fNewName = newName;
        if (this.fWillRenameType) {
            this.fRenameTypeRefactoring.setNewName(newName);
        }
    }

    public String getNewName() {
        return this.fNewName;
    }

    public RefactoringStatus checkNewName(String newName) throws JavaModelException {
        Assert.isNotNull(newName, "new name");
        RefactoringStatus result = Checks.checkCompilationUnitName(String.valueOf(newName) + JAVA_CU_SUFFIX);
        if (this.fWillRenameType) {
            result.merge(this.fRenameTypeRefactoring.checkNewName(newName));
        }
        if (Checks.isAlreadyNamed((IJavaElement)this.fCu, String.valueOf(newName) + JAVA_CU_SUFFIX)) {
            result.addFatalError(RefactoringCoreMessages.getString("RenameCompilationUnitRefactoring.same_name"));
        }
        return result;
    }

    public String getCurrentName() {
        return this.getSimpleCUName();
    }

    public String getName() {
        return RefactoringCoreMessages.getFormattedString("RenameCompilationUnitRefactoring.name", new String[]{this.fCu.getElementName(), this.getNewCuName()});
    }

    public boolean canEnableTextUpdating() {
        if (this.fRenameTypeRefactoring == null) {
            return false;
        }
        return this.fRenameTypeRefactoring.canEnableUpdateReferences();
    }

    public boolean getUpdateJavaDoc() {
        if (this.fRenameTypeRefactoring == null) {
            return false;
        }
        return this.fRenameTypeRefactoring.getUpdateJavaDoc();
    }

    public boolean getUpdateComments() {
        if (this.fRenameTypeRefactoring == null) {
            return false;
        }
        return this.fRenameTypeRefactoring.getUpdateComments();
    }

    public boolean getUpdateStrings() {
        if (this.fRenameTypeRefactoring == null) {
            return false;
        }
        return this.fRenameTypeRefactoring.getUpdateStrings();
    }

    public void setUpdateJavaDoc(boolean update) {
        if (this.fRenameTypeRefactoring != null) {
            this.fRenameTypeRefactoring.setUpdateJavaDoc(update);
        }
    }

    public void setUpdateComments(boolean update) {
        if (this.fRenameTypeRefactoring != null) {
            this.fRenameTypeRefactoring.setUpdateComments(update);
        }
    }

    public void setUpdateStrings(boolean update) {
        if (this.fRenameTypeRefactoring != null) {
            this.fRenameTypeRefactoring.setUpdateStrings(update);
        }
    }

    public boolean canEnableUpdateReferences() {
        if (this.fRenameTypeRefactoring == null) {
            return false;
        }
        return this.fRenameTypeRefactoring.canEnableUpdateReferences();
    }

    public void setUpdateReferences(boolean update) {
        if (this.fRenameTypeRefactoring != null) {
            this.fRenameTypeRefactoring.setUpdateReferences(update);
        }
    }

    public boolean getUpdateReferences() {
        if (this.fRenameTypeRefactoring == null) {
            return false;
        }
        return this.fRenameTypeRefactoring.getUpdateReferences();
    }

    public boolean canEnableQualifiedNameUpdating() {
        if (this.fRenameTypeRefactoring == null) {
            return false;
        }
        return this.fRenameTypeRefactoring.canEnableQualifiedNameUpdating();
    }

    public boolean getUpdateQualifiedNames() {
        if (this.fRenameTypeRefactoring == null) {
            return false;
        }
        return this.fRenameTypeRefactoring.getUpdateQualifiedNames();
    }

    public void setUpdateQualifiedNames(boolean update) {
        if (this.fRenameTypeRefactoring == null) {
            return;
        }
        this.fRenameTypeRefactoring.setUpdateQualifiedNames(update);
    }

    public String getFilePatterns() {
        if (this.fRenameTypeRefactoring == null) {
            return null;
        }
        return this.fRenameTypeRefactoring.getFilePatterns();
    }

    public void setFilePatterns(String patterns) {
        if (this.fRenameTypeRefactoring == null) {
            return;
        }
        this.fRenameTypeRefactoring.setFilePatterns(patterns);
    }

    public RefactoringStatus checkPreactivation() throws JavaModelException {
        try {
            ICompilationUnit cu = this.fCu;
            if (cu.isReadOnly()) {
                return RefactoringStatus.createFatalErrorStatus("");
            }
            if (this.cancelTypeRenameDueToParseErrors()) {
                this.fWillRenameType = false;
            }
            if (this.fWillRenameType) {
                return this.fRenameTypeRefactoring.checkPreactivation();
            }
            return new RefactoringStatus();
        }
        catch (JavaModelException e) {
            if (e.isDoesNotExist()) {
                return RefactoringStatus.createFatalErrorStatus("");
            }
            throw e;
        }
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        if (this.cancelTypeRenameDueToParseErrors()) {
            Assert.isTrue(!this.fWillRenameType);
            return RefactoringStatus.createErrorStatus(RefactoringCoreMessages.getFormattedString("RenameCompilationUnitRefactoring.not_parsed", this.fCu.getElementName()));
        }
        if (this.fWillRenameType && this.fRenameTypeRefactoring != null && !this.fRenameTypeRefactoring.getType().exists()) {
            this.fWillRenameType = false;
            return new RefactoringStatus();
        }
        return new RefactoringStatus();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block7: {
            RefactoringStatus refactoringStatus2;
            block6: {
                try {
                    if (this.fWillRenameType && !this.fCu.isStructureKnown()) {
                        RefactoringStatus result1 = new RefactoringStatus();
                        RefactoringStatus result2 = new RefactoringStatus();
                        result2.merge(Checks.checkCompilationUnitNewName(this.fCu, this.fNewName));
                        if (result2.hasFatalError()) {
                            result1.addError(RefactoringCoreMessages.getFormattedString("RenameCompilationUnitRefactoring.not_parsed_1", this.fCu.getElementName()));
                        } else {
                            result1.addError(RefactoringCoreMessages.getFormattedString("RenameCompilationUnitRefactoring.not_parsed", this.fCu.getElementName()));
                        }
                        result1.merge(result2);
                    }
                    if (this.fWillRenameType) {
                        refactoringStatus2 = this.fRenameTypeRefactoring.checkInput(pm);
                        Object var4_6 = null;
                        break block6;
                    }
                    refactoringStatus = Checks.checkCompilationUnitNewName(this.fCu, this.fNewName);
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var4_8 = null;
                    pm.done();
                    throw throwable;
                }
            }
            pm.done();
            return refactoringStatus2;
        }
        Object var4_7 = null;
        pm.done();
        return refactoringStatus;
    }

    private void computeRenameTypeRefactoring() {
        if (this.getSimpleCUName().indexOf(".") != -1) {
            this.fRenameTypeRefactoring = null;
            this.fWillRenameType = false;
            return;
        }
        IType type = this.getTypeWithTheSameName();
        this.fRenameTypeRefactoring = type != null ? new RenameTypeRefactoring(type) : null;
        this.fWillRenameType = this.fRenameTypeRefactoring != null;
    }

    private IType getTypeWithTheSameName() {
        try {
            IType[] topLevelTypes = this.fCu.getTypes();
            String name = this.getSimpleCUName();
            int i = 0;
            while (i < topLevelTypes.length) {
                if (name.equals(topLevelTypes[i].getElementName())) {
                    return topLevelTypes[i];
                }
                ++i;
            }
            return null;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    private boolean cancelTypeRenameDueToParseErrors() throws JavaModelException {
        return this.fRenameTypeRefactoring != null && !this.fCu.isStructureKnown();
    }

    private String getSimpleCUName() {
        return RenameCompilationUnitRefactoring.removeFileNameExtension(this.fCu.getElementName());
    }

    private static String removeFileNameExtension(String fileName) {
        if (fileName.lastIndexOf(".") == -1) {
            return fileName;
        }
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        if (this.fWillRenameType) {
            return this.fRenameTypeRefactoring.createChange(pm);
        }
        IResource resource = ResourceUtil.getResource(this.fCu);
        if (resource != null && resource.isLinked()) {
            return new RenameResourceChange(resource, this.getNewCuName());
        }
        return new RenameCompilationUnitChange(this.fCu, this.getNewCuName());
    }

    private String getNewCuName() {
        return String.valueOf(this.fNewName) + JAVA_CU_SUFFIX;
    }
}

