/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.corext.Assert;

public class RefactoringScanner {
    private boolean fAnalyzeJavaDoc;
    private boolean fAnalyzeComments;
    private boolean fAnalyzeStrings;
    private String fPattern;
    private Set fJavaDocResults;
    private Set fCommentResults;
    private Set fStringResults;

    public RefactoringScanner() {
        this(true, true, true);
    }

    public RefactoringScanner(boolean analyzeJavaDoc, boolean analyzeComments, boolean analyzeStrings) {
        this.fAnalyzeComments = analyzeComments;
        this.fAnalyzeJavaDoc = analyzeJavaDoc;
        this.fAnalyzeStrings = analyzeStrings;
    }

    public void scan(ICompilationUnit cu) throws JavaModelException {
        try {
            this.scan(cu.getBuffer().getCharacters());
        }
        catch (InvalidInputException invalidInputException) {}
    }

    public void scan(String text) throws JavaModelException {
        try {
            this.scan(text.toCharArray());
        }
        catch (InvalidInputException invalidInputException) {}
    }

    private void scan(char[] content) throws JavaModelException, InvalidInputException {
        this.fJavaDocResults = new HashSet();
        this.fCommentResults = new HashSet();
        this.fStringResults = new HashSet();
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        scanner.setSource(content);
        int token = scanner.getNextToken();
        while (token != 158) {
            switch (token) {
                case 45: {
                    if (!this.fAnalyzeStrings) break;
                    this.parseCurrentToken(this.fStringResults, scanner);
                    break;
                }
                case 1003: {
                    if (!this.fAnalyzeJavaDoc) break;
                    this.parseCurrentToken(this.fJavaDocResults, scanner);
                    break;
                }
                case 1001: {
                    if (!this.fAnalyzeComments) break;
                    this.parseCurrentToken(this.fCommentResults, scanner);
                    break;
                }
                case 1002: {
                    if (!this.fAnalyzeComments) break;
                    this.parseCurrentToken(this.fCommentResults, scanner);
                }
            }
            token = scanner.getNextToken();
        }
    }

    private static boolean isWholeWord(String value, int from, int to) {
        char ch;
        if (from > 0 && (Character.isLetterOrDigit(ch = value.charAt(from - 1)) || ch == '_')) {
            return false;
        }
        return to >= value.length() || !Character.isLetterOrDigit(ch = value.charAt(to)) && ch != '_';
    }

    private void parseCurrentToken(Set result, IScanner scanner) throws InvalidInputException {
        String value = new String(scanner.getRawTokenSource());
        int start = scanner.getCurrentTokenStartPosition();
        int index = value.indexOf(this.fPattern);
        while (index != -1) {
            if (RefactoringScanner.isWholeWord(value, index, index + this.fPattern.length())) {
                result.add(new Integer(start + index));
            }
            index = value.indexOf(this.fPattern, index + 1);
        }
    }

    public boolean getAnalyzeJavaDoc() {
        return this.fAnalyzeJavaDoc;
    }

    public void setAnalyzeJavaDoc(boolean analyzeJavaDoc) {
        this.fAnalyzeJavaDoc = analyzeJavaDoc;
    }

    public boolean getAnalyzeComments() {
        return this.fAnalyzeComments;
    }

    public void setAnalyzeComments(boolean analyzeComments) {
        this.fAnalyzeComments = analyzeComments;
    }

    public boolean getAnalyzeStrings() {
        return this.fAnalyzeStrings;
    }

    public void setAnalyzeStrings(boolean analyzeStrings) {
        this.fAnalyzeStrings = analyzeStrings;
    }

    public String getPattern() {
        return this.fPattern;
    }

    public void setPattern(String pattern) {
        Assert.isNotNull(pattern);
        this.fPattern = pattern;
    }

    public Set getJavaDocResults() {
        return this.fJavaDocResults;
    }

    public Set getCommentResults() {
        return this.fCommentResults;
    }

    public Set getStringResults() {
        return this.fStringResults;
    }
}

