/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.Context;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaSourceContext;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;

public class MethodChecks {
    private MethodChecks() {
    }

    public static boolean isVirtual(IMethod method) throws JavaModelException {
        if (method.isConstructor()) {
            return false;
        }
        if (method.getDeclaringType().isInterface()) {
            return false;
        }
        if (JdtFlags.isPrivate((IMember)method)) {
            return false;
        }
        return !JdtFlags.isStatic((IMember)method);
    }

    public static RefactoringStatus checkIfOverridesAnother(IMethod method, IProgressMonitor pm) throws JavaModelException {
        IMethod overrides = MethodChecks.overridesAnotherMethod(method, pm);
        if (overrides == null) {
            return null;
        }
        Context context = JavaSourceContext.create((IMember)overrides);
        String message = RefactoringCoreMessages.getFormattedString("MethodChecks.overrides", new String[]{JavaElementUtil.createMethodSignature(overrides), JavaModelUtil.getFullyQualifiedName(overrides.getDeclaringType())});
        return RefactoringStatus.createStatus(4, message, context, overrides, 1);
    }

    public static RefactoringStatus checkIfComesFromInterface(IMethod method, IProgressMonitor pm) throws JavaModelException {
        IMethod inInterface = MethodChecks.isDeclaredInInterface(method, pm);
        if (inInterface == null) {
            return null;
        }
        Context context = JavaSourceContext.create((IMember)inInterface);
        String message = RefactoringCoreMessages.getFormattedString("MethodChecks.implements", new String[]{JavaElementUtil.createMethodSignature(inInterface), JavaModelUtil.getFullyQualifiedName(inInterface.getDeclaringType())});
        return RefactoringStatus.createStatus(4, message, context, inInterface, 2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IMethod isDeclaredInInterface(IMethod method, IProgressMonitor pm) throws JavaModelException {
        block7: {
            IMethod iMethod;
            block8: {
                Assert.isTrue(MethodChecks.isVirtual(method));
                try {
                    pm.beginTask("", 4);
                    ITypeHierarchy hier = method.getDeclaringType().newTypeHierarchy((IProgressMonitor)new SubProgressMonitor(pm, 1));
                    IType[] classes = hier.getAllClasses();
                    SubProgressMonitor subPm = new SubProgressMonitor(pm, 3);
                    subPm.beginTask("", classes.length);
                    int i = 0;
                    block2: while (true) {
                        if (i >= classes.length) {
                            break block7;
                        }
                        ITypeHierarchy superTypes = classes[i].newSupertypeHierarchy((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subPm, 1));
                        IType[] superinterfaces = superTypes.getAllSuperInterfaces(classes[i]);
                        int j = 0;
                        while (true) {
                            if (j >= superinterfaces.length) {
                                subPm.worked(1);
                                ++i;
                                continue block2;
                            }
                            IMethod found = Checks.findMethod(method, superinterfaces[j]);
                            if (found != null) {
                                iMethod = found;
                                Object var10_11 = null;
                                break block8;
                            }
                            ++j;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    pm.done();
                    throw throwable;
                }
            }
            pm.done();
            return iMethod;
        }
        Object var10_12 = null;
        pm.done();
        return null;
    }

    public static IMethod overridesAnotherMethod(IMethod method, IProgressMonitor pm) throws JavaModelException {
        boolean overrides;
        IMethod found = JavaModelUtil.findMethodDeclarationInHierarchy(method.getDeclaringType().newSupertypeHierarchy(pm), method.getDeclaringType(), method.getElementName(), method.getParameterTypes(), method.isConstructor());
        boolean bl = overrides = found != null && !JdtFlags.isStatic((IMember)found) && !JdtFlags.isPrivate((IMember)found);
        if (overrides) {
            return found;
        }
        return null;
    }
}

