/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSScanner;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRegion;

public class NLSUtil {
    private NLSUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readString(InputStream is) {
        BufferedReader reader;
        block12: {
            String string;
            if (is == null) {
                return null;
            }
            reader = null;
            try {
                try {
                    StringBuffer buffer = new StringBuffer();
                    char[] part = new char[2048];
                    int read = 0;
                    reader = new BufferedReader(new InputStreamReader(is, "8859_1"));
                    while (true) {
                        if ((read = reader.read(part)) == -1) {
                            string = buffer.toString();
                            Object var5_6 = null;
                            if (reader == null) return string;
                            break;
                        }
                        buffer.append(part, 0, read);
                    }
                }
                catch (IOException iOException) {
                    break block12;
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            reader.close();
            return string;
        }
        Object var5_8 = null;
        if (reader == null) return null;
        try {}
        catch (IOException iOException) {
            return null;
        }
        reader.close();
        return null;
    }

    public static TextEdit createNLSEdit(ICompilationUnit cu, int position) throws JavaModelException {
        NLSLine nlsLine = NLSUtil.scanCurrentLine(cu, position);
        if (nlsLine == null) {
            return null;
        }
        NLSElement element = NLSUtil.findElement(nlsLine, position);
        if (element.hasTag()) {
            return null;
        }
        NLSElement[] elements = nlsLine.getElements();
        int indexInElementList = Arrays.asList(elements).indexOf(element);
        int editOffset = NLSUtil.computeInsertOffset(elements, indexInElementList, cu);
        String editText = " " + NLSElement.createTagText(indexInElementList + 1);
        return SimpleTextEdit.createInsert(editOffset, editText);
    }

    private static NLSLine scanCurrentLine(ICompilationUnit cu, int position) throws JavaModelException {
        try {
            Assert.isTrue(position >= 0 && position <= cu.getSourceRange().getLength());
            NLSLine[] allLines = NLSScanner.scan(cu);
            int i = 0;
            while (i < allLines.length) {
                NLSLine line = allLines[i];
                if (NLSUtil.findElement(line, position) != null) {
                    return line;
                }
                ++i;
            }
            return null;
        }
        catch (InvalidInputException invalidInputException) {
            return null;
        }
    }

    private static boolean isPositionInElement(NLSElement element, int position) {
        TextRegion elementPosition = element.getPosition();
        return elementPosition.getOffset() <= position && position <= elementPosition.getOffset() + elementPosition.getLength();
    }

    private static NLSElement findElement(NLSLine line, int position) {
        NLSElement[] elements = line.getElements();
        int i = 0;
        while (i < elements.length) {
            NLSElement element = elements[i];
            if (NLSUtil.isPositionInElement(element, position)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    private static int computeInsertOffset(NLSElement[] elements, int index, ICompilationUnit cu) throws JavaModelException {
        NLSElement previousTagged = NLSUtil.findPreviousTagged(index, elements);
        if (previousTagged != null) {
            return previousTagged.getTagPosition().getOffset() + previousTagged.getTagPosition().getLength();
        }
        NLSElement nextTagged = NLSUtil.findNextTagged(index, elements);
        if (nextTagged != null) {
            return nextTagged.getTagPosition().getOffset();
        }
        return NLSUtil.findLineEnd(cu, elements[index].getPosition().getOffset());
    }

    private static NLSElement findPreviousTagged(int startIndex, NLSElement[] elements) {
        int i = startIndex - 1;
        while (i >= 0) {
            if (elements[i].hasTag()) {
                return elements[i];
            }
            --i;
        }
        return null;
    }

    private static NLSElement findNextTagged(int startIndex, NLSElement[] elements) {
        int i = startIndex + 1;
        while (i < elements.length) {
            if (elements[i].hasTag()) {
                return elements[i];
            }
            ++i;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int findLineEnd(ICompilationUnit cu, int position) throws JavaModelException {
        int n;
        TextBuffer buffer = null;
        try {
            buffer = TextBuffer.create(cu.getBuffer().getContents());
            TextRegion lineInfo = buffer.getLineInformationOfOffset(position);
            n = lineInfo.getOffset() + lineInfo.getLength();
            Object var4_5 = null;
            if (buffer == null) return n;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (buffer == null) throw throwable;
            TextBuffer.release(buffer);
            throw throwable;
        }
        TextBuffer.release(buffer);
        return n;
    }
}

