/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import java.util.ArrayList;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSLine;

public class NLSScanner {
    private NLSScanner() {
    }

    public static NLSLine[] scan(ICompilationUnit cu) throws JavaModelException, InvalidInputException {
        return NLSScanner.scan(cu.getBuffer().getCharacters());
    }

    public static NLSLine[] scan(String s) throws JavaModelException, InvalidInputException {
        return NLSScanner.scan(s.toCharArray());
    }

    private static NLSLine[] scan(char[] content) throws JavaModelException, InvalidInputException {
        ArrayList<NLSLine> lines = new ArrayList<NLSLine>();
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        scanner.setSource(content);
        int token = scanner.getNextToken();
        int currentLineNr = -1;
        int previousLineNr = -1;
        NLSLine currentLine = null;
        while (token != 158) {
            switch (token) {
                case 45: {
                    currentLineNr = scanner.getLineNumber(scanner.getCurrentTokenStartPosition());
                    if (currentLineNr != previousLineNr) {
                        currentLine = new NLSLine(currentLineNr);
                        lines.add(currentLine);
                        previousLineNr = currentLineNr;
                    }
                    String value = new String(scanner.getCurrentTokenSource());
                    currentLine.add(new NLSElement(value, scanner.getCurrentTokenStartPosition(), scanner.getCurrentTokenEndPosition() + 1 - scanner.getCurrentTokenStartPosition()));
                    break;
                }
                case 1001: {
                    if (currentLineNr != scanner.getLineNumber(scanner.getCurrentTokenStartPosition())) break;
                    NLSScanner.parseTags(currentLine, scanner);
                }
            }
            token = scanner.getNextToken();
        }
        return lines.toArray(new NLSLine[lines.size()]);
    }

    private static void parseTags(NLSLine line, IScanner scanner) throws InvalidInputException {
        String s = new String(scanner.getCurrentTokenSource());
        int pos = s.indexOf("//$NON-NLS-");
        while (pos != -1) {
            int start = pos + NLSElement.TAG_PREFIX_LENGTH;
            int end = s.indexOf("$", start);
            if (end < 0) {
                return;
            }
            String index = s.substring(start, end);
            int i = 0;
            try {
                i = Integer.parseInt(index) - 1;
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            if (!line.exists(i)) {
                return;
            }
            NLSElement element = line.get(i);
            element.setTagPosition(scanner.getCurrentTokenStartPosition() + pos, end - pos + 1);
            pos = s.indexOf("//$NON-NLS-", start);
        }
    }
}

