/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jface.util.Assert;

public class NLSLine {
    private int fLineNumber;
    private List fElements;

    public NLSLine(int lineNumber) {
        this.fLineNumber = lineNumber;
        Assert.isTrue((this.fLineNumber >= 0 ? 1 : 0) != 0);
        this.fElements = new ArrayList();
    }

    public void add(NLSElement element) {
        Assert.isNotNull((Object)element);
        this.fElements.add(element);
    }

    public NLSElement[] getElements() {
        return this.fElements.toArray(new NLSElement[this.fElements.size()]);
    }

    public NLSElement get(int index) {
        return (NLSElement)this.fElements.get(index);
    }

    public boolean exists(int index) {
        return index >= 0 && index < this.fElements.size();
    }

    public int size() {
        return this.fElements.size();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Line: " + this.fLineNumber + "\n");
        Iterator iter = this.fElements.iterator();
        while (iter.hasNext()) {
            result.append("\t");
            result.append(iter.next().toString());
            result.append("\n");
        }
        return result.toString();
    }
}

