/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import java.util.ArrayList;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSScanner;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSSubstitution;

public class NLSHolder {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char SUBSTITUTE_CHAR = '_';
    private static final char[] UNWANTED_CHARS = new char[]{' ', ':', '\"', '\\', '\'', '?', '='};
    public static final String[] UNWANTED_STRINGS = new String[]{" ", ":", "\"", "\\", "'", "?", "="};
    private NLSSubstitution[] fSubstitutions;
    private NLSLine[] fLines;
    private ICompilationUnit fCu;

    private NLSHolder(NLSSubstitution[] substitutions, NLSLine[] lines, ICompilationUnit cu) {
        this.fSubstitutions = substitutions;
        this.fLines = lines;
        this.fCu = cu;
    }

    public static NLSHolder create(ICompilationUnit cu) {
        NLSLine[] nlsLines = NLSHolder.createRawLines(cu);
        NLSSubstitution[] subs = NLSHolder.processLines(nlsLines);
        return new NLSHolder(subs, nlsLines, cu);
    }

    public NLSSubstitution[] getSubstitutions() {
        return this.fSubstitutions;
    }

    public NLSLine[] getLines() {
        return this.fLines;
    }

    public ICompilationUnit getCu() {
        return this.fCu;
    }

    private static NLSLine[] createRawLines(ICompilationUnit cu) {
        try {
            return NLSScanner.scan(cu);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        catch (InvalidInputException invalidInputException) {
            return null;
        }
    }

    private static NLSSubstitution[] processLines(NLSLine[] lines) {
        if (lines == null) {
            return new NLSSubstitution[0];
        }
        ArrayList<NLSSubstitution> result = new ArrayList<NLSSubstitution>();
        int counter = 1;
        int i = 0;
        while (i < lines.length) {
            NLSElement[] elements = lines[i].getElements();
            int j = 0;
            while (j < elements.length) {
                NLSElement element = elements[j];
                if (!element.hasTag()) {
                    element.setValue(NLSHolder.createModifiedValue(element.getValue()));
                    result.add(new NLSSubstitution(NLSHolder.createKey(element, counter++), element, 0));
                }
                ++j;
            }
            ++i;
        }
        return result.toArray(new NLSSubstitution[result.size()]);
    }

    private static String createModifiedValue(String rawValue) {
        String modifiedValue = NLSRefactoring.removeQuotes(rawValue);
        modifiedValue = NLSHolder.unwindEscapeChars(modifiedValue);
        return "\"" + modifiedValue + "\"";
    }

    private static String unwindEscapeChars(String s) {
        StringBuffer sb = new StringBuffer(s.length());
        int last = s.length() - 1;
        int length = s.length();
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            if (c == '\"' && (i == 0 || i == last)) {
                sb.append(c);
            } else {
                sb.append(NLSHolder.getUnwoundString(c));
            }
            ++i;
        }
        return sb.toString();
    }

    private static String getUnwoundString(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\"': {
                return "\\\"";
            }
            case '\'': {
                return "\\'";
            }
            case '\\': {
                return "\\\\";
            }
            case '!': {
                return "\\!";
            }
            case '#': {
                return "\\#";
            }
        }
        if (c < ' ' || c > '~') {
            return "" + '\\' + 'u' + NLSHolder.toHex(c >> 12 & 0xF) + NLSHolder.toHex(c >> 8 & 0xF) + NLSHolder.toHex(c >> 4 & 0xF) + NLSHolder.toHex(c & 0xF);
        }
        return String.valueOf(c);
    }

    private static char toHex(int halfByte) {
        return HEX_DIGITS[halfByte & 0xF];
    }

    private static String createKey(NLSElement element, int counter) {
        String result = NLSRefactoring.removeQuotes(element.getValue());
        int i = 0;
        while (i < UNWANTED_CHARS.length) {
            result = result.replace(UNWANTED_CHARS[i], '_');
            ++i;
        }
        return String.valueOf(result) + '_' + counter;
    }
}

