/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import org.eclipse.jdt.internal.corext.textmanipulation.TextRegion;
import org.eclipse.jface.util.Assert;

public class NLSElement {
    public static final String TAG_PREFIX = "//$NON-NLS-";
    public static final int TAG_PREFIX_LENGTH = "//$NON-NLS-".length();
    public static final String TAG_POSTFIX = "$";
    public static final int TAG_POSTFIX_LENGTH = "$".length();
    private String fValue;
    private TextRegion fPosition;
    private TextRegion fTagPosition;

    public NLSElement(String value, int start, int length) {
        this.fValue = value;
        Assert.isNotNull((Object)this.fValue);
        this.fPosition = new NLSTextRegion(start, length);
    }

    public TextRegion getPosition() {
        return this.fPosition;
    }

    public String getValue() {
        return this.fValue;
    }

    public void setValue(String value) {
        this.fValue = value;
    }

    public void setTagPosition(int start, int length) {
        this.fTagPosition = new NLSTextRegion(start, length);
    }

    public TextRegion getTagPosition() {
        return this.fTagPosition;
    }

    public boolean hasTag() {
        return this.fTagPosition != null;
    }

    public static String createTagText(int index) {
        return TAG_PREFIX + index + TAG_POSTFIX;
    }

    public String toString() {
        return this.fPosition + ": " + this.fValue + "    Tag position: " + (this.hasTag() ? this.fTagPosition.toString() : "no tag found");
    }

    private static class NLSTextRegion
    extends TextRegion {
        int fStart;
        int fLength;

        public NLSTextRegion(int start, int length) {
            this.fStart = start;
            Assert.isTrue((this.fStart >= 0 ? 1 : 0) != 0);
            this.fLength = length;
            Assert.isTrue((this.fLength >= 0 ? 1 : 0) != 0);
        }

        public int getOffset() {
            return this.fStart;
        }

        public int getLength() {
            return this.fLength;
        }

        public String toString() {
            return "(" + this.fStart + "," + this.fLength + ")";
        }
    }
}

