/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportEdit;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.CodeScopeBuilder;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.code.CallContext;
import org.eclipse.jdt.internal.corext.refactoring.code.ParameterData;
import org.eclipse.jdt.internal.corext.refactoring.code.SourceAnalyzer;
import org.eclipse.jdt.internal.corext.textmanipulation.MultiTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.RangeMarker;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBufferEditor;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRange;
import org.eclipse.jdt.internal.corext.textmanipulation.UndoMemento;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Strings;

public class SourceProvider {
    private ICompilationUnit fCUnit;
    private TextBuffer fBuffer;
    private MethodDeclaration fDeclaration;
    private ASTRewrite fRewriter;
    private SourceAnalyzer fAnalyzer;
    private boolean fEvaluateReturnValue;

    public SourceProvider(ICompilationUnit unit, MethodDeclaration declaration) {
        this.fCUnit = unit;
        this.fDeclaration = declaration;
        List parameters = this.fDeclaration.parameters();
        Iterator iter = parameters.iterator();
        while (iter.hasNext()) {
            SingleVariableDeclaration element = (SingleVariableDeclaration)iter.next();
            ParameterData data = new ParameterData(element);
            element.setProperty(ParameterData.PROPERTY, (Object)data);
        }
        this.fRewriter = new ASTRewrite((ASTNode)this.fDeclaration);
        this.fAnalyzer = new SourceAnalyzer(this.fCUnit, this.fDeclaration);
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        return this.fAnalyzer.checkActivation();
    }

    public void initialize() throws JavaModelException {
        ASTNode last;
        this.fBuffer = TextBuffer.create(this.fCUnit.getBuffer().getContents());
        this.fAnalyzer.analyzeParameters();
        if (this.hasReturnValue() && (last = this.getLastStatement()) != null) {
            ReturnAnalyzer analyzer = new ReturnAnalyzer();
            last.accept((ASTVisitor)analyzer);
            this.fEvaluateReturnValue = analyzer.evalReturnValue;
        }
    }

    public boolean isExecutionFlowInterrupted() {
        return this.fAnalyzer.isExecutionFlowInterrupted();
    }

    public boolean hasReturnValue() {
        IMethodBinding binding = this.fDeclaration.resolveBinding();
        return binding.getReturnType() != this.fDeclaration.getAST().resolveWellKnownType("void");
    }

    public boolean mustEvaluateReturnValue() {
        return this.fEvaluateReturnValue;
    }

    public int getNumberOfStatements() {
        return this.fDeclaration.getBody().statements().size();
    }

    public boolean isSimpleFunction() {
        List statements = this.fDeclaration.getBody().statements();
        if (statements.size() != 1) {
            return false;
        }
        return statements.get(0) instanceof ReturnStatement;
    }

    public MethodDeclaration getDeclaration() {
        return this.fDeclaration;
    }

    public String getMethodName() {
        return this.fDeclaration.getName().getIdentifier();
    }

    public ITypeBinding getReturnType() {
        return this.fDeclaration.resolveBinding().getReturnType();
    }

    public ParameterData getParameterData(int index) {
        SingleVariableDeclaration decl = (SingleVariableDeclaration)this.fDeclaration.parameters().get(index);
        return (ParameterData)decl.getProperty(ParameterData.PROPERTY);
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCUnit;
    }

    public boolean needsReturnedExpressionParenthesis() {
        ASTNode last = this.getLastStatement();
        if (last instanceof ReturnStatement) {
            return ASTNodes.needsParentheses(((ReturnStatement)last).getExpression());
        }
        return false;
    }

    public int getReceiversToBeUpdated() {
        return this.fAnalyzer.getImplicitReceivers().size();
    }

    public TextEdit getDeleteEdit() {
        ASTRewrite rewriter = new ASTRewrite(this.fDeclaration.getParent());
        rewriter.markAsRemoved((ASTNode)this.fDeclaration);
        MultiTextEdit result = new MultiTextEdit();
        rewriter.rewriteNode(this.fBuffer, result, null);
        rewriter.removeModifications();
        return result;
    }

    public String[] getCodeBlocks(CallContext context) throws CoreException {
        ASTNode last;
        this.replaceParameterWithExpression(context.arguments);
        this.updateImplicitReceivers(context);
        this.makeNamesUnique(context.scope);
        this.updateTypes(context);
        List ranges = null;
        ranges = this.hasReturnValue() ? (context.callMode == 41 ? this.getStatementRanges() : this.getExpressionRanges()) : ((last = this.getLastStatement()) != null && last.getNodeType() == 41 ? this.getReturnStatementRanges() : this.getStatementRanges());
        MultiTextEdit dummy = new MultiTextEdit();
        this.fRewriter.rewriteNode(this.fBuffer, dummy, null);
        int size = ranges.size();
        TextEdit[] markers = new RangeMarker[size];
        int i = 0;
        while (i < markers.length) {
            markers[i] = new RangeMarker((TextRange)ranges.get(i));
            ++i;
        }
        int split = size <= 1 ? Integer.MAX_VALUE : ((TextRange)ranges.get(0)).getExclusiveEnd();
        TextEdit[] edits = dummy.removeAll();
        int i2 = 0;
        while (i2 < edits.length) {
            TextEdit edit = edits[i2];
            int pos = edit.getTextRange().getOffset() >= split ? 1 : 0;
            markers[pos].add(edit);
            ++i2;
        }
        MultiTextEdit root = new MultiTextEdit();
        root.addAll(markers);
        TextBufferEditor editor = new TextBufferEditor(this.fBuffer);
        editor.add(root);
        UndoMemento undo = editor.performEdits(null);
        String[] result = this.getBlocks(ranges);
        TextBufferEditor undoEditor = new TextBufferEditor(this.fBuffer);
        undoEditor.add(undo);
        undoEditor.performEdits(null);
        this.fRewriter.removeModifications();
        return result;
    }

    private void replaceParameterWithExpression(String[] expressions) {
        int i = 0;
        while (i < expressions.length) {
            String expression = expressions[i];
            ParameterData parameter = this.getParameterData(i);
            List references = parameter.references();
            Iterator iter = references.iterator();
            while (iter.hasNext()) {
                ASTNode element = (ASTNode)iter.next();
                ASTNode newNode = this.fRewriter.createPlaceholder(expression, ASTRewrite.getPlaceholderType(element));
                this.fRewriter.markAsReplaced(element, newNode);
            }
            ++i;
        }
    }

    private void makeNamesUnique(CodeScopeBuilder.Scope scope) {
        Collection usedCalleeNames = this.fAnalyzer.getUsedNames();
        Iterator iter = usedCalleeNames.iterator();
        while (iter.hasNext()) {
            SourceAnalyzer.NameData nd = (SourceAnalyzer.NameData)iter.next();
            if (!scope.isInUse(nd.getName())) continue;
            String newName = scope.createName(nd.getName(), true);
            List references = nd.references();
            Iterator refs = references.iterator();
            while (refs.hasNext()) {
                SimpleName element = (SimpleName)refs.next();
                ASTNode newNode = this.fRewriter.createPlaceholder(newName, 3);
                this.fRewriter.markAsReplaced((ASTNode)element, newNode);
            }
        }
    }

    private void updateImplicitReceivers(CallContext context) {
        if (context.receiver == null) {
            return;
        }
        List implicitReceivers = this.fAnalyzer.getImplicitReceivers();
        Iterator iter = implicitReceivers.iterator();
        while (iter.hasNext()) {
            ASTNode node = (ASTNode)iter.next();
            if (node instanceof MethodInvocation) {
                MethodInvocation inv = (MethodInvocation)node;
                inv.setExpression(this.createReceiver(context, (IMethodBinding)inv.getName().resolveBinding()));
                continue;
            }
            if (node instanceof ClassInstanceCreation) {
                ClassInstanceCreation inst = (ClassInstanceCreation)node;
                inst.setExpression(this.createReceiver(context, inst.resolveConstructorBinding()));
                continue;
            }
            if (!(node instanceof Expression)) continue;
            this.fRewriter.markAsReplaced(node, this.fRewriter.createPlaceholder(context.receiver, 3));
        }
    }

    private void updateTypes(CallContext context) {
        ImportEdit importer = context.importer;
        Iterator iter = this.fAnalyzer.getUsedTypes().iterator();
        while (iter.hasNext()) {
            Name element = (Name)iter.next();
            ITypeBinding binding = ASTNodes.getTypeBinding(element);
            if (binding == null || binding.isLocal()) continue;
            String s = importer.addImport(binding);
            if (ASTNodes.asString((ASTNode)element).equals(s)) continue;
            this.fRewriter.markAsReplaced((ASTNode)element, this.fRewriter.createPlaceholder(s, 3));
        }
    }

    private Expression createReceiver(CallContext context, IMethodBinding method) {
        String receiver = context.receiver;
        if (!context.receiverIsStatic && Modifier.isStatic((int)method.getModifiers())) {
            receiver = context.importer.addImport(Bindings.getFullyQualifiedImportName(this.fDeclaration.resolveBinding().getDeclaringClass()));
        }
        Expression exp = (Expression)this.fRewriter.createPlaceholder(receiver, 3);
        this.fRewriter.markAsInserted((ASTNode)exp);
        return exp;
    }

    private ASTNode getLastStatement() {
        List statements = this.fDeclaration.getBody().statements();
        if (statements.isEmpty()) {
            return null;
        }
        return (ASTNode)statements.get(statements.size() - 1);
    }

    private List getReturnStatementRanges() {
        ArrayList<TextRange> result = new ArrayList<TextRange>(1);
        List statements = this.fDeclaration.getBody().statements();
        int size = statements.size();
        if (size <= 1) {
            return result;
        }
        result.add(this.createRange(statements, size - 2));
        return result;
    }

    private List getStatementRanges() {
        ArrayList<TextRange> result = new ArrayList<TextRange>(1);
        List statements = this.fDeclaration.getBody().statements();
        int size = statements.size();
        if (size == 0) {
            return result;
        }
        result.add(this.createRange(statements, size - 1));
        return result;
    }

    private List getExpressionRanges() {
        ArrayList<TextRange> result = new ArrayList<TextRange>(2);
        List statements = this.fDeclaration.getBody().statements();
        ReturnStatement rs = null;
        int size = statements.size();
        switch (size) {
            case 0: {
                return result;
            }
            case 1: {
                ASTNode node = (ASTNode)statements.get(0);
                if (node.getNodeType() == 41) {
                    rs = (ReturnStatement)node;
                    break;
                }
                result.add(TextRange.createFromStartAndLength(node.getStartPosition(), node.getLength()));
                break;
            }
            default: {
                ASTNode node = (ASTNode)statements.get(size - 1);
                if (node.getNodeType() == 41) {
                    result.add(this.createRange(statements, size - 2));
                    rs = (ReturnStatement)node;
                    break;
                }
                result.add(this.createRange(statements, size - 1));
            }
        }
        if (rs != null) {
            Expression exp = rs.getExpression();
            result.add(TextRange.createFromStartAndLength(exp.getStartPosition(), exp.getLength()));
        }
        return result;
    }

    private TextRange createRange(List statements, int end) {
        int start = ((ASTNode)statements.get(0)).getStartPosition();
        ASTNode last = (ASTNode)statements.get(end);
        int length = last.getStartPosition() - start + last.getLength();
        TextRange range = TextRange.createFromStartAndLength(start, length);
        return range;
    }

    private String[] getBlocks(List ranges) {
        int size = ranges.size();
        ArrayList<String> result = new ArrayList<String>(size);
        int i = 0;
        while (i < size) {
            TextRange range = (TextRange)ranges.get(i);
            String content = this.fBuffer.getContent(range.getOffset(), range.getLength());
            String[] lines = Strings.convertIntoLines(content);
            Strings.trimIndentation(lines, CodeFormatterUtil.getTabWidth(), false);
            result.add(Strings.concatenate(lines, this.fBuffer.getLineDelimiter()));
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    private static class ReturnAnalyzer
    extends ASTVisitor {
        public boolean evalReturnValue = false;

        ReturnAnalyzer() {
        }

        public boolean visit(ReturnStatement node) {
            Expression expression = node.getExpression();
            if (!ASTNodes.isLiteral(expression) && !(expression instanceof Name)) {
                this.evalReturnValue = true;
            }
            return false;
        }
    }
}

