/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.internal.corext.Assert;

public class Invocations {
    public static List getArguments(ASTNode invocation) {
        switch (invocation.getNodeType()) {
            case 32: {
                return ((MethodInvocation)invocation).arguments();
            }
            case 48: {
                return ((SuperMethodInvocation)invocation).arguments();
            }
        }
        Assert.isTrue(false, "Should not happen.");
        return null;
    }

    public static Expression getExpression(ASTNode invocation) {
        switch (invocation.getNodeType()) {
            case 32: {
                return ((MethodInvocation)invocation).getExpression();
            }
            case 48: {
                return null;
            }
        }
        Assert.isTrue(false, "Should not happen.");
        return null;
    }

    public static boolean isInvocation(ASTNode node) {
        int type = node.getNodeType();
        return type == 32 || type == 48;
    }

    public static SimpleName getName(ASTNode invocation) {
        switch (invocation.getNodeType()) {
            case 32: {
                return ((MethodInvocation)invocation).getName();
            }
            case 48: {
                return ((SuperMethodInvocation)invocation).getName();
            }
        }
        Assert.isTrue(false, "Should not happen.");
        return null;
    }
}

