/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.Context;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaSourceContext;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatusEntry;
import org.eclipse.jdt.internal.corext.refactoring.code.SourceProvider;

class InvocationAnalyzer {
    private SourceProvider fSourceProvider;
    private ICompilationUnit fCUnit;
    private ASTNode fInvocation;
    private ASTNode fTargetNode;
    private int fSeverity;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public InvocationAnalyzer(SourceProvider sourceProvider) {
        this.fSourceProvider = sourceProvider;
    }

    public RefactoringStatus perform(ICompilationUnit unit, ASTNode invocation, ASTNode targetNode, int severity) {
        RefactoringStatus result = new RefactoringStatus();
        this.fCUnit = unit;
        this.fInvocation = invocation;
        this.fSeverity = severity;
        this.fTargetNode = targetNode;
        this.checkIfUsedInDeclaration(result);
        if (result.getSeverity() >= this.fSeverity) {
            return result;
        }
        this.checkInvocationContext(result);
        if (result.getSeverity() >= this.fSeverity) {
            return result;
        }
        return result;
    }

    private void checkInvocationContext(RefactoringStatus result) {
        ASTNode parent;
        int nodeType;
        Expression exp;
        if (this.fInvocation.getNodeType() == 32 && (exp = ((MethodInvocation)this.fInvocation).getExpression()) != null && exp.resolveTypeBinding() == null) {
            this.addEntry(result, RefactoringCoreMessages.getString("TargetProvider.receiver_type"), 258);
        }
        if ((nodeType = this.fTargetNode.getNodeType()) == 21) {
            if (this.fSourceProvider.isExecutionFlowInterrupted()) {
                InvocationAnalyzer.addEntry(result, RefactoringCoreMessages.getString("CallInliner.execution_flow"), this.fSeverity, JavaSourceContext.create(this.fSourceProvider.getCompilationUnit(), (ASTNode)this.fSourceProvider.getDeclaration()), 260);
            }
        } else if (nodeType == 32 && (parent = this.fTargetNode.getParent()).getNodeType() != 7 && !InvocationAnalyzer.isSingleDeclaration(parent)) {
            if (InvocationAnalyzer.isMultiDeclarationFragment(parent)) {
                if (!this.fSourceProvider.isSimpleFunction()) {
                    this.addEntry(result, RefactoringCoreMessages.getString("InvocationAnalyzer.multiDeclaration"), 261);
                }
            } else if (this.fSourceProvider.getNumberOfStatements() > 1) {
                this.addEntry(result, RefactoringCoreMessages.getString("CallInliner.simple_functions"), 259);
            } else if (!this.fSourceProvider.isSimpleFunction()) {
                InvocationAnalyzer.addEntry(result, RefactoringCoreMessages.getString("CallInliner.execution_flow"), this.fSeverity, JavaSourceContext.create(this.fSourceProvider.getCompilationUnit(), (ASTNode)this.fSourceProvider.getDeclaration()), 260);
            }
        }
    }

    private void checkIfUsedInDeclaration(RefactoringStatus result) {
        BodyDeclaration decl;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.BodyDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((decl = (BodyDeclaration)ASTNodes.getParent(this.fInvocation, clazz)) instanceof FieldDeclaration) {
            this.addEntry(result, RefactoringCoreMessages.getString("TargetProvider.field_initializer"), 256);
            return;
        }
        if (this.fSourceProvider.isExecutionFlowInterrupted()) {
            VariableDeclaration vDecl;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.jdt.core.dom.VariableDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((vDecl = (VariableDeclaration)ASTNodes.getParent(this.fInvocation, clazz2)) != null) {
                this.addEntry(result, RefactoringCoreMessages.getString("CallInliner.execution_flow"), 257);
            }
        }
    }

    private static boolean isMultiDeclarationFragment(ASTNode node) {
        int nodeType = node.getNodeType();
        if (nodeType == 59 && (node = node.getParent()).getNodeType() == 60) {
            VariableDeclarationStatement vs = (VariableDeclarationStatement)node;
            return vs.fragments().size() > 1;
        }
        return false;
    }

    private static boolean isSingleDeclaration(ASTNode node) {
        int type = node.getNodeType();
        if (type == 44) {
            return true;
        }
        if (type == 59 && (node = node.getParent()).getNodeType() == 60) {
            VariableDeclarationStatement vs = (VariableDeclarationStatement)node;
            return vs.fragments().size() == 1;
        }
        return false;
    }

    private void addEntry(RefactoringStatus result, String message, int code) {
        result.addEntry(new RefactoringStatusEntry(message, this.fSeverity, JavaSourceContext.create(this.fCUnit, this.fInvocation), null, code));
    }

    private static void addEntry(RefactoringStatus result, String message, int severity, Context context, int code) {
        result.addEntry(new RefactoringStatusEntry(message, severity, context, null, code));
    }
}

