/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.Context;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaSourceContext;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.jdt.internal.corext.refactoring.code.TempAssignmentFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempDeclarationFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempOccurrenceFinder;
import org.eclipse.jdt.internal.corext.refactoring.reorg.SourceRangeComputer;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;

public class InlineTempRefactoring
extends Refactoring {
    private final int fSelectionStart;
    private final int fSelectionLength;
    private final ICompilationUnit fCu;
    private VariableDeclaration fTempDeclaration;
    private CompilationUnit fCompilationUnitNode;

    public InlineTempRefactoring(ICompilationUnit cu, int selectionStart, int selectionLength) {
        Assert.isTrue(selectionStart >= 0);
        Assert.isTrue(selectionLength >= 0);
        Assert.isTrue(cu.exists());
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = cu;
    }

    public String getName() {
        return RefactoringCoreMessages.getString("InlineTempRefactoring.name");
    }

    public String getTempName() {
        return this.fTempDeclaration.getName().getIdentifier();
    }

    public int getOccurences() {
        try {
            return this.getOccurrenceOffsets().length;
        }
        catch (JavaModelException javaModelException) {
            return 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block8: {
            RefactoringStatus refactoringStatus2;
            block7: {
                RefactoringStatus refactoringStatus3;
                block6: {
                    RefactoringStatus refactoringStatus4;
                    block5: {
                        try {
                            pm.beginTask("", 1);
                            RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCu}));
                            if (result.hasFatalError()) {
                                refactoringStatus4 = result;
                                Object var3_7 = null;
                                break block5;
                            }
                            if (!this.fCu.isStructureKnown()) {
                                refactoringStatus3 = RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("InlineTempRefactoring.syntax_errors"));
                                break block6;
                            }
                            result.merge(this.checkSelection());
                            if (result.hasFatalError()) {
                                refactoringStatus2 = result;
                                break block7;
                            }
                            result.merge(this.checkInitializer());
                            refactoringStatus = result;
                            break block8;
                        }
                        catch (Throwable throwable) {
                            Object var3_11 = null;
                            pm.done();
                            throw throwable;
                        }
                    }
                    pm.done();
                    return refactoringStatus4;
                }
                Object var3_8 = null;
                pm.done();
                return refactoringStatus3;
            }
            Object var3_9 = null;
            pm.done();
            return refactoringStatus2;
        }
        Object var3_10 = null;
        pm.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkInitializer() {
        switch (this.fTempDeclaration.getInitializer().getNodeType()) {
            case 33: {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("InlineTemRefactoring.error.message.nulLiteralsCannotBeInlined"));
            }
            case 4: {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("InlineTempRefactoring.Array_vars_initialized"));
            }
        }
        return null;
    }

    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        try {
            pm.beginTask("", 1);
            refactoringStatus = new RefactoringStatus();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    private void initializeAST() {
        this.fCompilationUnitNode = AST.parseCompilationUnit((ICompilationUnit)this.fCu, (boolean)true);
    }

    public RefactoringStatus checkIfTempSelectedSelected() {
        this.initializeAST();
        this.fTempDeclaration = TempDeclarationFinder.findTempDeclaration(this.fCompilationUnitNode, this.fSelectionStart, this.fSelectionLength);
        if (this.fTempDeclaration == null) {
            String message = RefactoringCoreMessages.getString("InlineTempRefactoring.select_temp");
            return CodeRefactoringUtil.checkMethodSyntaxErrors(this.fSelectionStart, this.fSelectionLength, this.fCompilationUnitNode, message);
        }
        if (this.fTempDeclaration.getParent() instanceof FieldDeclaration) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("InlineTemRefactoring.error.message.fieldsCannotBeInlined"));
        }
        return new RefactoringStatus();
    }

    private RefactoringStatus checkSelection() throws JavaModelException {
        RefactoringStatus rs = this.checkIfTempSelectedSelected();
        if (rs != null && rs.hasFatalError()) {
            return rs;
        }
        if (this.fTempDeclaration.getParent() instanceof MethodDeclaration) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("InlineTempRefactoring.method_parameter"));
        }
        if (this.fTempDeclaration.getParent() instanceof CatchClause) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("InlineTempRefactoring.exceptions_declared"));
        }
        if (ASTNodes.getParent((ASTNode)this.fTempDeclaration, 24) != null) {
            ForStatement forStmt = (ForStatement)ASTNodes.getParent((ASTNode)this.fTempDeclaration, 24);
            Iterator iter = forStmt.initializers().iterator();
            while (iter.hasNext()) {
                if (!ASTNodes.isParent((ASTNode)this.fTempDeclaration, (ASTNode)((Expression)iter.next()))) continue;
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("InlineTempRefactoring.for_initializers"));
            }
        }
        if (this.fTempDeclaration.getInitializer() == null) {
            String message = RefactoringCoreMessages.getFormattedString("InlineTempRefactoring.not_initialized", this.getTempName());
            return RefactoringStatus.createFatalErrorStatus(message);
        }
        return this.checkAssignments();
    }

    private RefactoringStatus checkAssignments() throws JavaModelException {
        TempAssignmentFinder assignmentFinder = new TempAssignmentFinder(this.fTempDeclaration);
        this.fCompilationUnitNode.accept((ASTVisitor)assignmentFinder);
        if (!assignmentFinder.hasAssignments()) {
            return new RefactoringStatus();
        }
        int start = assignmentFinder.getFirstAssignment().getStartPosition();
        int length = assignmentFinder.getFirstAssignment().getLength();
        SourceRange range = new SourceRange(start, length);
        Context context = JavaSourceContext.create(this.fCu, range);
        String message = RefactoringCoreMessages.getFormattedString("InlineTempRefactoring.assigned_more_once", this.getTempName());
        return RefactoringStatus.createFatalErrorStatus(message, context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        CompilationUnitChange compilationUnitChange;
        try {
            try {
                pm.beginTask(RefactoringCoreMessages.getString("InlineTempRefactoring.preview"), 2);
                CompilationUnitChange change = new CompilationUnitChange(RefactoringCoreMessages.getString("InlineTempRefactoring.inline"), this.fCu);
                this.inlineTemp(change, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                this.removeTemp(change);
                compilationUnitChange = change;
                Object var3_6 = null;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return compilationUnitChange;
    }

    private void inlineTemp(TextChange change, IProgressMonitor pm) throws JavaModelException {
        Integer[] offsets = this.getOccurrenceOffsets();
        pm.beginTask("", offsets.length);
        String changeName = String.valueOf(RefactoringCoreMessages.getString("InlineTempRefactoring.inline_edit_name")) + this.getTempName();
        int length = this.getTempName().length();
        int i = 0;
        while (i < offsets.length) {
            int offset = offsets[i];
            String sourceToInline = this.getInitializerSource(this.needsBrackets(offset));
            change.addTextEdit(changeName, SimpleTextEdit.createReplace(offset, length, sourceToInline));
            pm.worked(1);
            ++i;
        }
    }

    private boolean needsBrackets(int offset) {
        Expression initializer = this.fTempDeclaration.getInitializer();
        if (initializer instanceof Assignment) {
            return true;
        }
        SimpleName inlineSite = this.getReferenceAtOffset(offset);
        if (inlineSite == null) {
            return true;
        }
        return ASTNodes.substituteMustBeParenthesized(initializer, (Expression)inlineSite);
    }

    private SimpleName getReferenceAtOffset(int offset) {
        SelectionAnalyzer analyzer = new SelectionAnalyzer(Selection.createFromStartLength(offset, this.getTempName().length()), true);
        this.fCompilationUnitNode.accept((ASTVisitor)analyzer);
        ASTNode reference = analyzer.getFirstSelectedNode();
        if (!this.isReference(reference)) {
            return null;
        }
        return (SimpleName)reference;
    }

    private boolean isReference(ASTNode node) {
        if (!(node instanceof SimpleName)) {
            return false;
        }
        return ((SimpleName)node).getIdentifier().equals(this.fTempDeclaration.getName().getIdentifier());
    }

    private void removeTemp(TextChange change) throws JavaModelException {
        if (this.fTempDeclaration.getParent() instanceof VariableDeclarationStatement) {
            VariableDeclarationStatement vds = (VariableDeclarationStatement)this.fTempDeclaration.getParent();
            if (vds.fragments().size() == 1) {
                this.removeDeclaration(change, vds.getStartPosition(), vds.getLength());
                return;
            }
            return;
        }
        this.removeDeclaration(change, this.fTempDeclaration.getStartPosition(), this.fTempDeclaration.getLength());
    }

    private void removeDeclaration(TextChange change, int offset, int length) throws JavaModelException {
        ISourceRange range = SourceRangeComputer.computeSourceRange(new SourceRange(offset, length), this.fCu.getSource());
        String changeName = String.valueOf(RefactoringCoreMessages.getString("InlineTempRefactoring.remove_edit_name")) + this.getTempName();
        change.addTextEdit(changeName, SimpleTextEdit.createDelete(range.getOffset(), range.getLength()));
    }

    private String getInitializerSource(boolean brackets) throws JavaModelException {
        if (brackets) {
            return String.valueOf('(') + this.getRawInitializerSource() + ')';
        }
        return this.getRawInitializerSource();
    }

    private String getRawInitializerSource() throws JavaModelException {
        int start = this.fTempDeclaration.getInitializer().getStartPosition();
        int length = this.fTempDeclaration.getInitializer().getLength();
        int end = start + length;
        return this.fCu.getSource().substring(start, end);
    }

    private Integer[] getOccurrenceOffsets() throws JavaModelException {
        return TempOccurrenceFinder.findTempOccurrenceOffsets(this.fTempDeclaration, true, false);
    }
}

