/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICodeFormatter;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeBlock;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeBlockEdit;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportEdit;
import org.eclipse.jdt.internal.corext.codemanipulation.MethodBlock;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SimpleNameRenamer;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.code.ExtractMethodAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.textmanipulation.RangeMarker;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBufferEditor;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRange;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRegion;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;

public class ExtractMethodRefactoring
extends Refactoring {
    private ICompilationUnit fCUnit;
    private ImportEdit fImportEdit;
    private int fSelectionStart;
    private int fSelectionLength;
    private int fSelectionEnd;
    private AST fAST;
    private ExtractMethodAnalyzer fAnalyzer;
    private String fVisibility;
    private String fMethodName;
    private boolean fThrowRuntimeExceptions;
    private List fParameterInfos;
    private Set fUsedNames;
    private static final String EMPTY = "";
    private static final String BLANK = " ";
    private static final String RETURN = "return";
    private static final String RETURN_BLANK = "return ";
    private static final String SEMICOLON = ";";
    private static final String COMMA_BLANK = ", ";
    private static final String STATIC = "static";

    public ExtractMethodRefactoring(ICompilationUnit cu, int selectionStart, int selectionLength, CodeGenerationSettings settings) throws JavaModelException {
        Assert.isNotNull(cu);
        Assert.isNotNull(settings);
        this.fCUnit = cu;
        this.fImportEdit = new ImportEdit(cu, settings);
        this.fMethodName = "extracted";
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fSelectionEnd = this.fSelectionStart + this.fSelectionLength - 1;
    }

    public String getName() {
        return RefactoringCoreMessages.getFormattedString("ExtractMethodRefactoring.name", new String[]{this.fMethodName, this.fCUnit.getElementName()});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block9: {
            RefactoringStatus refactoringStatus2;
            block8: {
                RefactoringStatus refactoringStatus3;
                block7: {
                    RefactoringStatus refactoringStatus4;
                    block6: {
                        try {
                            pm.beginTask(RefactoringCoreMessages.getString("ExtractMethodRefactoring.checking_selection"), 1);
                            RefactoringStatus result = new RefactoringStatus();
                            if (this.fSelectionStart < 0 || this.fSelectionLength == 0) {
                                refactoringStatus4 = this.mergeTextSelectionStatus(result);
                                Object var4_7 = null;
                                break block6;
                            }
                            result.merge(Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCUnit})));
                            if (result.hasFatalError()) {
                                refactoringStatus3 = result;
                                break block7;
                            }
                            CompilationUnit root = AST.parseCompilationUnit((ICompilationUnit)this.fCUnit, (boolean)true);
                            this.fAST = root.getAST();
                            root.accept(this.createVisitor());
                            result.merge(this.fAnalyzer.checkActivation());
                            if (result.hasFatalError()) {
                                refactoringStatus2 = result;
                                break block8;
                            }
                            if (this.fVisibility == null) {
                                this.setVisibility("private");
                            }
                            this.initializeParameterInfos();
                            this.initializeUsedNames();
                            refactoringStatus = result;
                            break block9;
                        }
                        catch (Throwable throwable) {
                            Object var4_11 = null;
                            pm.worked(1);
                            pm.done();
                            throw throwable;
                        }
                    }
                    pm.worked(1);
                    pm.done();
                    return refactoringStatus4;
                }
                Object var4_8 = null;
                pm.worked(1);
                pm.done();
                return refactoringStatus3;
            }
            Object var4_9 = null;
            pm.worked(1);
            pm.done();
            return refactoringStatus2;
        }
        Object var4_10 = null;
        pm.worked(1);
        pm.done();
        return refactoringStatus;
    }

    private ASTVisitor createVisitor() throws JavaModelException {
        this.fAnalyzer = new ExtractMethodAnalyzer(this.fCUnit, Selection.createFromStartLength(this.fSelectionStart, this.fSelectionLength));
        return this.fAnalyzer;
    }

    public void setMethodName(String name) {
        this.fMethodName = name;
    }

    public String getMethodName() {
        return this.fMethodName;
    }

    public void setVisibility(String visibility) {
        this.fVisibility = visibility;
    }

    public String getVisibility() {
        return this.fVisibility;
    }

    public List getParameterInfos() {
        return this.fParameterInfos;
    }

    public void setThrowRuntimeExceptions(boolean throwRuntimeExceptions) {
        this.fThrowRuntimeExceptions = throwRuntimeExceptions;
    }

    public RefactoringStatus checkMethodName() {
        return Checks.checkMethodName(this.fMethodName);
    }

    public RefactoringStatus checkParameterNames() {
        RefactoringStatus result = new RefactoringStatus();
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo parameter = (ParameterInfo)iter.next();
            result.merge(Checks.checkIdentifier(parameter.getNewName()));
            Iterator others = this.fParameterInfos.iterator();
            while (others.hasNext()) {
                ParameterInfo other = (ParameterInfo)others.next();
                if (parameter == other || !other.getNewName().equals(parameter.getNewName())) continue;
                result.addError(RefactoringCoreMessages.getFormattedString("ExtractMethodRefactoring.error.sameParameter", other.getNewName()));
                return result;
            }
            if (!parameter.isRenamed() || !this.fUsedNames.contains(parameter.getNewName())) continue;
            result.addError(RefactoringCoreMessages.getFormattedString("ExtractMethodRefactoring.error.nameInUse", parameter.getNewName()));
            return result;
        }
        return result;
    }

    public Set getUsedNames() {
        return this.fUsedNames;
    }

    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask(RefactoringCoreMessages.getString("ExtractMethodRefactoring.checking_new_name"), 2);
        pm.subTask(EMPTY);
        RefactoringStatus result = this.checkMethodName();
        result.merge(this.checkParameterNames());
        pm.worked(1);
        MethodDeclaration node = this.fAnalyzer.getEnclosingMethod();
        if (node != null) {
            this.fAnalyzer.checkInput(result, this.fMethodName, this.fCUnit.getJavaProject(), this.fAST);
            pm.worked(1);
        }
        pm.done();
        return result;
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        if (this.fMethodName == null) {
            return null;
        }
        this.fAnalyzer.aboutToCreateChange();
        MethodDeclaration method = this.fAnalyzer.getEnclosingMethod();
        String sourceMethodName = method.getName().getIdentifier();
        CompilationUnitChange result = null;
        try {
            result = new CompilationUnitChange(RefactoringCoreMessages.getFormattedString("ExtractMethodRefactoring.change_name", new String[]{this.fMethodName, sourceMethodName}), this.fCUnit);
            ITypeBinding[] exceptions = this.fAnalyzer.getExceptions(this.fThrowRuntimeExceptions, this.fAST);
            int i = 0;
            while (i < exceptions.length) {
                ITypeBinding exception = exceptions[i];
                this.fImportEdit.addImport(Bindings.getFullyQualifiedImportName(exception));
                ++i;
            }
            if (this.fAnalyzer.generateImport()) {
                this.fImportEdit.addImport(ASTNodes.asString((ASTNode)this.fAnalyzer.getReturnType()));
            }
            if (!this.fImportEdit.isEmpty()) {
                result.addTextEdit(RefactoringCoreMessages.getString("ExtractMethodRefactoring.organize_imports"), this.fImportEdit);
            }
            TextBuffer buffer = null;
            try {
                buffer = TextBuffer.create((IFile)WorkingCopyUtil.getOriginal(this.fCUnit).getResource());
                String delimiter = buffer.getLineDelimiter(buffer.getLineOfOffset(method.getStartPosition()));
                result.addTextEdit(RefactoringCoreMessages.getFormattedString("ExtractMethodRefactoring.add_method", this.fMethodName), this.createNewMethodEdit(buffer));
                result.addTextEdit(RefactoringCoreMessages.getFormattedString("ExtractMethodRefactoring.substitute_with_call", this.fMethodName), SimpleTextEdit.createReplace(this.fSelectionStart, this.fSelectionLength, this.createCall(buffer, delimiter)));
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                TextBuffer.release(buffer);
                throw throwable;
            }
            Object var8_13 = null;
            TextBuffer.release(buffer);
        }
        catch (JavaModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
        return result;
    }

    public String getSignature() {
        return this.getSignature(this.fMethodName);
    }

    public String getSignature(String methodName) {
        Type returnType;
        StringBuffer buffer = new StringBuffer(this.fVisibility);
        if (this.fVisibility.length() > 0) {
            buffer.append(BLANK);
        }
        if (Modifier.isStatic((int)this.fAnalyzer.getEnclosingMethod().getModifiers()) || this.fAnalyzer.getForceStatic()) {
            buffer.append(STATIC);
            buffer.append(BLANK);
        }
        if ((returnType = this.fAnalyzer.getReturnType()) != null) {
            if (this.fAnalyzer.generateImport()) {
                buffer.append(ASTNodes.getTypeName(returnType));
            } else {
                buffer.append(ASTNodes.asString((ASTNode)returnType));
            }
            buffer.append(BLANK);
        }
        buffer.append(methodName);
        this.appendParameters(buffer);
        this.appendThrownExceptions(buffer);
        return buffer.toString();
    }

    private void initializeParameterInfos() {
        IVariableBinding[] arguments = this.fAnalyzer.getArguments();
        this.fParameterInfos = new ArrayList(arguments.length);
        MethodDeclaration root = this.fAnalyzer.getEnclosingMethod();
        int i = 0;
        while (i < arguments.length) {
            IVariableBinding argument = arguments[i];
            if (argument != null) {
                VariableDeclaration declaration = ASTNodes.findVariableDeclaration(argument, (ASTNode)root);
                ParameterInfo info = new ParameterInfo(this.getType(declaration), argument.getName(), i);
                info.setData(argument);
                this.fParameterInfos.add(info);
            }
            ++i;
        }
    }

    private void initializeUsedNames() {
        this.fUsedNames = UsedNamesCollector.perform(this.fAnalyzer.getSelectedNodes());
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo parameter = (ParameterInfo)iter.next();
            this.fUsedNames.remove(parameter.getOldName());
        }
    }

    private RefactoringStatus mergeTextSelectionStatus(RefactoringStatus status) {
        status.addFatalError(RefactoringCoreMessages.getString("ExtractMethodRefactoring.no_set_of_statements"));
        return status;
    }

    private TextEdit createNewMethodEdit(TextBuffer buffer) throws CoreException {
        MethodDeclaration method = this.fAnalyzer.getEnclosingMethod();
        int methodStart = method.getStartPosition();
        MethodBlock methodBlock = new MethodBlock(this.getSignature(), this.createMethodBody(buffer));
        int spacing = MethodBlock.probeSpacing(buffer, method);
        CodeBlockEdit result = CodeBlockEdit.createInsert(methodStart + method.getLength(), methodBlock, spacing + 1);
        return result;
    }

    private CodeBlock createMethodBody(TextBuffer buffer) throws CoreException {
        ITypeBinding binding;
        CodeBlock body = this.createStatementBlock(buffer);
        boolean extractsExpression = this.fAnalyzer.isExpressionSelected();
        if (!(!extractsExpression || (binding = this.fAnalyzer.getExpressionBinding()) == null || binding.isPrimitive() && "void".equals(binding.getName()))) {
            body.prependToLine(0, RETURN_BLANK);
        }
        if (this.sourceNeedsSemicolon()) {
            body.appendToLine(body.size() - 1, SEMICOLON);
        }
        IVariableBinding[] methodLocals = this.fAnalyzer.getMethodLocals();
        int i = methodLocals.length - 1;
        while (i >= 0) {
            if (methodLocals[i] != null) {
                body.prepend(this.getLocalDeclaration(methodLocals[i]));
            }
            --i;
        }
        IVariableBinding returnValue = this.fAnalyzer.getReturnValue();
        if (returnValue != null) {
            body.append(RETURN_BLANK + returnValue.getName() + SEMICOLON);
        }
        return body;
    }

    private CodeBlock createStatementBlock(TextBuffer original) throws CoreException {
        TextBuffer buffer = TextBuffer.create(original.getContent());
        ArrayList<Object> bindings = new ArrayList<Object>(2);
        ArrayList<String> newNames = new ArrayList<String>(2);
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo parameter = (ParameterInfo)iter.next();
            if (!parameter.isRenamed()) continue;
            bindings.add(parameter.getData());
            newNames.add(parameter.getNewName());
        }
        ASTRewrite rewriter = new ASTRewrite((ASTNode)this.fAnalyzer.getEnclosingMethod());
        SimpleNameRenamer.perform(rewriter, bindings.toArray(new IBinding[bindings.size()]), newNames.toArray(new String[newNames.size()]), this.fAnalyzer.getSelectedNodes());
        TextBufferEditor editor = new TextBufferEditor(buffer);
        RangeMarker root = new RangeMarker(this.fSelectionStart, this.fSelectionLength);
        rewriter.rewriteNode(buffer, root, null);
        editor.add(root);
        editor.performEdits(null);
        TextRange range = root.getTextRange();
        return new CodeBlock(buffer, range.getOffset(), range.getLength());
    }

    private String createCall(TextBuffer buffer, String delimiter) {
        int tabWidth = CodeFormatterUtil.getTabWidth();
        int firstLineIndent = Strings.computeIndent(buffer.getLineContentOfOffset(this.fSelectionStart), tabWidth);
        StringBuffer code = new StringBuffer();
        IVariableBinding[] locals = this.fAnalyzer.getCallerLocals();
        int i = 0;
        while (i < locals.length) {
            this.appendLocalDeclaration(code, locals[i]);
            code.append(SEMICOLON);
            code.append(delimiter);
            ++i;
        }
        int returnKind = this.fAnalyzer.getReturnKind();
        switch (returnKind) {
            case 2: {
                IVariableBinding binding = this.fAnalyzer.getReturnLocal();
                if (binding != null) {
                    this.appendLocalDeclaration(code, binding);
                } else {
                    binding = this.fAnalyzer.getReturnValue();
                    code.append(binding.getName());
                }
                code.append(" = ");
                break;
            }
            case 4: {
                code.append(RETURN_BLANK);
            }
        }
        code.append(this.fMethodName);
        code.append("(");
        int i2 = 0;
        while (i2 < this.fParameterInfos.size()) {
            if (i2 > 0) {
                code.append(COMMA_BLANK);
            }
            code.append(((ParameterInfo)this.fParameterInfos.get(i2)).getOldName());
            ++i2;
        }
        code.append(")");
        if (this.callNeedsSemicolon()) {
            code.append(SEMICOLON);
        }
        if (returnKind == 3 && !this.fAnalyzer.isLastStatementSelected()) {
            code.append(delimiter);
            code.append(RETURN);
            code.append(SEMICOLON);
        }
        ICodeFormatter formatter = ToolFactory.createCodeFormatter();
        String result = formatter.format(code.toString(), firstLineIndent, null, delimiter);
        int pos = this.fSelectionStart + this.fSelectionLength;
        TextRegion region = buffer.getLineInformationOfOffset(pos);
        if (region.getOffset() == pos) {
            result = String.valueOf(result) + delimiter;
        }
        region = buffer.getLineInformationOfOffset(this.fSelectionStart);
        String selectedLine = buffer.getContent(region.getOffset(), this.fSelectionStart - region.getOffset());
        int indent = Strings.computeIndent(selectedLine, tabWidth);
        return Strings.trimIndent(result, indent, tabWidth);
    }

    private boolean callNeedsSemicolon() {
        ASTNode node = this.fAnalyzer.getLastSelectedNode();
        return node instanceof Statement;
    }

    private boolean sourceNeedsSemicolon() {
        ASTNode node = this.fAnalyzer.getLastSelectedNode();
        return node instanceof Expression;
    }

    private void appendParameters(StringBuffer buffer) {
        buffer.append('(');
        int size = this.fParameterInfos.size();
        int i = 0;
        while (i < size) {
            ParameterInfo info = (ParameterInfo)this.fParameterInfos.get(i);
            if (i > 0) {
                buffer.append(COMMA_BLANK);
            }
            this.appendModifiers(buffer, info);
            buffer.append(info.getNewTypeName());
            buffer.append(BLANK);
            buffer.append(info.getNewName());
            ++i;
        }
        buffer.append(')');
    }

    private void appendModifiers(StringBuffer buffer, ParameterInfo parameter) {
        MethodDeclaration root = this.fAnalyzer.getEnclosingMethod();
        VariableDeclaration declaration = ASTNodes.findVariableDeclaration((IVariableBinding)parameter.getData(), (ASTNode)root);
        this.appendModifiers(buffer, declaration);
    }

    private void appendModifiers(StringBuffer buffer, VariableDeclaration declaration) {
        String modifiers = ASTNodes.modifierString(ASTNodes.getModifiers(declaration));
        if (modifiers.length() > 0) {
            buffer.append(modifiers);
            buffer.append(BLANK);
        }
    }

    private void appendThrownExceptions(StringBuffer buffer) {
        ITypeBinding[] exceptions = this.fAnalyzer.getExceptions(this.fThrowRuntimeExceptions, this.fAST);
        if (exceptions.length == 0) {
            return;
        }
        buffer.append(" throws ");
        int i = 0;
        while (i < exceptions.length) {
            ITypeBinding exception = exceptions[i];
            if (i > 0) {
                buffer.append(COMMA_BLANK);
            }
            buffer.append(exception.getName());
            ++i;
        }
    }

    private void appendLocalDeclaration(StringBuffer buffer, IVariableBinding local) {
        MethodDeclaration root = this.fAnalyzer.getEnclosingMethod();
        VariableDeclaration declaration = ASTNodes.findVariableDeclaration(local, (ASTNode)root);
        this.appendModifiers(buffer, declaration);
        buffer.append(this.getType(declaration));
        buffer.append(BLANK);
        buffer.append(local.getName());
    }

    private String getLocalDeclaration(IVariableBinding local) {
        StringBuffer buffer = new StringBuffer();
        this.appendLocalDeclaration(buffer, local);
        buffer.append(SEMICOLON);
        return buffer.toString();
    }

    private String getType(VariableDeclaration declaration) {
        return ASTNodes.asString((ASTNode)ASTNodes.getType(declaration));
    }

    private static class UsedNamesCollector
    extends ASTVisitor {
        private Set result = new HashSet();
        private Set fIgnore = new HashSet();

        UsedNamesCollector() {
        }

        public static Set perform(ASTNode[] nodes) {
            UsedNamesCollector collector = new UsedNamesCollector();
            int i = 0;
            while (i < nodes.length) {
                nodes[i].accept((ASTVisitor)collector);
                ++i;
            }
            return collector.result;
        }

        public boolean visit(FieldAccess node) {
            Expression exp = node.getExpression();
            if (exp != null) {
                this.fIgnore.add(node.getName());
            }
            return true;
        }

        public void endVisit(FieldAccess node) {
            this.fIgnore.remove(node.getName());
        }

        public boolean visit(MethodInvocation node) {
            Expression exp = node.getExpression();
            if (exp != null) {
                this.fIgnore.add(node.getName());
            }
            return true;
        }

        public void endVisit(MethodInvocation node) {
            this.fIgnore.remove(node.getName());
        }

        public boolean visit(QualifiedName node) {
            this.fIgnore.add(node.getName());
            return true;
        }

        public void endVisit(QualifiedName node) {
            this.fIgnore.remove(node.getName());
        }

        public boolean visit(SimpleName node) {
            if (!this.fIgnore.contains(node)) {
                this.result.add(node.getIdentifier());
            }
            return true;
        }

        public boolean visit(TypeDeclaration node) {
            this.result.add(node.getName().getIdentifier());
            return false;
        }
    }
}

