/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.Binding2JavaModel;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.textmanipulation.MultiTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;

public class ConvertAnonymousToNestedRefactoring
extends Refactoring {
    private final int fSelectionStart;
    private final int fSelectionLength;
    private final ICompilationUnit fCu;
    private int fVisibility;
    private boolean fDeclareFinal;
    private String fClassName;
    private CompilationUnit fCompilationUnitNode;
    private AnonymousClassDeclaration fAnonymousInnerClassNode;
    private Set fClassNamesUsed;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ConvertAnonymousToNestedRefactoring(ICompilationUnit cu, int selectionStart, int selectionLength) {
        Assert.isTrue(selectionStart >= 0);
        Assert.isTrue(selectionLength >= 0);
        Assert.isTrue(cu.exists());
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = cu;
    }

    public int[] getAvailableVisibilities() {
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = 4;
        nArray[3] = 2;
        return nArray;
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public void setVisibility(int visibility) {
        Assert.isTrue(visibility == 2 || visibility == 0 || visibility == 4 || visibility == 1);
        this.fVisibility = visibility;
    }

    public void setClassName(String className) {
        Assert.isNotNull(className);
        this.fClassName = className;
    }

    public boolean canEnableSettingFinal() {
        return true;
    }

    public boolean getDeclareFinal() {
        return this.fDeclareFinal;
    }

    public void setDeclareFinal(boolean declareFinal) {
        this.fDeclareFinal = declareFinal;
    }

    public String getName() {
        return RefactoringCoreMessages.getString("ConvertAnonymousToNestedRefactoring.name");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block6: {
            RefactoringStatus refactoringStatus2;
            block5: {
                RefactoringStatus refactoringStatus3;
                block4: {
                    try {
                        RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCu}));
                        if (result.hasFatalError()) {
                            refactoringStatus3 = result;
                            Object var3_6 = null;
                            break block4;
                        }
                        this.initAST();
                        if (this.fAnonymousInnerClassNode == null) {
                            refactoringStatus2 = RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ConvertAnonymousToNestedRefactoring.place_caret"));
                            break block5;
                        }
                        this.initializeDefaults();
                        refactoringStatus = new RefactoringStatus();
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var3_9 = null;
                        pm.done();
                        throw throwable;
                    }
                }
                pm.done();
                return refactoringStatus3;
            }
            Object var3_7 = null;
            pm.done();
            return refactoringStatus2;
        }
        Object var3_8 = null;
        pm.done();
        return refactoringStatus;
    }

    private void initializeDefaults() {
        this.fVisibility = 2;
        this.fClassName = "";
        this.fDeclareFinal = true;
    }

    private void initAST() {
        this.fCompilationUnitNode = AST.parseCompilationUnit((ICompilationUnit)this.fCu, (boolean)true);
        this.fAnonymousInnerClassNode = ConvertAnonymousToNestedRefactoring.getAnonymousInnerClass(NodeFinder.perform((ASTNode)this.fCompilationUnitNode, this.fSelectionStart, this.fSelectionLength));
        if (this.fAnonymousInnerClassNode != null) {
            TypeDeclaration[] nestedtypes = this.getTypeDeclaration().getTypes();
            this.fClassNamesUsed = new HashSet(nestedtypes.length);
            int i = 0;
            while (i < nestedtypes.length) {
                this.fClassNamesUsed.add(nestedtypes[i].getName().getIdentifier());
                ++i;
            }
        }
    }

    private static AnonymousClassDeclaration getAnonymousInnerClass(ASTNode node) {
        AnonymousClassDeclaration anon;
        if (node == null) {
            return null;
        }
        if (node instanceof AnonymousClassDeclaration) {
            return (AnonymousClassDeclaration)node;
        }
        if (node instanceof ClassInstanceCreation && (anon = ((ClassInstanceCreation)node).getAnonymousClassDeclaration()) != null) {
            return anon;
        }
        if (node.getParent() instanceof ClassInstanceCreation && (anon = ((ClassInstanceCreation)node.getParent()).getAnonymousClassDeclaration()) != null) {
            return anon;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.AnonymousClassDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (AnonymousClassDeclaration)ASTNodes.getParent(node, clazz);
    }

    public RefactoringStatus validateInput() {
        RefactoringStatus result = Checks.checkTypeName(this.fClassName);
        if (result.hasFatalError()) {
            return result;
        }
        if (this.fClassNamesUsed.contains(this.fClassName)) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ConvertAnonymousToNestedRefactoring.type_exists"));
        }
        if (this.fClassName.equals(this.getSuperConstructorBinding().getDeclaringClass().getName())) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ConvertAnonymousToNestedRefactoring.another_name"));
        }
        if (this.classNameHidesEnclosingType()) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ConvertAnonymousToNestedRefactoring.name_hides"));
        }
        return result;
    }

    private boolean classNameHidesEnclosingType() {
        ITypeBinding type = this.getTypeDeclaration().resolveBinding();
        while (type != null) {
            if (this.fClassName.equals(type.getName())) {
                return true;
            }
            type = type.getDeclaringClass();
        }
        return false;
    }

    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        try {
            refactoringStatus = this.validateInput();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        IChange iChange;
        pm.beginTask("", 1);
        try {
            try {
                ASTRewrite rewrite = new ASTRewrite((ASTNode)this.fCompilationUnitNode);
                this.addNestedClass(rewrite);
                this.modifyConstructorCall(rewrite);
                iChange = this.createChange(rewrite);
                Object var3_6 = null;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return iChange;
    }

    private IChange createChange(ASTRewrite rewrite) throws CoreException {
        CompilationUnitChange change = new CompilationUnitChange("", this.fCu);
        TextBuffer textBuffer = TextBuffer.create(this.fCu.getBuffer().getContents());
        MultiTextEdit resultingEdits = new MultiTextEdit();
        rewrite.rewriteNode(textBuffer, resultingEdits, null);
        change.addTextEdit(RefactoringCoreMessages.getString("ConvertAnonymousToNestedRefactoring.edit_name"), resultingEdits);
        rewrite.removeModifications();
        return change;
    }

    private void modifyConstructorCall(ASTRewrite rewrite) {
        rewrite.markAsReplaced((ASTNode)this.getClassInstanceCreation(), this.createNewClassInstanceCreation(rewrite));
    }

    private ASTNode createNewClassInstanceCreation(ASTRewrite rewrite) {
        ClassInstanceCreation newClassCreation = this.getAST().newClassInstanceCreation();
        newClassCreation.setAnonymousClassDeclaration(null);
        newClassCreation.setName((Name)this.getAST().newSimpleName(this.fClassName));
        this.copyArguments(rewrite, newClassCreation);
        this.addArgumentsForLocalsUsedInInnerClass(rewrite, newClassCreation);
        return newClassCreation;
    }

    private void addArgumentsForLocalsUsedInInnerClass(ASTRewrite rewrite, ClassInstanceCreation newClassCreation) {
        IVariableBinding[] usedLocals = this.getUsedLocalVariables();
        int i = 0;
        while (i < usedLocals.length) {
            IVariableBinding local = usedLocals[i];
            SimpleName expression = this.getAST().newSimpleName(local.getName());
            rewrite.markAsInserted((ASTNode)expression);
            newClassCreation.arguments().add(expression);
            ++i;
        }
    }

    private void copyArguments(ASTRewrite rewrite, ClassInstanceCreation newClassCreation) {
        Iterator iter = this.getClassInstanceCreation().arguments().iterator();
        while (iter.hasNext()) {
            Expression arg = (Expression)iter.next();
            Expression copy = (Expression)rewrite.createCopy((ASTNode)arg);
            rewrite.markAsInserted((ASTNode)copy);
            newClassCreation.arguments().add(copy);
        }
    }

    private void addNestedClass(ASTRewrite rewrite) throws JavaModelException {
        TypeDeclaration type = this.getTypeDeclaration();
        List bodyDeclarations = type.bodyDeclarations();
        int index = ConvertAnonymousToNestedRefactoring.findIndexOfFistNestedClass(bodyDeclarations);
        if (index == -1) {
            index = 0;
        }
        TypeDeclaration newNestedClass = this.createNewNestedClass(rewrite);
        rewrite.markAsInserted((ASTNode)newNestedClass);
        bodyDeclarations.add(index, newNestedClass);
    }

    private static int findIndexOfFistNestedClass(List bodyDeclarations) {
        int i = 0;
        int n = bodyDeclarations.size();
        while (i < n) {
            BodyDeclaration each = (BodyDeclaration)bodyDeclarations.get(i);
            if (ConvertAnonymousToNestedRefactoring.isNestedType(each)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static boolean isNestedType(BodyDeclaration each) {
        if (!(each instanceof TypeDeclaration)) {
            return false;
        }
        return each.getParent() instanceof TypeDeclaration;
    }

    private TypeDeclaration createNewNestedClass(ASTRewrite rewrite) throws JavaModelException {
        TypeDeclaration newType = this.getAST().newTypeDeclaration();
        newType.setInterface(false);
        newType.setJavadoc(null);
        newType.setModifiers(this.createModifiersForNestedClass());
        newType.setName(this.getAST().newSimpleName(this.fClassName));
        this.setSuperType(newType);
        this.removeInitializationFromDeclaredFields(rewrite, newType);
        this.copyBodyDeclarationsToNestedClass(rewrite, newType);
        this.createFieldsForAccessedLocals(rewrite, newType);
        this.createNewConstructorIfNeeded(rewrite, newType);
        return newType;
    }

    private void removeInitializationFromDeclaredFields(ASTRewrite rewrite, TypeDeclaration newType) {
        Iterator iter = this.getFieldsToInitializeInConstructor().iterator();
        while (iter.hasNext()) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)iter.next();
            Assert.isNotNull(fragment.getInitializer());
            rewrite.markAsRemoved((ASTNode)fragment.getInitializer());
        }
    }

    private void createFieldsForAccessedLocals(ASTRewrite rewrite, TypeDeclaration newType) {
        IVariableBinding[] usedLocals = this.getUsedLocalVariables();
        int i = 0;
        while (i < usedLocals.length) {
            IVariableBinding local = usedLocals[i];
            VariableDeclarationFragment fragment = this.getAST().newVariableDeclarationFragment();
            fragment.setExtraDimensions(0);
            fragment.setInitializer(null);
            fragment.setName(this.getAST().newSimpleName(local.getName()));
            FieldDeclaration field = this.getAST().newFieldDeclaration(fragment);
            field.setType(Bindings.createType(local.getType(), this.getAST(), false));
            field.setModifiers(18);
            newType.bodyDeclarations().add(ConvertAnonymousToNestedRefactoring.findIndexOfLastField(newType.bodyDeclarations()) + 1, field);
            rewrite.markAsInserted((ASTNode)field);
            ++i;
        }
    }

    private IVariableBinding[] getUsedLocalVariables() {
        HashSet result = new HashSet(0);
        this.fAnonymousInnerClassNode.accept(this.createTempUsageFinder(result));
        return result.toArray(new IVariableBinding[result.size()]);
    }

    private ASTVisitor createTempUsageFinder(final Set result) {
        return new ASTVisitor(){

            public boolean visit(SimpleName node) {
                IBinding binding = node.resolveBinding();
                if (ConvertAnonymousToNestedRefactoring.this.isBindingToTemp(binding)) {
                    result.add(binding);
                }
                return true;
            }
        };
    }

    private boolean isBindingToTemp(IBinding binding) {
        if (!(binding instanceof IVariableBinding)) {
            return false;
        }
        if (!Modifier.isFinal((int)binding.getModifiers())) {
            return false;
        }
        ASTNode declaringNode = this.fCompilationUnitNode.findDeclaringNode(binding);
        if (declaringNode == null) {
            return false;
        }
        return !ASTNodes.isParent(declaringNode, (ASTNode)this.fAnonymousInnerClassNode);
    }

    private void createNewConstructorIfNeeded(ASTRewrite rewrite, TypeDeclaration newType) throws JavaModelException {
        IVariableBinding[] usedLocals = this.getUsedLocalVariables();
        if (this.getClassInstanceCreation().arguments().isEmpty() && usedLocals.length == 0) {
            return;
        }
        MethodDeclaration newConstructor = this.getAST().newMethodDeclaration();
        newConstructor.setConstructor(true);
        newConstructor.setExtraDimensions(0);
        newConstructor.setJavadoc(null);
        newConstructor.setModifiers(this.fVisibility);
        newConstructor.setName(this.getAST().newSimpleName(this.fClassName));
        this.addParametersToNewConstructor(newConstructor, rewrite);
        int paramCount = newConstructor.parameters().size();
        this.addParametersForLocalsUsedInInnerClass(rewrite, usedLocals, newConstructor);
        Block constructorBody = this.getAST().newBlock();
        SuperConstructorInvocation superConstructorInvocation = this.getAST().newSuperConstructorInvocation();
        int i = 0;
        while (i < paramCount) {
            SingleVariableDeclaration param = (SingleVariableDeclaration)newConstructor.parameters().get(i);
            superConstructorInvocation.arguments().add(this.getAST().newSimpleName(param.getName().getIdentifier()));
            ++i;
        }
        constructorBody.statements().add(superConstructorInvocation);
        i = 0;
        while (i < usedLocals.length) {
            IVariableBinding local = usedLocals[i];
            String assignmentCode = ToolFactory.createCodeFormatter().format("this." + local.getName() + "=" + local.getName(), 0, null, this.getLineSeparator());
            Expression assignmentExpression = (Expression)rewrite.createPlaceholder(assignmentCode, 3);
            ExpressionStatement assignmentStatement = this.getAST().newExpressionStatement(assignmentExpression);
            constructorBody.statements().add(assignmentStatement);
            ++i;
        }
        this.addFieldInitialization(rewrite, constructorBody);
        newConstructor.setBody(constructorBody);
        this.addExceptionsToNewConstructor(newConstructor, rewrite);
        rewrite.markAsInserted((ASTNode)newConstructor);
        int index = 1 + usedLocals.length + ConvertAnonymousToNestedRefactoring.findIndexOfLastField(this.fAnonymousInnerClassNode.bodyDeclarations());
        newType.bodyDeclarations().add(index, newConstructor);
    }

    private void addFieldInitialization(ASTRewrite rewrite, Block constructorBody) {
        Iterator iter = this.getFieldsToInitializeInConstructor().iterator();
        while (iter.hasNext()) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)iter.next();
            Assignment assignmentExpression = this.getAST().newAssignment();
            assignmentExpression.setOperator(Assignment.Operator.ASSIGN);
            assignmentExpression.setLeftHandSide((Expression)this.getAST().newSimpleName(fragment.getName().getIdentifier()));
            Expression rhs = (Expression)rewrite.createCopy((ASTNode)fragment.getInitializer());
            assignmentExpression.setRightHandSide(rhs);
            ExpressionStatement assignmentStatement = this.getAST().newExpressionStatement((Expression)assignmentExpression);
            constructorBody.statements().add(assignmentStatement);
        }
    }

    private List getFieldsToInitializeInConstructor() {
        ArrayList<VariableDeclarationFragment> result = new ArrayList<VariableDeclarationFragment>(0);
        Iterator iter = this.fAnonymousInnerClassNode.bodyDeclarations().iterator();
        while (iter.hasNext()) {
            BodyDeclaration element = (BodyDeclaration)iter.next();
            if (!(element instanceof FieldDeclaration)) continue;
            FieldDeclaration field = (FieldDeclaration)element;
            Iterator fragmentIter = field.fragments().iterator();
            while (fragmentIter.hasNext()) {
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragmentIter.next();
                if (!this.isToBeInitializerInConstructor(fragment)) continue;
                result.add(fragment);
            }
        }
        return result;
    }

    private boolean isToBeInitializerInConstructor(VariableDeclarationFragment fragment) {
        if (fragment.getInitializer() == null) {
            return false;
        }
        return this.areLocalsUsedIn(fragment.getInitializer());
    }

    private boolean areLocalsUsedIn(Expression fieldInitializer) {
        HashSet localsUsed = new HashSet(0);
        fieldInitializer.accept(this.createTempUsageFinder(localsUsed));
        return !localsUsed.isEmpty();
    }

    private void addParametersForLocalsUsedInInnerClass(ASTRewrite rewrite, IVariableBinding[] usedLocals, MethodDeclaration newConstructor) {
        int i = 0;
        while (i < usedLocals.length) {
            IVariableBinding local = usedLocals[i];
            SingleVariableDeclaration param = this.createNewParamDeclarationNode(local.getName(), local.getType());
            rewrite.markAsInserted((ASTNode)param);
            newConstructor.parameters().add(param);
            ++i;
        }
    }

    private IMethodBinding getSuperConstructorBinding() {
        IMethodBinding anonConstr = this.getClassInstanceCreation().resolveConstructorBinding();
        ITypeBinding superClass = anonConstr.getDeclaringClass().getSuperclass();
        IMethodBinding[] superMethods = superClass.getDeclaredMethods();
        int i = 0;
        while (i < superMethods.length) {
            IMethodBinding superMethod = superMethods[i];
            if (superMethod.isConstructor() && ConvertAnonymousToNestedRefactoring.parameterTypesMatch(superMethod, anonConstr)) {
                return superMethod;
            }
            ++i;
        }
        Assert.isTrue(false);
        return null;
    }

    private static boolean parameterTypesMatch(IMethodBinding m1, IMethodBinding m2) {
        ITypeBinding[] m2Params;
        ITypeBinding[] m1Params = m1.getParameterTypes();
        if (m1Params.length != (m2Params = m2.getParameterTypes()).length) {
            return false;
        }
        int i = 0;
        while (i < m2Params.length) {
            if (!m1Params[i].equals((Object)m2Params[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void addExceptionsToNewConstructor(MethodDeclaration newConstructor, ASTRewrite rewrite) {
        IMethodBinding constructorBinding = this.getSuperConstructorBinding();
        if (constructorBinding == null) {
            return;
        }
        ITypeBinding[] exceptions = constructorBinding.getExceptionTypes();
        int i = 0;
        while (i < exceptions.length) {
            Name exceptionTypeName = this.getAST().newName(Bindings.getNameComponents(exceptions[i]));
            newConstructor.thrownExceptions().add(exceptionTypeName);
            ++i;
        }
    }

    private void addParametersToNewConstructor(MethodDeclaration newConstructor, ASTRewrite rewrite) throws JavaModelException {
        IMethodBinding constructorBinding = this.getSuperConstructorBinding();
        if (constructorBinding == null) {
            return;
        }
        ITypeBinding[] paramTypes = constructorBinding.getParameterTypes();
        IMethod method = Binding2JavaModel.find(constructorBinding, this.fCu.getJavaProject());
        if (method == null) {
            return;
        }
        String[] parameterNames = method.getParameterNames();
        int i = 0;
        while (i < parameterNames.length) {
            SingleVariableDeclaration param = this.createNewParamDeclarationNode(parameterNames[i], paramTypes[i]);
            rewrite.markAsInserted((ASTNode)param);
            newConstructor.parameters().add(param);
            ++i;
        }
    }

    private SingleVariableDeclaration createNewParamDeclarationNode(String paramName, ITypeBinding paramType) {
        SingleVariableDeclaration param = this.getAST().newSingleVariableDeclaration();
        param.setExtraDimensions(0);
        param.setInitializer(null);
        param.setModifiers(0);
        param.setName(this.getAST().newSimpleName(paramName));
        param.setType(Bindings.createType(paramType, this.getAST(), false));
        return param;
    }

    private void copyBodyDeclarationsToNestedClass(ASTRewrite rewrite, TypeDeclaration newType) {
        Iterator iter = this.fAnonymousInnerClassNode.bodyDeclarations().iterator();
        while (iter.hasNext()) {
            BodyDeclaration element = (BodyDeclaration)iter.next();
            BodyDeclaration copy = (BodyDeclaration)rewrite.createCopy((ASTNode)element);
            rewrite.markAsInserted((ASTNode)copy);
            newType.bodyDeclarations().add(copy);
        }
    }

    private void setSuperType(TypeDeclaration newType) throws JavaModelException {
        ITypeBinding binding = this.getClassInstanceCreation().resolveTypeBinding();
        if (binding == null) {
            return;
        }
        if (binding.getSuperclass().getQualifiedName().equals("java.lang.Object")) {
            Assert.isTrue(binding.getInterfaces().length <= 1);
            if (binding.getInterfaces().length == 0) {
                return;
            }
            newType.superInterfaces().add(0, this.getSuperTypeName());
        } else {
            newType.setSuperclass(this.getSuperTypeName());
        }
    }

    private Name getSuperTypeName() throws JavaModelException {
        return this.getAST().newName(ConvertAnonymousToNestedRefactoring.getIdentiiers(this.getNodeSourceCode((ASTNode)this.getClassInstanceCreation().getName())));
    }

    private static String[] getIdentiiers(String nameCode) {
        StringTokenizer tokenizer = new StringTokenizer(nameCode, ".");
        String[] tokens = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            tokens[i] = tokenizer.nextToken();
            ++i;
        }
        return tokens;
    }

    private String getNodeSourceCode(ASTNode node) throws JavaModelException {
        return this.fCu.getBuffer().getText(node.getStartPosition(), node.getLength());
    }

    private int createModifiersForNestedClass() {
        int flags = this.fVisibility;
        if (this.fDeclareFinal) {
            flags |= 0x10;
        }
        return flags;
    }

    private AST getAST() {
        return this.fAnonymousInnerClassNode.getAST();
    }

    private ClassInstanceCreation getClassInstanceCreation() {
        return (ClassInstanceCreation)this.fAnonymousInnerClassNode.getParent();
    }

    private TypeDeclaration getTypeDeclaration() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.dom.TypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (TypeDeclaration)ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, clazz);
    }

    private String getLineSeparator() {
        try {
            return StubUtility.getLineDelimiterUsed((IJavaElement)this.fCu);
        }
        catch (JavaModelException javaModelException) {
            return System.getProperty("line.separator", "\n");
        }
    }

    private static int findIndexOfLastField(List bodyDeclarations) {
        int i = bodyDeclarations.size() - 1;
        while (i >= 0) {
            BodyDeclaration each = (BodyDeclaration)bodyDeclarations.get(i);
            if (each instanceof FieldDeclaration) {
                return i;
            }
            --i;
        }
        return -1;
    }
}

