/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportEdit;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.CodeScopeBuilder;
import org.eclipse.jdt.internal.corext.dom.LocalVariableIndex;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.code.CallContext;
import org.eclipse.jdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.jdt.internal.corext.refactoring.code.ParameterData;
import org.eclipse.jdt.internal.corext.refactoring.code.SourceProvider;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.InputFlowAnalyzer;
import org.eclipse.jdt.internal.corext.textmanipulation.MultiTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;

public class CallInliner {
    private ICompilationUnit fCUnit;
    private ImportEdit fImportEdit;
    private TextBuffer fBuffer;
    private SourceProvider fSourceProvider;
    private BodyDeclaration fBodyDeclaration;
    private CodeScopeBuilder.Scope fRootScope;
    private int fNumberOfLocals;
    private ASTNode fInvocation;
    private ASTRewrite fRewriter;
    private List fStatements;
    private int fInsertionIndex;
    private boolean fNeedsStatement;
    private ASTNode fTargetNode;
    private FlowContext fFlowContext;
    private FlowInfo fFlowInfo;
    private CodeScopeBuilder.Scope fInvocationScope;
    static /* synthetic */ Class class$0;

    public CallInliner(ICompilationUnit unit, SourceProvider provider, CodeGenerationSettings settings) throws CoreException {
        this.fCUnit = unit;
        this.fBuffer = TextBuffer.acquire(CallInliner.getFile(this.fCUnit));
        this.fSourceProvider = provider;
        this.fImportEdit = new ImportEdit(this.fCUnit, settings);
    }

    public void dispose() {
        TextBuffer.release(this.fBuffer);
    }

    public ImportEdit getImportEdit() {
        return this.fImportEdit;
    }

    public ASTNode getTargetNode() {
        return this.fTargetNode;
    }

    public RefactoringStatus initialize(BodyDeclaration declaration) {
        this.fBodyDeclaration = declaration;
        RefactoringStatus result = new RefactoringStatus();
        this.fRootScope = CodeScopeBuilder.perform(declaration, (IBinding)this.fSourceProvider.getDeclaration().resolveBinding());
        this.fNumberOfLocals = 0;
        switch (declaration.getNodeType()) {
            case 31: {
                this.fNumberOfLocals = LocalVariableIndex.perform((MethodDeclaration)declaration);
                break;
            }
            case 28: {
                this.fNumberOfLocals = LocalVariableIndex.perform((Initializer)declaration);
            }
        }
        return result;
    }

    public RefactoringStatus initialize(ASTNode invocation) {
        RefactoringStatus result = new RefactoringStatus();
        this.fInvocation = invocation;
        this.fRewriter = new ASTRewrite(ASTNodes.getParent(this.fInvocation, 8));
        ASTNode parent = this.fInvocation.getParent();
        int nodeType1 = parent.getNodeType();
        this.fTargetNode = nodeType1 == 21 || nodeType1 == 41 ? parent : this.fInvocation;
        return result;
    }

    private void flowAnalysis() {
        this.fInvocationScope = this.fRootScope.findScope(this.fTargetNode.getStartPosition(), this.fTargetNode.getLength());
        this.fInvocationScope.setCursor(this.fTargetNode.getStartPosition());
        this.fFlowContext = new FlowContext(0, this.fNumberOfLocals + 1);
        this.fFlowContext.setConsiderAccessMode(true);
        this.fFlowContext.setComputeMode(FlowContext.ARGUMENTS);
        Selection selection = Selection.createFromStartLength(this.fInvocation.getStartPosition(), this.fInvocation.getLength());
        switch (this.fBodyDeclaration.getNodeType()) {
            case 31: {
                this.fFlowInfo = new InputFlowAnalyzer(this.fFlowContext, selection).perform((MethodDeclaration)this.fBodyDeclaration);
                break;
            }
            case 28: {
                this.fFlowInfo = new InputFlowAnalyzer(this.fFlowContext, selection).perform((Initializer)this.fBodyDeclaration);
                break;
            }
            default: {
                Assert.isTrue(false, "Should not happen");
            }
        }
    }

    public TextEdit perform() throws CoreException {
        this.flowAnalysis();
        int callType = this.fTargetNode.getNodeType();
        CallContext context = new CallContext(this.fInvocationScope, callType, this.fImportEdit);
        ArrayList locals = new ArrayList(3);
        this.computeRealArguments(context, locals);
        this.computeReceiver(context, locals);
        String[] blocks = this.fSourceProvider.getCodeBlocks(context);
        this.initializeInsertionPoint(this.fSourceProvider.getNumberOfStatements() + locals.size());
        this.addNewLocals(locals);
        this.replaceCall(callType, blocks);
        MultiTextEdit result = new MultiTextEdit();
        this.fRewriter.rewriteNode(this.fBuffer, result, null);
        this.fRewriter.removeModifications();
        return result;
    }

    private void computeRealArguments(CallContext context, List locals) {
        List arguments = Invocations.getArguments(this.fInvocation);
        String[] realArguments = new String[arguments.size()];
        int i = 0;
        while (i < arguments.size()) {
            ParameterData parameter;
            Expression expression = (Expression)arguments.get(i);
            if (this.canInline(expression, parameter = this.fSourceProvider.getParameterData(i))) {
                realArguments[i] = this.getContent((ASTNode)expression);
            } else {
                String name;
                realArguments[i] = name = this.fInvocationScope.createName(parameter.getName(), true);
                locals.add(this.createLocalDeclaration(parameter.getTypeBinding(), name, (Expression)this.fRewriter.createCopy((ASTNode)expression)));
            }
            ++i;
        }
        context.arguments = realArguments;
    }

    private void computeReceiver(CallContext context, List locals) {
        Expression receiver = Invocations.getExpression(this.fInvocation);
        if (receiver == null) {
            return;
        }
        boolean isName = receiver instanceof Name;
        if (isName) {
            context.receiverIsStatic = ((Name)receiver).resolveBinding() instanceof ITypeBinding;
        }
        if (ASTNodes.isLiteral(receiver) || isName) {
            context.receiver = this.fBuffer.getContent(receiver.getStartPosition(), receiver.getLength());
            return;
        }
        switch (this.fSourceProvider.getReceiversToBeUpdated()) {
            case 0: {
                locals.add(this.createLocalDeclaration(receiver.resolveTypeBinding(), this.fInvocationScope.createName("r", true), (Expression)this.fRewriter.createCopy((ASTNode)receiver)));
                return;
            }
            case 1: {
                context.receiver = this.fBuffer.getContent(receiver.getStartPosition(), receiver.getLength());
                return;
            }
        }
        String local = this.fInvocationScope.createName("r", true);
        locals.add(this.createLocalDeclaration(receiver.resolveTypeBinding(), local, (Expression)this.fRewriter.createCopy((ASTNode)receiver)));
        context.receiver = local;
    }

    private void addNewLocals(List locals) {
        Iterator iter = locals.iterator();
        while (iter.hasNext()) {
            ASTNode element = (ASTNode)iter.next();
            this.fRewriter.markAsInserted(element);
            this.fStatements.add(this.fInsertionIndex++, element);
        }
    }

    private void replaceCall(int callType, String[] blocks) {
        if (blocks.length == 0) {
            if (this.fNeedsStatement) {
                this.fRewriter.markAsReplaced(this.fTargetNode, (ASTNode)this.fTargetNode.getAST().newEmptyStatement());
            } else {
                this.fRewriter.markAsRemoved(this.fTargetNode);
            }
        } else {
            Object node = null;
            int i = 0;
            while (i < blocks.length - 1) {
                node = this.fRewriter.createPlaceholder(blocks[i], 4);
                this.fRewriter.markAsInserted((ASTNode)node);
                this.fStatements.add(this.fInsertionIndex++, node);
                ++i;
            }
            String block = blocks[blocks.length - 1];
            if (callType == 21 && this.fSourceProvider.hasReturnValue()) {
                node = this.fSourceProvider.mustEvaluateReturnValue() ? this.createLocalDeclaration(this.fSourceProvider.getReturnType(), this.fInvocationScope.createName(this.fSourceProvider.getMethodName(), true), (Expression)this.fRewriter.createPlaceholder(block, 3)) : null;
            } else if (this.fTargetNode instanceof Expression) {
                node = this.fRewriter.createPlaceholder(block, 3);
                if (this.needsParenthesis()) {
                    ParenthesizedExpression pExp = this.fTargetNode.getAST().newParenthesizedExpression();
                    pExp.setExpression((Expression)node);
                    node = pExp;
                }
            } else {
                node = this.fRewriter.createPlaceholder(block, 4);
            }
            if (node != null) {
                if (this.fTargetNode == null) {
                    this.fRewriter.markAsInserted((ASTNode)node);
                    this.fStatements.add(this.fInsertionIndex++, node);
                } else {
                    this.fRewriter.markAsReplaced(this.fTargetNode, (ASTNode)node);
                }
            } else if (this.fTargetNode != null) {
                this.fRewriter.markAsRemoved(this.fTargetNode);
            }
        }
    }

    private boolean needsParenthesis() {
        if (!this.fSourceProvider.needsReturnedExpressionParenthesis()) {
            return false;
        }
        ASTNode parent = this.fTargetNode.getParent();
        int type = parent.getNodeType();
        return type == 32 || parent instanceof Expression && type != 7;
    }

    private VariableDeclarationStatement createLocalDeclaration(ITypeBinding type, String name, Expression initializer) {
        String typeName;
        if (type.isPrimitive()) {
            typeName = type.getName();
        } else {
            typeName = this.fImportEdit.addImport(Bindings.getFullyQualifiedImportName(type));
            if (type.isArray()) {
                StringBuffer buffer = new StringBuffer(typeName);
                int i = 0;
                while (i < type.getDimensions()) {
                    buffer.append("[]");
                    ++i;
                }
                typeName = buffer.toString();
            }
        }
        VariableDeclarationStatement decl = (VariableDeclarationStatement)ASTNodeFactory.newStatement(this.fInvocation.getAST(), String.valueOf(typeName) + " " + name + ";");
        ((VariableDeclarationFragment)decl.fragments().get(0)).setInitializer(initializer);
        return decl;
    }

    private boolean canInline(Expression actualParameter, ParameterData formalParameter) {
        switch (this.canInline(actualParameter)) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        if (ASTNodes.isLiteral(actualParameter) && formalParameter.isReadOnly()) {
            return true;
        }
        if (formalParameter.isWrite()) {
            return false;
        }
        return !formalParameter.needsEvaluation();
    }

    private int canInline(Expression expression) {
        if (expression instanceof Name) {
            IVariableBinding vb;
            IBinding binding = ((Name)expression).resolveBinding();
            if (binding instanceof IVariableBinding && !(vb = (IVariableBinding)binding).isField()) {
                return this.fFlowInfo.hasAccessMode(this.fFlowContext, vb, 9) ? 1 : 0;
            }
            return 0;
        }
        if (expression instanceof FieldAccess) {
            return this.canInline(((FieldAccess)expression).getExpression());
        }
        if (expression instanceof ThisExpression) {
            return this.canInline((Expression)((ThisExpression)expression).getQualifier());
        }
        if (expression instanceof SuperFieldAccess) {
            return this.canInline((Expression)((SuperFieldAccess)expression).getQualifier());
        }
        return 2;
    }

    private void initializeInsertionPoint(int nos) {
        ASTNode parentStatement;
        ASTNode container;
        int type;
        this.fStatements = null;
        this.fInsertionIndex = -1;
        this.fNeedsStatement = false;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.Statement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((type = (container = (parentStatement = ASTNodes.getParent(this.fInvocation, clazz)).getParent()).getNodeType()) == 8) {
            this.fStatements = ((Block)container).statements();
            this.fInsertionIndex = this.fStatements.indexOf(parentStatement);
        } else if (this.isControlStatement(container)) {
            this.fNeedsStatement = true;
            if (nos > 1) {
                Block block = this.fInvocation.getAST().newBlock();
                this.fStatements = block.statements();
                this.fInsertionIndex = 0;
                Statement currentStatement = null;
                switch (type) {
                    case 24: {
                        currentStatement = ((ForStatement)container).getBody();
                        break;
                    }
                    case 61: {
                        currentStatement = ((WhileStatement)container).getBody();
                        break;
                    }
                    case 19: {
                        currentStatement = ((DoStatement)container).getBody();
                        break;
                    }
                    case 25: {
                        IfStatement node = (IfStatement)container;
                        Statement thenPart = node.getThenStatement();
                        currentStatement = this.fTargetNode == thenPart || ASTNodes.isParent(this.fTargetNode, (ASTNode)thenPart) ? thenPart : node.getElseStatement();
                    }
                }
                Assert.isNotNull(currentStatement);
                if (currentStatement != this.fTargetNode) {
                    ASTNode copy = this.fRewriter.createCopy((ASTNode)currentStatement);
                    this.fStatements.add(copy);
                } else {
                    this.fTargetNode = null;
                }
                this.fRewriter.markAsReplaced((ASTNode)currentStatement, (ASTNode)block);
            }
        }
    }

    private String getContent(ASTNode node) {
        return this.fBuffer.getContent(node.getStartPosition(), node.getLength());
    }

    private static IFile getFile(ICompilationUnit cu) throws CoreException {
        return (IFile)WorkingCopyUtil.getOriginal(cu).getResource();
    }

    private boolean isControlStatement(ASTNode node) {
        int type = node.getNodeType();
        return type == 25 || type == 24 || type == 61 || type == 19;
    }
}

