/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.changes.AbstractTextChange;
import org.eclipse.jdt.internal.corext.textmanipulation.AutoOrganizingTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.GroupDescription;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBufferEditor;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEditCopier;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRange;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRegion;

public abstract class TextChange
extends AbstractTextChange {
    private List fTextEditChanges = new ArrayList(5);
    private TextEditCopier fCopier;
    private TextEdit fEdit;
    private boolean fKeepExecutedTextEdits;
    private boolean fAutoMode;

    protected TextChange(String name) {
        super(name, 0);
    }

    public void addTextEdit(String name, TextEdit edit) {
        this.addTextEdit(name, new TextEdit[]{edit});
    }

    public void addTextEdit(String name, TextEdit[] edits) {
        Assert.isNotNull(name);
        Assert.isNotNull(edits);
        GroupDescription description = new GroupDescription(name, edits);
        this.fTextEditChanges.add(new EditChange(description, this));
        if (this.fEdit == null) {
            this.fEdit = new AutoOrganizingTextEdit();
            this.fAutoMode = true;
        } else {
            Assert.isTrue(this.fAutoMode, "Can only add edits when in auto organizing mode");
        }
        int i = 0;
        while (i < edits.length) {
            this.fEdit.add(edits[i]);
            ++i;
        }
    }

    public void setEdit(TextEdit edit) {
        Assert.isTrue(this.fEdit == null, "Root edit can only be set once");
        Assert.isTrue(edit != null);
        this.fEdit = edit;
        this.fTextEditChanges = new ArrayList(5);
        this.fAutoMode = false;
    }

    public TextEdit getEdit() {
        return this.fEdit;
    }

    public void addGroupDescription(GroupDescription description) {
        Assert.isTrue(this.fEdit != null, "Can only add a description if a root edit exists");
        Assert.isTrue(!this.fAutoMode, "Group descriptions are only supported if root edit has been set by setEdit");
        Assert.isTrue(description != null);
        this.fTextEditChanges.add(new EditChange(description, this));
    }

    public GroupDescription[] getGroupDescriptions() {
        GroupDescription[] res = new GroupDescription[this.fTextEditChanges.size()];
        int i = 0;
        while (i < res.length) {
            EditChange elem = (EditChange)this.fTextEditChanges.get(i);
            res[i] = elem.getGroupDescription();
            ++i;
        }
        return res;
    }

    public EditChange[] getTextEditChanges() {
        return this.fTextEditChanges.toArray(new EditChange[this.fTextEditChanges.size()]);
    }

    public String getCurrentContent() throws JavaModelException {
        TextBuffer buffer = null;
        try {
            try {
                buffer = this.acquireTextBuffer();
                String string = buffer.getContent();
                Object var3_3 = null;
                if (buffer != null) {
                    this.releaseTextBuffer(buffer);
                }
                return string;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }
        catch (Throwable throwable) {
            block6: {
                Object var3_4 = null;
                if (buffer == null) break block6;
                this.releaseTextBuffer(buffer);
            }
            throw throwable;
        }
    }

    public String getPreviewContent() throws JavaModelException {
        return this.getPreviewTextBuffer().getContent();
    }

    public TextBuffer getPreviewTextBuffer() throws JavaModelException {
        try {
            TextBufferEditor editor = new TextBufferEditor(this.createTextBuffer());
            this.addTextEdits(editor);
            editor.performEdits((IProgressMonitor)new NullProgressMonitor());
            return editor.getTextBuffer();
        }
        catch (JavaModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    public String getCurrentContent(EditChange change, int surroundingLines) throws CoreException {
        return this.getContent(change, surroundingLines, false);
    }

    public String getPreviewContent(EditChange change, int surroundingLines) throws CoreException {
        return this.getContent(change, surroundingLines, true);
    }

    public void setKeepExecutedTextEdits(boolean keep) {
        this.fKeepExecutedTextEdits = keep;
    }

    public TextEdit getExecutedTextEdit(TextEdit original) {
        if (!this.fKeepExecutedTextEdits || this.fCopier == null) {
            return null;
        }
        return this.fCopier.getCopy(original);
    }

    public TextRange getNewTextRange(TextEdit edit) {
        TextEdit result = this.getExecutedTextEdit(edit);
        if (result == null) {
            return null;
        }
        return result.getTextRange().copy();
    }

    public TextRange getNewTextRange(TextEdit[] edits) {
        if (!this.fKeepExecutedTextEdits || this.fCopier == null) {
            return null;
        }
        ArrayList<TextEdit> copies = new ArrayList<TextEdit>(edits.length);
        int i = 0;
        while (i < edits.length) {
            TextEdit copy = this.fCopier.getCopy(edits[i]);
            if (copy != null) {
                copies.add(copy);
            }
            ++i;
        }
        return TextEdit.getTextRange(copies);
    }

    public TextRange getNewTextRange(EditChange editChange) {
        return this.getNewTextRange(editChange.getGroupDescription().getTextEdits());
    }

    public void setActive(boolean active) {
        super.setActive(active);
        Iterator iter = this.fTextEditChanges.iterator();
        while (iter.hasNext()) {
            EditChange element = (EditChange)iter.next();
            element.setActive(active);
        }
    }

    protected void addTextEdits(TextBufferEditor editor) throws CoreException {
        if (this.fEdit == null) {
            return;
        }
        this.fCopier = new TextEditCopier(this.fEdit);
        TextEdit copiedEdit = this.fCopier.copy();
        Iterator iter = this.fTextEditChanges.iterator();
        while (iter.hasNext()) {
            EditChange edit = (EditChange)iter.next();
            if (edit.isActive()) continue;
            TextEdit[] edits = edit.getGroupDescription().getTextEdits();
            int i = 0;
            while (i < edits.length) {
                TextEdit textEdit = this.fCopier.getCopy(edits[i]);
                if (textEdit != null) {
                    textEdit.setActive(false);
                }
                ++i;
            }
        }
        editor.add(copiedEdit);
        if (!this.fKeepExecutedTextEdits) {
            this.fCopier = null;
        }
    }

    protected void addTextEdits(TextBufferEditor editor, EditChange[] changes) throws CoreException {
        if (this.fEdit == null) {
            return;
        }
        this.fCopier = new TextEditCopier(this.fEdit);
        TextEdit copiedEdit = this.fCopier.copy();
        copiedEdit.setActive(false);
        int c = 0;
        while (c < changes.length) {
            EditChange change = changes[c];
            Assert.isTrue(change.getTextChange() == this);
            boolean active = change.isActive();
            TextEdit[] edits = change.getGroupDescription().getTextEdits();
            int e = 0;
            while (e < edits.length) {
                this.fCopier.getCopy(edits[e]).setActive(active);
                ++e;
            }
            ++c;
        }
        editor.add(copiedEdit);
        if (!this.fKeepExecutedTextEdits) {
            this.fCopier = null;
        }
    }

    private String getContent(EditChange change, int surroundingLines, boolean preview) throws CoreException {
        Assert.isTrue(change.getTextChange() == this);
        TextBuffer buffer = this.createTextBuffer();
        if (preview) {
            TextBufferEditor editor = new TextBufferEditor(buffer);
            this.addTextEdits(editor, new EditChange[]{change});
            editor.performEdits((IProgressMonitor)new NullProgressMonitor());
        }
        TextRange range = change.getTextRange();
        int startLine = Math.max(buffer.getLineOfOffset(range.getOffset()) - surroundingLines, 0);
        int endLine = Math.min(buffer.getLineOfOffset(range.getInclusiveEnd()) + surroundingLines, buffer.getNumberOfLines() - 1);
        int offset = buffer.getLineInformation(startLine).getOffset();
        TextRegion region = buffer.getLineInformation(endLine);
        int length = region.getOffset() + region.getLength() - offset;
        return buffer.getContent(offset, length);
    }

    public static class EditChange {
        private boolean fIsActive;
        private TextChange fTextChange;
        private GroupDescription fDescription;

        EditChange(GroupDescription description, TextChange change) {
            this.fTextChange = change;
            this.fIsActive = true;
            this.fDescription = description;
        }

        public String getName() {
            return this.fDescription.getName();
        }

        public void setActive(boolean active) {
            this.fIsActive = active;
        }

        public boolean isActive() {
            return this.fIsActive;
        }

        public TextChange getTextChange() {
            return this.fTextChange;
        }

        public TextRange getTextRange() {
            return this.fDescription.getTextRange();
        }

        public Object getModifiedElement() {
            return this.fDescription.getModifiedElement();
        }

        GroupDescription getGroupDescription() {
            return this.fDescription;
        }
    }
}

