/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.UndoTextChange;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.UndoMemento;

public class TextBufferChange
extends TextChange {
    private TextBuffer fBuffer;

    public TextBufferChange(String name, TextBuffer textBuffer) {
        super(name);
        this.fBuffer = textBuffer;
        Assert.isNotNull(this.fBuffer);
    }

    public Object getModifiedLanguageElement() {
        return null;
    }

    protected IChange createReverseChange(UndoMemento undo, int changeKind) {
        return new UndoTextBufferChange(this.getName(), this.fBuffer, changeKind, undo);
    }

    protected TextBuffer acquireTextBuffer() throws CoreException {
        return this.fBuffer;
    }

    protected void releaseTextBuffer(TextBuffer textBuffer) {
    }

    protected TextBuffer createTextBuffer() throws CoreException {
        return TextBuffer.create(this.fBuffer.getContent());
    }

    private static class UndoTextBufferChange
    extends UndoTextChange {
        private TextBuffer fBuffer;

        public UndoTextBufferChange(String name, TextBuffer buffer, int changeKind, UndoMemento undo) {
            super(name, changeKind, undo);
            this.fBuffer = buffer;
        }

        public Object getModifiedLanguageElement() {
            return null;
        }

        protected IChange createReverseChange(UndoMemento undo, int changeKind) {
            return new UndoTextBufferChange(this.getName(), this.fBuffer, changeKind, undo);
        }

        protected TextBuffer acquireTextBuffer() throws CoreException {
            return this.fBuffer;
        }

        protected void releaseTextBuffer(TextBuffer textBuffer) {
        }

        protected TextBuffer createTextBuffer() throws CoreException {
            return TextBuffer.create(this.fBuffer.getContent());
        }
    }
}

