/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.AbstractJavaElementRenameChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;

public class RenameCompilationUnitChange
extends AbstractJavaElementRenameChange {
    public RenameCompilationUnitChange(ICompilationUnit cu, String newName) throws JavaModelException {
        this(ResourceUtil.getResource(cu).getFullPath(), cu.getElementName(), newName);
        Assert.isTrue(!cu.isReadOnly(), "cu must not be read-only");
    }

    private RenameCompilationUnitChange(IPath resourcePath, String oldName, String newName) {
        super(resourcePath, oldName, newName);
    }

    protected IPath createNewPath() throws JavaModelException {
        if (this.getResourcePath().getFileExtension() != null) {
            return this.getResourcePath().removeFileExtension().removeLastSegments(1).append(this.getNewName());
        }
        return this.getResourcePath().removeLastSegments(1).append(this.getNewName());
    }

    public String getName() {
        return RefactoringCoreMessages.getFormattedString("RenameCompilationUnitChange.name", new String[]{this.getOldName(), this.getNewName()});
    }

    protected IChange createUndoChange() throws JavaModelException {
        return new RenameCompilationUnitChange(this.createNewPath(), this.getNewName(), this.getOldName());
    }

    protected void doRename(IProgressMonitor pm) throws JavaModelException {
        ICompilationUnit cu = (ICompilationUnit)this.getModifiedLanguageElement();
        if (cu != null) {
            cu.rename(this.getNewName(), false, pm);
        }
    }
}

