/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.NullChange;
import org.eclipse.jdt.internal.corext.refactoring.base.Change;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeAbortException;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.Utils;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IPackageFragmentRootManipulationQuery;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;

abstract class PackageFragmentRootReorgChange
extends Change {
    private final String fRootHandle;
    private final IPath fDestinationPath;
    private final INewNameQuery fNewNameQuery;
    private final IPackageFragmentRootManipulationQuery fUpdateClasspathQuery;

    PackageFragmentRootReorgChange(IPackageFragmentRoot root, IProject destination, INewNameQuery newNameQuery, IPackageFragmentRootManipulationQuery updateClasspathQuery) {
        Assert.isTrue(!root.isExternal());
        this.fRootHandle = root.getHandleIdentifier();
        this.fDestinationPath = Utils.getResourcePath((IResource)destination);
        this.fNewNameQuery = newNameQuery;
        this.fUpdateClasspathQuery = updateClasspathQuery;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void perform(ChangeContext context, IProgressMonitor pm) throws JavaModelException, ChangeAbortException {
        block6: {
            block5: {
                pm.beginTask(this.getName(), 2);
                try {
                    try {
                        if (!this.isActive()) {
                            Object var4_3 = null;
                            break block5;
                        }
                        String newName = this.getNewResourceName();
                        this.doPerform(this.getDestinationProjectPath().append(newName), (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    }
                    catch (Exception e) {
                        this.handleException(context, e);
                        this.setActive(false);
                    }
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    pm.done();
                    throw throwable;
                }
            }
            pm.done();
            return;
        }
        Object var4_5 = null;
        pm.done();
    }

    protected abstract void doPerform(IPath var1, IProgressMonitor var2) throws JavaModelException;

    public IChange getUndoChange() {
        return new NullChange();
    }

    public Object getModifiedLanguageElement() {
        return this.getRoot();
    }

    protected IPackageFragmentRoot getRoot() {
        return (IPackageFragmentRoot)JavaCore.create((String)this.fRootHandle);
    }

    public boolean isUndoable() {
        return false;
    }

    protected IPath getDestinationProjectPath() {
        return this.fDestinationPath;
    }

    protected IProject getDestinationProject() {
        return Utils.getProject(this.getDestinationProjectPath());
    }

    private String getNewResourceName() {
        if (this.fNewNameQuery == null) {
            return this.getRoot().getElementName();
        }
        String name = this.fNewNameQuery.getNewName();
        if (name == null) {
            return this.getRoot().getElementName();
        }
        return name;
    }

    protected int getUpdateModelFlags(boolean isCopy) throws JavaModelException {
        int otherProjects;
        int originating;
        if (isCopy) {
            originating = 0;
            otherProjects = 0;
        } else {
            originating = 2;
            otherProjects = 4;
        }
        if (!JavaCore.create((IProject)this.getDestinationProject()).exists()) {
            return 0x10 | originating;
        }
        if (!this.getRoot().isArchive()) {
            return 0x10 | originating | 8;
        }
        if (this.fUpdateClasspathQuery == null) {
            return 0x10 | originating;
        }
        IJavaProject[] referencingProjects = JavaElementUtil.getReferencingProjects(this.getRoot());
        if (referencingProjects.length == 0) {
            return 0x10 | originating | 8;
        }
        boolean updateOtherProjectsToo = this.fUpdateClasspathQuery.confirmManipulation(this.getRoot(), referencingProjects);
        if (updateOtherProjectsToo) {
            return 0x10 | originating | 8 | otherProjects;
        }
        return 0x10 | originating | 8;
    }

    protected int getResourceUpdateFlags() {
        return 34;
    }
}

