/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceManipulation;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.base.IReorgExceptionHandler;
import org.eclipse.jdt.internal.corext.refactoring.changes.AbstractDeleteChange;

public class DeleteSourceManipulationChange
extends AbstractDeleteChange {
    private String fHandle;

    public DeleteSourceManipulationChange(ISourceManipulation sm) {
        Assert.isNotNull(sm);
        this.fHandle = DeleteSourceManipulationChange.getJavaElement(sm).getHandleIdentifier();
    }

    public String getName() {
        return RefactoringCoreMessages.getString("DeleteSourceManipulationChange.delete");
    }

    public Object getModifiedLanguageElement() {
        return JavaCore.create((String)this.fHandle);
    }

    protected void doDelete(ChangeContext context, IProgressMonitor pm) throws JavaModelException {
        try {
            ((ISourceManipulation)this.getModifiedLanguageElement()).delete(false, pm);
        }
        catch (JavaModelException jme) {
            if (!(this.getModifiedLanguageElement() instanceof ICompilationUnit)) {
                throw jme;
            }
            if (!(context.getExceptionHandler() instanceof IReorgExceptionHandler)) {
                throw jme;
            }
            if (!(jme.getException() instanceof CoreException)) {
                throw jme;
            }
            ICompilationUnit cu = (ICompilationUnit)this.getModifiedLanguageElement();
            CoreException ce = (CoreException)jme.getException();
            IReorgExceptionHandler handler = (IReorgExceptionHandler)context.getExceptionHandler();
            IStatus[] children = ce.getStatus().getChildren();
            if (children.length == 1 && children[0].getCode() == 274) {
                if (handler.forceDeletingResourceOutOfSynch(cu.getElementName(), ce)) {
                    cu.delete(true, pm);
                    return;
                }
                return;
            }
            throw jme;
        }
    }

    private static IJavaElement getJavaElement(ISourceManipulation sm) {
        return (IJavaElement)sm;
    }
}

