/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.NullChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.Change;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeAbortException;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.AddToClasspathChange;

public class DeleteFromClasspathChange
extends Change {
    private final String fProjectHandle;
    private final IPath fPathToDelete;
    private IPath fPath;
    private IPath fSourceAttachmentPath;
    private IPath fSourceAttachmentRootPath;
    private int fEntryKind;
    private int fContentKind;

    public DeleteFromClasspathChange(IPackageFragmentRoot root) {
        this(root.getPath(), root.getJavaProject());
    }

    DeleteFromClasspathChange(IPath pathToDelete, IJavaProject project) {
        Assert.isNotNull(pathToDelete);
        this.fPathToDelete = pathToDelete;
        this.fProjectHandle = project.getHandleIdentifier();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void perform(ChangeContext context, IProgressMonitor pm) throws JavaModelException, ChangeAbortException {
        block8: {
            block7: {
                pm.beginTask(this.getName(), 1);
                try {
                    if (!this.isActive()) {
                        Object var9_3 = null;
                        break block7;
                    }
                    IJavaProject project = this.getJavaProject();
                    IClasspathEntry[] cp = project.getRawClasspath();
                    IClasspathEntry[] newCp = new IClasspathEntry[cp.length - 1];
                    int i = 0;
                    int j = 0;
                    while (true) {
                        if (j >= newCp.length) {
                            IClasspathEntry last = JavaCore.getResolvedClasspathEntry((IClasspathEntry)cp[cp.length - 1]);
                            if (last != null && this.toBeDeleted(last)) {
                                this.setDeletedEntryProperties(last);
                            }
                            project.setRawClasspath(newCp, pm);
                            break block8;
                        }
                        IClasspathEntry current = JavaCore.getResolvedClasspathEntry((IClasspathEntry)cp[i]);
                        if (current != null && this.toBeDeleted(current)) {
                            ++i;
                            this.setDeletedEntryProperties(current);
                        }
                        newCp[j] = cp[i];
                        ++i;
                        ++j;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_4 = null;
                    pm.done();
                    throw throwable;
                }
            }
            pm.done();
            return;
        }
        Object var9_5 = null;
        pm.done();
    }

    private boolean toBeDeleted(IClasspathEntry entry) {
        if (entry == null) {
            return false;
        }
        return this.fPathToDelete.equals((Object)entry.getPath());
    }

    private void setDeletedEntryProperties(IClasspathEntry entry) {
        this.fEntryKind = entry.getEntryKind();
        this.fContentKind = entry.getContentKind();
        this.fPath = entry.getPath();
        this.fSourceAttachmentPath = entry.getSourceAttachmentPath();
        this.fSourceAttachmentRootPath = entry.getSourceAttachmentRootPath();
    }

    private IJavaProject getJavaProject() {
        return (IJavaProject)JavaCore.create((String)this.fProjectHandle);
    }

    public IChange getUndoChange() {
        if (!this.isActive()) {
            return new NullChange();
        }
        return new AddToClasspathChange(this.getJavaProject(), this.fEntryKind, this.fContentKind, this.fPath, this.fSourceAttachmentPath, this.fSourceAttachmentRootPath);
    }

    public String getName() {
        return String.valueOf(RefactoringCoreMessages.getString("DeleteFromClassPathChange.remove")) + this.getJavaProject().getElementName();
    }

    public Object getModifiedLanguageElement() {
        return this.getJavaProject();
    }
}

