/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.AbstractDeleteChange;

public class DeleteFolderChange
extends AbstractDeleteChange {
    private IPath fPath;

    public DeleteFolderChange(IFolder folder) {
        this(DeleteFolderChange.getFolderPath(folder));
    }

    public DeleteFolderChange(IPath path) {
        this.fPath = path;
    }

    public static IPath getFolderPath(IFolder folder) {
        return folder.getFullPath().removeFirstSegments(ResourcesPlugin.getWorkspace().getRoot().getFullPath().segmentCount());
    }

    public static IFolder getFolder(IPath path) {
        return ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
    }

    public String getName() {
        return String.valueOf(RefactoringCoreMessages.getString("DeleteFolderChange.Delete_folder")) + this.fPath.lastSegment();
    }

    public Object getModifiedLanguageElement() {
        return DeleteFolderChange.getFolder(this.fPath);
    }

    protected void doDelete(ChangeContext context, IProgressMonitor pm) throws CoreException {
        IFolder folder = DeleteFolderChange.getFolder(this.fPath);
        Assert.isTrue(folder.exists());
        folder.delete(false, true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
    }
}

