/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.base.IReorgExceptionHandler;
import org.eclipse.jdt.internal.corext.refactoring.changes.AbstractDeleteChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.Utils;

public class DeleteFileChange
extends AbstractDeleteChange {
    private IPath fPath;

    public DeleteFileChange(IFile file) {
        Assert.isNotNull(file, "file");
        this.fPath = Utils.getResourcePath((IResource)file);
    }

    private IFile getFile() {
        return Utils.getFile(this.fPath);
    }

    public String getName() {
        return String.valueOf(RefactoringCoreMessages.getString("DeleteFileChange.delete_file")) + this.fPath.lastSegment();
    }

    public Object getModifiedLanguageElement() {
        return this.getFile();
    }

    protected void doDelete(ChangeContext context, IProgressMonitor pm) throws CoreException {
        IFile file = this.getFile();
        Assert.isNotNull(file);
        Assert.isTrue(file.exists());
        try {
            file.delete(false, true, pm);
        }
        catch (CoreException e) {
            if (!(context.getExceptionHandler() instanceof IReorgExceptionHandler)) {
                throw e;
            }
            IReorgExceptionHandler handler = (IReorgExceptionHandler)context.getExceptionHandler();
            IStatus[] children = e.getStatus().getChildren();
            if (children.length == 1 && children[0].getCode() == 274) {
                if (handler.forceDeletingResourceOutOfSynch(file.getName(), e)) {
                    file.delete(true, true, pm);
                    return;
                }
                return;
            }
            throw e;
        }
    }
}

