/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.Change;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeAbortException;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQuery;

abstract class CompilationUnitReorgChange
extends Change {
    private String fCuHandle;
    private String fOldPackageHandle;
    private String fNewPackageHandle;
    private INewNameQuery fNewNameQuery;

    CompilationUnitReorgChange(ICompilationUnit cu, IPackageFragment dest, INewNameQuery newNameQuery) {
        this.fCuHandle = cu.getHandleIdentifier();
        this.fNewPackageHandle = dest.getHandleIdentifier();
        this.fNewNameQuery = newNameQuery;
        this.fOldPackageHandle = cu.getParent().getHandleIdentifier();
    }

    CompilationUnitReorgChange(ICompilationUnit cu, IPackageFragment dest) {
        this(cu, dest, null);
    }

    CompilationUnitReorgChange(String oldPackageHandle, String newPackageHandle, String cuHandle) {
        this.fOldPackageHandle = oldPackageHandle;
        this.fNewPackageHandle = newPackageHandle;
        this.fCuHandle = cuHandle;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void perform(ChangeContext context, IProgressMonitor pm) throws JavaModelException, ChangeAbortException {
        block6: {
            block5: {
                pm.beginTask(this.getName(), 1);
                try {
                    try {
                        if (!this.isActive()) {
                            Object var4_3 = null;
                            break block5;
                        }
                        this.doPeform((IProgressMonitor)new SubProgressMonitor(pm, 1));
                    }
                    catch (Exception e) {
                        this.handleException(context, e);
                        this.setActive(false);
                    }
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    pm.done();
                    throw throwable;
                }
            }
            pm.done();
            return;
        }
        Object var4_5 = null;
        pm.done();
    }

    abstract void doPeform(IProgressMonitor var1) throws JavaModelException;

    public Object getModifiedLanguageElement() {
        return this.getCu();
    }

    ICompilationUnit getCu() {
        return (ICompilationUnit)JavaCore.create((String)this.fCuHandle);
    }

    IPackageFragment getOldPackage() {
        return (IPackageFragment)JavaCore.create((String)this.fOldPackageHandle);
    }

    IPackageFragment getDestinationPackage() {
        return (IPackageFragment)JavaCore.create((String)this.fNewPackageHandle);
    }

    String getNewName() {
        if (this.fNewNameQuery == null) {
            return null;
        }
        return this.fNewNameQuery.getNewName();
    }

    static String getPackageName(IPackageFragment pack) {
        if (pack.isDefaultPackage()) {
            return RefactoringCoreMessages.getString("MoveCompilationUnitChange.default_package");
        }
        return pack.getElementName();
    }
}

