/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextFileChange;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBufferEditor;

public class CompilationUnitChange
extends TextFileChange {
    private ICompilationUnit fCUnit;

    public CompilationUnitChange(String name, ICompilationUnit cunit) throws CoreException {
        super(name, CompilationUnitChange.getFile(cunit));
        this.fCUnit = cunit;
        Assert.isNotNull(this.fCUnit);
    }

    private static IFile getFile(ICompilationUnit cunit) throws CoreException {
        if (cunit.isWorkingCopy()) {
            cunit = (ICompilationUnit)cunit.getOriginalElement();
        }
        return (IFile)cunit.getResource();
    }

    public Object getModifiedLanguageElement() {
        return this.fCUnit;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCUnit;
    }

    public String getCurrentContent(ISourceReference element) throws CoreException {
        TextBuffer buffer = null;
        try {
            buffer = this.acquireTextBuffer();
            ISourceRange range = element.getSourceRange();
            int offset = buffer.getLineInformationOfOffset(range.getOffset()).getOffset();
            int length = range.getLength() + range.getOffset() - offset;
            String string = buffer.getContent(offset, length);
            Object var6_7 = null;
            if (buffer != null) {
                this.releaseTextBuffer(buffer);
            }
            return string;
        }
        catch (Throwable throwable) {
            block3: {
                Object var6_8 = null;
                if (buffer == null) break block3;
                this.releaseTextBuffer(buffer);
            }
            throw throwable;
        }
    }

    public String getPreviewContent(ISourceReference element, TextChange.EditChange[] changes) throws CoreException {
        TextBuffer buffer = this.createTextBuffer();
        TextBufferEditor editor = new TextBufferEditor(buffer);
        this.addTextEdits(editor, changes);
        int oldLength = buffer.getLength();
        editor.performEdits((IProgressMonitor)new NullProgressMonitor());
        int delta = buffer.getLength() - oldLength;
        ISourceRange range = element.getSourceRange();
        int offset = buffer.getLineInformationOfOffset(range.getOffset()).getOffset();
        int length = range.getLength() + range.getOffset() - offset + delta;
        if (length > 0) {
            return buffer.getContent(offset, length);
        }
        return "";
    }
}

