/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.NullChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.Change;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeAbortException;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DeleteFromClasspathChange;

public class AddToClasspathChange
extends Change {
    private String fProjectHandle;
    private int fEntryKind;
    private int fContentKind;
    private IPath fPath;
    private IPath fSourceAttachmentPath;
    private IPath fSourceAttachmentRootPath;

    public AddToClasspathChange(IJavaProject project, String sourceFolderName) {
        this.fProjectHandle = project.getHandleIdentifier();
        this.fEntryKind = 3;
        this.fPath = project.getProject().getFullPath().append(sourceFolderName);
    }

    public AddToClasspathChange(IJavaProject project, IPath newProjectEntry) {
        Assert.isTrue(newProjectEntry.isAbsolute());
        this.fProjectHandle = project.getHandleIdentifier();
        this.fEntryKind = 2;
        this.fPath = newProjectEntry;
    }

    public AddToClasspathChange(IJavaProject project, int entryKind, int contentKind, IPath path, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath) {
        this.fProjectHandle = project.getHandleIdentifier();
        this.fEntryKind = entryKind;
        this.fContentKind = contentKind;
        this.fPath = path;
        this.fSourceAttachmentPath = sourceAttachmentPath;
        this.fSourceAttachmentRootPath = sourceAttachmentRootPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void perform(ChangeContext context, IProgressMonitor pm) throws JavaModelException, ChangeAbortException {
        block6: {
            block5: {
                pm.beginTask(this.getName(), 1);
                try {
                    if (!this.isActive()) {
                        Object var3_3 = null;
                        break block5;
                    }
                    if (!this.entryAlreadyExists()) {
                        this.getJavaProject().setRawClasspath(this.getNewClasspathEntries(), (IProgressMonitor)new SubProgressMonitor(pm, 1));
                        break block6;
                    } else {
                        this.setActive(false);
                    }
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    pm.done();
                    throw throwable;
                }
            }
            pm.done();
            return;
        }
        Object var3_5 = null;
        pm.done();
    }

    private boolean entryAlreadyExists() throws JavaModelException {
        return Arrays.asList(this.getJavaProject().getRawClasspath()).contains(this.createNewClasspathEntry());
    }

    private IClasspathEntry[] getNewClasspathEntries() throws JavaModelException {
        IClasspathEntry[] entries = this.getJavaProject().getRawClasspath();
        ArrayList<IClasspathEntry> cp = new ArrayList<IClasspathEntry>(entries.length + 1);
        cp.addAll(Arrays.asList(entries));
        cp.add(this.createNewClasspathEntry());
        return cp.toArray(new IClasspathEntry[cp.size()]);
    }

    private IClasspathEntry createNewClasspathEntry() {
        switch (this.fEntryKind) {
            case 1: {
                return JavaCore.newLibraryEntry((IPath)this.fPath, (IPath)this.fSourceAttachmentPath, (IPath)this.fSourceAttachmentRootPath);
            }
            case 2: {
                return JavaCore.newProjectEntry((IPath)this.fPath);
            }
            case 3: {
                return JavaCore.newSourceEntry((IPath)this.fPath);
            }
            case 4: {
                return JavaCore.newVariableEntry((IPath)this.fPath, (IPath)this.fSourceAttachmentPath, (IPath)this.fSourceAttachmentRootPath);
            }
            case 5: {
                return JavaCore.newContainerEntry((IPath)this.fPath);
            }
        }
        Assert.isTrue(false);
        return null;
    }

    private IJavaProject getJavaProject() {
        return (IJavaProject)JavaCore.create((String)this.fProjectHandle);
    }

    public IChange getUndoChange() {
        if (!this.isActive()) {
            return new NullChange();
        }
        IPath classpathEntryPath = JavaCore.getResolvedClasspathEntry((IClasspathEntry)this.createNewClasspathEntry()).getPath();
        return new DeleteFromClasspathChange(classpathEntryPath, this.getJavaProject());
    }

    public String getName() {
        return String.valueOf(RefactoringCoreMessages.getString("AddToClasspathChange.add")) + this.getJavaProject().getElementName();
    }

    public Object getModifiedLanguageElement() {
        return this.getJavaProject();
    }
}

