/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.NullChange;
import org.eclipse.jdt.internal.corext.refactoring.base.Change;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeAbortException;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBufferEditor;
import org.eclipse.jdt.internal.corext.textmanipulation.UndoMemento;

public abstract class AbstractTextChange
extends Change {
    private String fName;
    private int fChangeKind;
    private IChange fUndoChange;
    protected static final int ORIGINAL_CHANGE = 0;
    protected static final int UNDO_CHANGE = 1;
    protected static final int REDO_CHANGE = 2;

    protected AbstractTextChange(String name, int changeKind) {
        this.fName = name;
        Assert.isNotNull(this.fName);
        this.fChangeKind = changeKind;
        Assert.isTrue(this.fChangeKind >= 0 && this.fChangeKind <= 2);
    }

    protected abstract TextBuffer acquireTextBuffer() throws CoreException;

    protected abstract void releaseTextBuffer(TextBuffer var1);

    protected abstract TextBuffer createTextBuffer() throws CoreException;

    protected abstract void addTextEdits(TextBufferEditor var1) throws CoreException;

    protected abstract IChange createReverseChange(UndoMemento var1, int var2);

    public boolean isReverseChange() {
        return this.fChangeKind != 0;
    }

    protected int getReverseKind() {
        if (this.fChangeKind == 0 || this.fChangeKind == 2) {
            return 1;
        }
        return 2;
    }

    public String getName() {
        return this.fName;
    }

    public IChange getUndoChange() {
        return this.fUndoChange;
    }

    public void perform(ChangeContext context, IProgressMonitor pm) throws JavaModelException, ChangeAbortException {
        block6: {
            if (!this.isActive()) {
                this.fUndoChange = new NullChange();
                return;
            }
            TextBufferEditor editor = null;
            try {
                try {
                    this.fUndoChange = null;
                    editor = new TextBufferEditor(this.acquireTextBuffer());
                    this.addTextEdits(editor);
                    this.fUndoChange = this.createReverseChange(editor.performEdits(pm), this.getReverseKind());
                }
                catch (Exception e) {
                    this.handleException(context, e);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (editor != null) {
                    editor.clear();
                    this.releaseTextBuffer(editor.getTextBuffer());
                }
                throw throwable;
            }
            Object var5_7 = null;
            if (editor == null) break block6;
            editor.clear();
            this.releaseTextBuffer(editor.getTextBuffer());
        }
    }
}

