/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.base.Context;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatusEntry;

public class RefactoringStatus {
    public static final int OK = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 3;
    public static final int FATAL = 4;
    private List fEntries = new ArrayList(0);
    private int fSeverity = 0;

    public static RefactoringStatus createInfoStatus(String msg) {
        return RefactoringStatus.createStatus(1, msg);
    }

    public static RefactoringStatus createInfoStatus(String msg, Context context) {
        return RefactoringStatus.createStatus(1, msg, context);
    }

    public static RefactoringStatus createWarningStatus(String msg) {
        return RefactoringStatus.createStatus(2, msg);
    }

    public static RefactoringStatus createWarningStatus(String msg, Context context) {
        return RefactoringStatus.createStatus(2, msg, context);
    }

    public static RefactoringStatus createErrorStatus(String msg) {
        return RefactoringStatus.createStatus(3, msg);
    }

    public static RefactoringStatus createErrorStatus(String msg, Context context) {
        return RefactoringStatus.createStatus(3, msg, context);
    }

    public static RefactoringStatus createFatalErrorStatus(String msg) {
        return RefactoringStatus.createStatus(4, msg);
    }

    public static RefactoringStatus createFatalErrorStatus(String msg, Context context) {
        return RefactoringStatus.createStatus(4, msg, context);
    }

    public static RefactoringStatus create(IStatus status) {
        if (status.isOK()) {
            return new RefactoringStatus();
        }
        if (!status.isMultiStatus()) {
            switch (status.getSeverity()) {
                case 1: {
                    return RefactoringStatus.createWarningStatus(status.getMessage());
                }
                case 2: {
                    return RefactoringStatus.createErrorStatus(status.getMessage());
                }
                case 4: {
                    return RefactoringStatus.createFatalErrorStatus(status.getMessage());
                }
            }
            return new RefactoringStatus();
        }
        IStatus[] children = status.getChildren();
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < children.length) {
            result.merge(RefactoringStatus.create(children[i]));
            ++i;
        }
        return result;
    }

    public static RefactoringStatus createStatus(int severity, String msg, Context context, Object data, int code) {
        RefactoringStatus result = new RefactoringStatus();
        result.fEntries.add(new RefactoringStatusEntry(msg, severity, context, data, code));
        result.fSeverity = severity;
        return result;
    }

    public static RefactoringStatus createStatus(int severity, String msg, Context context) {
        return RefactoringStatus.createStatus(severity, msg, context, null, 0);
    }

    public static RefactoringStatus createStatus(int severity, String msg) {
        return RefactoringStatus.createStatus(severity, msg, null);
    }

    public void addInfo(String msg) {
        this.addInfo(msg, null);
    }

    public void addInfo(String msg, Context context) {
        this.fEntries.add(RefactoringStatusEntry.createInfo(msg, context));
        this.fSeverity = Math.max(this.fSeverity, 1);
    }

    public void addWarning(String msg) {
        this.addWarning(msg, null);
    }

    public void addWarning(String msg, Context context) {
        this.fEntries.add(RefactoringStatusEntry.createWarning(msg, context));
        this.fSeverity = Math.max(this.fSeverity, 2);
    }

    public void addError(String msg) {
        this.addError(msg, null);
    }

    public void addError(String msg, Context context) {
        this.fEntries.add(RefactoringStatusEntry.createError(msg, context));
        this.fSeverity = Math.max(this.fSeverity, 3);
    }

    public void addFatalError(String msg) {
        this.addFatalError(msg, null);
    }

    public void addFatalError(String msg, Context context) {
        this.fEntries.add(RefactoringStatusEntry.createFatal(msg, context));
        this.fSeverity = Math.max(this.fSeverity, 4);
    }

    public void addEntry(RefactoringStatusEntry entry) {
        Assert.isNotNull(entry);
        this.fEntries.add(entry);
        this.fSeverity = Math.max(this.fSeverity, entry.getSeverity());
    }

    public boolean isOK() {
        return this.fSeverity == 0;
    }

    public boolean hasFatalError() {
        return this.fSeverity == 4;
    }

    public boolean hasError() {
        return this.fSeverity == 4 || this.fSeverity == 3;
    }

    public boolean hasWarning() {
        return this.fSeverity == 4 || this.fSeverity == 3 || this.fSeverity == 2;
    }

    public boolean hasEntryWithCode(int code) {
        Iterator iter = this.fEntries.iterator();
        while (iter.hasNext()) {
            RefactoringStatusEntry entry = (RefactoringStatusEntry)iter.next();
            if (entry.getCode() != code) continue;
            return true;
        }
        return false;
    }

    public void merge(RefactoringStatus that) {
        if (that == null) {
            return;
        }
        this.fEntries.addAll(that.getEntries());
        this.fSeverity = Math.max(this.fSeverity, that.getSeverity());
    }

    public int getSeverity() {
        return this.fSeverity;
    }

    public List getEntries() {
        return this.fEntries;
    }

    public RefactoringStatusEntry getEntry(int index) {
        return (RefactoringStatusEntry)this.fEntries.get(index);
    }

    public RefactoringStatusEntry getFirstEntry(int severity) {
        Assert.isTrue(severity >= 0 && severity <= 4);
        if (severity > this.fSeverity) {
            return null;
        }
        Iterator iter = this.fEntries.iterator();
        while (iter.hasNext()) {
            RefactoringStatusEntry entry = (RefactoringStatusEntry)iter.next();
            if (entry.getSeverity() < severity) continue;
            return entry;
        }
        return null;
    }

    public String getFirstMessage(int severity) {
        RefactoringStatusEntry entry = this.getFirstEntry(severity);
        if (entry == null) {
            return null;
        }
        return entry.getMessage();
    }

    static String getSeverityString(int severity) {
        Assert.isTrue(severity >= 0 && severity <= 4);
        if (severity == 0) {
            return "OK";
        }
        if (severity == 1) {
            return "INFO";
        }
        if (severity == 2) {
            return "WARNING";
        }
        if (severity == 3) {
            return "ERROR";
        }
        if (severity == 4) {
            return "FATALERROR";
        }
        return null;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("<").append(RefactoringStatus.getSeverityString(this.fSeverity)).append("\n");
        if (!this.isOK()) {
            Iterator iter = this.fEntries.iterator();
            while (iter.hasNext()) {
                buff.append("\t").append(iter.next()).append("\n");
            }
        }
        buff.append(">");
        return buff.toString();
    }
}

