/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.base;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.dom.Binding2JavaModel;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.refactoring.base.Context;

public abstract class JavaSourceContext
extends Context {
    public static Context create(IMember member) {
        if (member == null || !member.exists()) {
            return Context.NULL_CONTEXT;
        }
        return new MemberSourceContext(member);
    }

    public static Context create(IImportDeclaration declaration) {
        if (declaration == null || !declaration.exists()) {
            return Context.NULL_CONTEXT;
        }
        return new ImportDeclarationSourceContext(declaration);
    }

    public static Context create(IMethodBinding method, IJavaProject scope) {
        ITypeBinding declaringClass = method.getDeclaringClass();
        IMethod mr = null;
        try {
            IType resource = Binding2JavaModel.find(declaringClass, scope);
            if (resource != null) {
                mr = Binding2JavaModel.find(method, resource);
            }
        }
        catch (JavaModelException javaModelException) {}
        return JavaSourceContext.create(mr);
    }

    public static Context create(ICompilationUnit cunit) {
        return JavaSourceContext.create(cunit, null);
    }

    public static Context create(ICompilationUnit cunit, ISourceRange range) {
        if (cunit == null) {
            return Context.NULL_CONTEXT;
        }
        return new CompilationUnitSourceContext(cunit, range);
    }

    public static Context create(ICompilationUnit cunit, ASTNode node) {
        SourceRange range = null;
        if (node != null) {
            range = new SourceRange(node.getStartPosition(), node.getLength());
        }
        return JavaSourceContext.create(cunit, range);
    }

    public static Context create(ICompilationUnit cunit, Selection selection) {
        SourceRange range = null;
        if (selection != null) {
            range = new SourceRange(selection.getOffset(), selection.getLength());
        }
        return JavaSourceContext.create(cunit, range);
    }

    public abstract boolean isBinary();

    public abstract ICompilationUnit getCompilationUnit();

    public abstract IClassFile getClassFile();

    public abstract ISourceRange getSourceRange();

    public IAdaptable getCorrespondingElement() {
        if (this.isBinary()) {
            return this.getClassFile();
        }
        return this.getCompilationUnit();
    }

    private static class MemberSourceContext
    extends JavaSourceContext {
        private IMember fMember;

        MemberSourceContext(IMember member) {
            this.fMember = member;
        }

        public boolean isBinary() {
            return this.fMember.isBinary();
        }

        public ICompilationUnit getCompilationUnit() {
            return this.fMember.getCompilationUnit();
        }

        public IClassFile getClassFile() {
            return this.fMember.getClassFile();
        }

        public ISourceRange getSourceRange() {
            try {
                return this.fMember.getSourceRange();
            }
            catch (JavaModelException javaModelException) {
                return new SourceRange(0, 0);
            }
        }
    }

    private static class ImportDeclarationSourceContext
    extends JavaSourceContext {
        private IImportDeclaration fImportDeclartion;

        ImportDeclarationSourceContext(IImportDeclaration declaration) {
            this.fImportDeclartion = declaration;
        }

        public boolean isBinary() {
            return false;
        }

        public ICompilationUnit getCompilationUnit() {
            return (ICompilationUnit)this.fImportDeclartion.getParent().getParent();
        }

        public IClassFile getClassFile() {
            return null;
        }

        public ISourceRange getSourceRange() {
            try {
                return this.fImportDeclartion.getSourceRange();
            }
            catch (JavaModelException javaModelException) {
                return new SourceRange(0, 0);
            }
        }
    }

    private static class CompilationUnitSourceContext
    extends JavaSourceContext {
        private ICompilationUnit fCUnit;
        private ISourceRange fSourceRange;

        CompilationUnitSourceContext(ICompilationUnit cunit, ISourceRange range) {
            this.fCUnit = cunit;
            this.fSourceRange = range;
            if (this.fSourceRange == null) {
                this.fSourceRange = new SourceRange(0, 0);
            }
        }

        public boolean isBinary() {
            return false;
        }

        public ICompilationUnit getCompilationUnit() {
            return this.fCUnit;
        }

        public IClassFile getClassFile() {
            return null;
        }

        public ISourceRange getSourceRange() {
            return this.fSourceRange;
        }
    }
}

