/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.base;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.internal.corext.refactoring.base.Context;

public class FileContext
extends Context {
    private IFile fFile;
    private ISourceRange fSourceRange;

    private FileContext(IFile file, ISourceRange range) {
        this.fFile = file;
        this.fSourceRange = range;
    }

    public static Context create(IFile file, ISourceRange range) {
        if (file == null) {
            return Context.NULL_CONTEXT;
        }
        return new FileContext(file, range);
    }

    public static Context create(IResource resource, ISourceRange range) {
        if (resource instanceof IFile) {
            return FileContext.create((IFile)resource, range);
        }
        return Context.NULL_CONTEXT;
    }

    public IFile getFile() {
        return this.fFile;
    }

    public ISourceRange getSourceRange() {
        return this.fSourceRange;
    }

    public IAdaptable getCorrespondingElement() {
        return this.getFile();
    }
}

